/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.item;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.mixin.core.entity.LivingEntityMixin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ArmorStandEntity.class})
public abstract class ArmorStandEntityMixin
extends LivingEntityMixin {
    @Shadow
    private boolean field_175436_h;

    @Override
    @Shadow
    public abstract net.minecraft.item.ItemStack func_184582_a(EquipmentSlotType var1);

    @Override
    public float getBukkitYaw() {
        return this.field_70177_z;
    }

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/item/ArmorStandEntity;remove()V")})
    public void arclight$damageDropOut(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)((ArmorStandEntity)this), source, amount)) {
            cir.setReturnValue((Object)false);
        } else {
            this.arclight$callEntityDeath();
        }
    }

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isExplosion()Z")})
    public void arclight$damageNormal(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)((ArmorStandEntity)this), source, amount, true, this.field_175436_h)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/item/ArmorStandEntity;canInteract:Z"))
    private boolean arclight$softenCondition(ArmorStandEntity entity) {
        return false;
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/item/ArmorStandEntity;remove()V")})
    private void arclight$damageDeath1(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$callEntityDeath();
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", ordinal=2, target="Lnet/minecraft/entity/item/ArmorStandEntity;remove()V")})
    private void arclight$damageDeath2(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$callEntityDeath();
    }

    @Inject(method={"func_213817_e"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;remove()V")})
    private void arclight$deathEvent2(DamageSource p_213817_1_, float p_213817_2_, CallbackInfo ci) {
        this.arclight$callEntityDeath();
    }

    @Redirect(method={"func_213815_f"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;spawnAsEntity(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)V"))
    private void arclight$captureDrops1(World worldIn, BlockPos pos, net.minecraft.item.ItemStack stack) {
        this.arclight$tryCaptureDrops(worldIn, pos, stack);
    }

    @Redirect(method={"func_213816_g"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;spawnDrops(Lnet/minecraft/util/DamageSource;)V"))
    private void arclight$dropLater(ArmorStandEntity entity, DamageSource damageSourceIn) {
    }

    @Redirect(method={"func_213816_g"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;spawnAsEntity(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)V"))
    private void arclight$captureDropsDeath(World worldIn, BlockPos pos, net.minecraft.item.ItemStack stack) {
        this.arclight$tryCaptureDrops(worldIn, pos, stack);
    }

    @Inject(method={"func_213816_g"}, at={@At(value="RETURN")})
    private void arclight$spawnLast(DamageSource source, CallbackInfo ci) {
        this.func_213345_d(source);
    }

    @Override
    protected boolean func_146066_aG() {
        return true;
    }

    @Inject(method={"onKillCommand"}, at={@At(value="HEAD")})
    private void arclight$deathEvent(CallbackInfo ci) {
        this.arclight$callEntityDeath();
    }

    private void arclight$tryCaptureDrops(World worldIn, BlockPos pos, net.minecraft.item.ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            this.arclight$drops().add(itementity);
        }
    }

    private Collection<ItemEntity> arclight$drops() {
        Collection<ItemEntity> drops = this.captureDrops();
        if (drops == null) {
            ArrayList<ItemEntity> list = new ArrayList<ItemEntity>();
            this.captureDrops(list);
            return list;
        }
        return drops;
    }

    private void arclight$callEntityDeath() {
        Collection<ItemEntity> captureDrops = this.captureDrops(null);
        List<ItemStack> drops = captureDrops == null ? new ArrayList<ItemStack>() : (captureDrops instanceof List ? Lists.transform((List)captureDrops, e -> CraftItemStack.asCraftMirror(e.func_92059_d())) : captureDrops.stream().map(ItemEntity::func_92059_d).map(CraftItemStack::asCraftMirror).collect(Collectors.toList()));
        CraftEventFactory.callEntityDeathEvent((LivingEntity)((ArmorStandEntity)this), drops);
    }

    @Inject(method={"func_226529_a_"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;abilities:Lnet/minecraft/entity/player/PlayerAbilities;")})
    public void arclight$manipulateEvent(PlayerEntity playerEntity, EquipmentSlotType slotType, net.minecraft.item.ItemStack itemStack, Hand hand, CallbackInfoReturnable<Boolean> cir) {
        net.minecraft.item.ItemStack itemStack1 = this.func_184582_a(slotType);
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemStack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(itemStack);
        CraftPlayer player = ((ServerPlayerEntityBridge)playerEntity).bridge$getBukkitEntity();
        ArmorStand self = (ArmorStand)((Object)this.bridge$getBukkitEntity());
        EquipmentSlot slot = CraftEquipmentSlot.getSlot(slotType);
        PlayerArmorStandManipulateEvent event = new PlayerArmorStandManipulateEvent(player, self, playerHeldItem, armorStandItem, slot);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)true);
        }
    }
}

