/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.tileentity;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.tileentity.TileEntityMixin;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeehiveTileEntity.class})
public abstract class BeehiveTileEntityMixin
extends TileEntityMixin {
    @Shadow
    @Final
    private List<BeehiveTileEntity.Bee> field_226958_a_;
    public int maxBees = 3;
    private transient boolean arclight$force;

    @Shadow
    protected abstract boolean func_226967_a_(BlockState var1, CompoundNBT var2, @Nullable List<Entity> var3, BeehiveTileEntity.State var4);

    @Overwrite
    public boolean func_226970_h_() {
        return this.field_226958_a_.size() >= this.maxBees;
    }

    public List<Entity> tryReleaseBee(BlockState blockState, BeehiveTileEntity.State state, boolean force) {
        ArrayList<Entity> list = Lists.newArrayList();
        this.field_226958_a_.removeIf(bee -> this.releaseBee(blockState, bee.field_226977_a_, list, state, force));
        return list;
    }

    @Inject(method={"tryEnterHive(Lnet/minecraft/entity/Entity;ZI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;stopRiding()V")})
    private void arclight$beeEnterBlock(Entity entity, boolean p_226962_2_, int p_226962_3_, CallbackInfo ci) {
        if (this.field_145850_b != null) {
            EntityEnterBlockEvent event = new EntityEnterBlockEvent(((EntityBridge)entity).bridge$getBukkitEntity(), CraftBlock.at((IWorld)this.field_145850_b, this.func_174877_v()));
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                if (entity instanceof BeeEntity) {
                    ((BeeEntity)entity).func_226450_t_(400);
                }
                ci.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseBee(BlockState blockState, CompoundNBT nbt, @Nullable List<Entity> list, BeehiveTileEntity.State state, boolean force) {
        this.arclight$force = force;
        try {
            boolean bl = this.func_226967_a_(blockState, nbt, list, state);
            return bl;
        }
        finally {
            this.arclight$force = false;
        }
    }

    @Redirect(method={"releaseBee"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isNightTime()Z"))
    private boolean arclight$bypassNightCheck(World world) {
        return !this.arclight$force && world.func_226690_K_();
    }

    @Redirect(method={"releaseBee"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getType()Lnet/minecraft/entity/EntityType;"))
    private EntityType<?> arclight$spawnFirst(Entity entity) {
        EntityType type = entity.func_200600_R();
        if (type.func_220341_a(EntityTypeTags.field_226155_c_)) {
            ((WorldBridge)this.field_145850_b).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.BEEHIVE);
            if (!this.field_145850_b.func_217376_c(entity)) {
                return EntityType.field_200766_F;
            }
            return type;
        }
        return type;
    }

    @Redirect(method={"releaseBee"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z"))
    private boolean arclight$addedBefore(World world, Entity entityIn) {
        return true;
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void arclight$readMax(CompoundNBT compound, CallbackInfo ci) {
        if (compound.func_74764_b("Bukkit.MaxEntities")) {
            this.maxBees = compound.func_74762_e("Bukkit.MaxEntities");
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void arclight$writeMax(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        compound.func_74768_a("Bukkit.MaxEntities", this.maxBees);
    }
}

