/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.tileentity;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mysql.jdbc.StringUtils;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.mixin.core.tileentity.TileEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightHeadLoader;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.SkullTileEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SkullTileEntity.class})
public abstract class SkullTileEntityMixin
extends TileEntityMixin {
    @Shadow
    public GameProfile field_152110_j;
    private static ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("Head Conversion Thread - %1$d").build());
    private static LoadingCache<String, GameProfile> skinCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterAccess(60L, TimeUnit.MINUTES).build(new ArclightHeadLoader());

    @Overwrite
    private void func_152109_d() {
        GameProfile profile = this.field_152110_j;
        SkullTileEntityMixin.b(profile, input -> {
            this.field_152110_j = input;
            this.func_70296_d();
            return false;
        }, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Future<GameProfile> b(GameProfile gameprofile, Predicate<GameProfile> callback, boolean sync) {
        if (gameprofile != null && !StringUtils.isNullOrEmpty((String)gameprofile.getName())) {
            if (gameprofile.isComplete() && gameprofile.getProperties().containsKey((Object)"textures")) {
                callback.apply(gameprofile);
                return Futures.immediateFuture(gameprofile);
            }
            if (Bukkit.getServer() == null || ((CraftServer)Bukkit.getServer()).getServer() == null) {
                callback.apply(gameprofile);
                return Futures.immediateFuture(gameprofile);
            }
            GameProfile profile = (GameProfile)skinCache.getIfPresent(gameprofile.getName().toLowerCase(Locale.ROOT));
            if (profile != null && Iterables.getFirst(profile.getProperties().get((Object)"textures"), null) != null) {
                callback.apply(profile);
                return Futures.immediateFuture(profile);
            }
            Callable<GameProfile> callable = () -> {
                GameProfile profile1 = skinCache.getUnchecked(gameprofile.getName().toLowerCase(Locale.ROOT));
                ((MinecraftServerBridge)((CraftServer)Bukkit.getServer()).getServer()).bridge$queuedProcess(() -> {
                    if (profile1 == null) {
                        callback.apply(gameprofile);
                    } else {
                        callback.apply(profile1);
                    }
                });
                return profile1;
            };
            if (!sync) return executor.submit(callable);
            try {
                return Futures.immediateFuture(callable.call());
            }
            catch (Exception ex) {
                Throwables.throwIfUnchecked(ex);
                throw new RuntimeException(ex);
            }
        }
        callback.apply(gameprofile);
        return Futures.immediateFuture(gameprofile);
    }
}

