/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.server;

import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.server.ChunkHolderBridge;
import io.izzel.arclight.common.bridge.world.server.ChunkManagerBridge;
import io.izzel.arclight.common.bridge.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.world.server.TicketManagerBridge;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerChunkProvider.class})
public abstract class ServerChunkProviderMixin
implements ServerChunkProviderBridge {
    @Shadow
    @Final
    private ServerWorldLightManager field_217242_h;
    @Shadow
    @Final
    public ChunkManager field_217237_a;
    @Shadow
    @Final
    public ServerWorld field_73251_h;
    @Shadow
    @Final
    private TicketManager field_217240_d;
    @Shadow
    private long field_217245_k;
    @Shadow
    public boolean field_217246_l;
    @Shadow
    public boolean field_217247_m;
    @Shadow
    @Final
    private static int field_217238_b;
    @Shadow
    @Final
    public ChunkGenerator<?> field_186029_c;

    @Shadow
    public abstract void func_217210_a(boolean var1);

    @Shadow
    protected abstract void func_222869_l();

    @Shadow
    @Nullable
    protected abstract ChunkHolder func_217213_a(long var1);

    @Shadow
    protected abstract boolean func_217235_l();

    @Shadow
    protected abstract boolean func_217224_a(@Nullable ChunkHolder var1, int var2);

    @Override
    @Invoker(value="func_217235_l")
    public abstract boolean bridge$tickDistanceManager();

    @Override
    @Accessor(value="lightManager")
    public abstract ServerWorldLightManager bridge$getLightManager();

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = ((ChunkManagerBridge)this.field_217237_a).bridge$chunkHolderAt(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
        return chunk != null && ((ChunkHolderBridge)chunk).bridge$getFullChunk() != null;
    }

    @Override
    public boolean bridge$isChunkLoaded(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    @Overwrite
    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_217233_c(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        long i = chunkpos.func_201841_a();
        int j = 33 + ChunkStatus.func_222599_a((ChunkStatus)requiredStatus);
        ChunkHolder chunkholder = this.func_217213_a(i);
        boolean unloading = false;
        if (chunkholder != null) {
            ChunkHolder.LocationType chunkStatus = ChunkHolder.func_219286_c((int)((ChunkHolderBridge)chunkholder).bridge$getOldTicketLevel());
            ChunkHolder.LocationType currentStatus = ChunkHolder.func_219286_c((int)chunkholder.func_219299_i());
            boolean bl = unloading = chunkStatus.func_219065_a(ChunkHolder.LocationType.BORDER) && !currentStatus.func_219065_a(ChunkHolder.LocationType.BORDER);
        }
        if (load && !unloading) {
            this.field_217240_d.func_219356_a(TicketType.field_219494_g, chunkpos, j, (Object)chunkpos);
            if (this.func_217224_a(chunkholder, j)) {
                IProfiler iprofiler = this.field_73251_h.func_217381_Z();
                iprofiler.func_76320_a("chunkLoad");
                this.func_217235_l();
                chunkholder = this.func_217213_a(i);
                iprofiler.func_76319_b();
                if (this.func_217224_a(chunkholder, j)) {
                    throw new IllegalStateException("No chunk holder after ticket has been added");
                }
            }
        }
        return this.func_217224_a(chunkholder, j) ? ChunkHolder.field_219307_b : chunkholder.func_219276_a(requiredStatus, this.field_217237_a);
    }

    @Overwrite
    private void func_217220_m() {
        boolean flag1;
        long i = this.field_73251_h.func_82737_E();
        long j = i - this.field_217245_k;
        this.field_217245_k = i;
        WorldInfo worldinfo = this.field_73251_h.func_72912_H();
        boolean flag = worldinfo.func_76067_t() == WorldType.field_180272_g;
        boolean bl = flag1 = this.field_73251_h.func_82736_K().func_223586_b(GameRules.field_223601_d) && !this.field_73251_h.func_217369_A().isEmpty();
        if (!flag) {
            this.field_73251_h.func_217381_Z().func_76320_a("pollingChunks");
            int k = this.field_73251_h.func_82736_K().func_223592_c(GameRules.field_223610_m);
            BlockPos blockpos = this.field_73251_h.func_175694_M();
            boolean spawnAnimal = ((WorldBridge)this.field_73251_h).bridge$ticksPerAnimalSpawns() != 0L && worldinfo.func_82573_f() % ((WorldBridge)this.field_73251_h).bridge$ticksPerAnimalSpawns() == 0L;
            boolean spawnMonster = ((WorldBridge)this.field_73251_h).bridge$ticksPerMonsterSpawns() != 0L && worldinfo.func_82573_f() % ((WorldBridge)this.field_73251_h).bridge$ticksPerMonsterSpawns() == 0L;
            boolean spawnWater = ((WorldBridge)this.field_73251_h).bridge$ticksPerWaterSpawns() != 0L && worldinfo.func_82573_f() % ((WorldBridge)this.field_73251_h).bridge$ticksPerWaterSpawns() == 0L;
            boolean spawnAmbient = ((WorldBridge)this.field_73251_h).bridge$ticksPerAmbientSpawns() != 0L && worldinfo.func_82573_f() % ((WorldBridge)this.field_73251_h).bridge$ticksPerAmbientSpawns() == 0L;
            boolean flag2 = spawnAnimal;
            this.field_73251_h.func_217381_Z().func_76320_a("naturalSpawnCount");
            int l = this.field_217240_d.func_219358_b();
            EntityClassification[] aentityclassification = EntityClassification.values();
            Object2IntMap object2intmap = this.field_73251_h.func_217450_l();
            this.field_73251_h.func_217381_Z().func_76319_b();
            ((ChunkManagerBridge)this.field_217237_a).bridge$getLoadedChunksIterable().forEach(p_223434_10_ -> {
                Optional optional = p_223434_10_.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (optional.isPresent()) {
                    Chunk chunk = (Chunk)optional.get();
                    this.field_73251_h.func_217381_Z().func_76320_a("broadcast");
                    p_223434_10_.func_219274_a(chunk);
                    this.field_73251_h.func_217381_Z().func_76319_b();
                    ChunkPos chunkpos = p_223434_10_.func_219277_h();
                    if (!((ChunkManagerBridge)this.field_217237_a).bridge$isOutsideSpawningRadius(chunkpos)) {
                        chunk.func_177415_c(chunk.func_177416_w() + j);
                        if (flag1 && (this.field_217246_l || this.field_217247_m) && this.field_73251_h.func_175723_af().func_177730_a(chunk.func_76632_l())) {
                            this.field_73251_h.func_217381_Z().func_76320_a("spawner");
                            for (EntityClassification entityclassification : aentityclassification) {
                                boolean spawnThisTick = true;
                                int limit = entityclassification.func_75601_b();
                                switch (entityclassification) {
                                    case MONSTER: {
                                        spawnThisTick = spawnMonster;
                                        limit = ((WorldBridge)this.field_73251_h).bridge$getWorld().getMonsterSpawnLimit();
                                        break;
                                    }
                                    case CREATURE: {
                                        spawnThisTick = spawnAnimal;
                                        limit = ((WorldBridge)this.field_73251_h).bridge$getWorld().getAnimalSpawnLimit();
                                        break;
                                    }
                                    case WATER_CREATURE: {
                                        spawnThisTick = spawnWater;
                                        limit = ((WorldBridge)this.field_73251_h).bridge$getWorld().getWaterAnimalSpawnLimit();
                                        break;
                                    }
                                    case AMBIENT: {
                                        spawnThisTick = spawnAmbient;
                                        limit = ((WorldBridge)this.field_73251_h).bridge$getWorld().getAmbientSpawnLimit();
                                    }
                                }
                                if (!spawnThisTick || limit == 0 || entityclassification == EntityClassification.MISC || entityclassification.func_75599_d() && !this.field_217247_m || !entityclassification.func_75599_d() && !this.field_217246_l || entityclassification.func_82705_e() && !flag2) continue;
                                int i1 = limit * l / field_217238_b;
                                if (object2intmap.getInt((Object)entityclassification) > i1) continue;
                                WorldEntitySpawner.func_226701_a_((EntityClassification)entityclassification, (ServerWorld)this.field_73251_h, (Chunk)chunk, (BlockPos)blockpos);
                            }
                            this.field_73251_h.func_217381_Z().func_76319_b();
                        }
                        this.field_73251_h.func_217441_a(chunk, k);
                    }
                }
            });
            this.field_73251_h.func_217381_Z().func_76320_a("customSpawners");
            if (flag1) {
                this.field_186029_c.func_203222_a(this.field_73251_h, this.field_217246_l, this.field_217247_m);
            }
            this.field_73251_h.func_217381_Z().func_76319_b();
            this.field_73251_h.func_217381_Z().func_76319_b();
        }
        ((ChunkManagerBridge)this.field_217237_a).bridge$tickEntityTracker();
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.func_217210_a(true);
        }
        this.field_217242_h.close();
        this.field_217237_a.close();
    }

    public void purgeUnload() {
        this.field_73251_h.func_217381_Z().func_76320_a("purge");
        ((TicketManagerBridge)this.field_217240_d).bridge$tick();
        this.bridge$tickDistanceManager();
        this.field_73251_h.func_217381_Z().func_219895_b("unload");
        ((ChunkManagerBridge)this.field_217237_a).bridge$tick(() -> true);
        this.field_73251_h.func_217381_Z().func_76319_b();
        this.func_222869_l();
    }

    @Override
    public void bridge$close(boolean save) throws IOException {
        this.close(save);
    }

    @Override
    public void bridge$purgeUnload() {
        this.purgeUnload();
    }

    @Redirect(method={"func_217224_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkHolder;getChunkLevel()I"))
    public int arclight$useOldTicketLevel(ChunkHolder chunkHolder) {
        return ((ChunkHolderBridge)chunkHolder).bridge$getOldTicketLevel();
    }
}

