/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.server;

import io.izzel.arclight.common.bridge.world.server.TicketManagerBridge;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(value={TicketManager.class})
public abstract class TicketManagerMixin
implements TicketManagerBridge {
    @Shadow
    private long field_219389_q;
    @Shadow
    @Final
    private TicketManager.ChunkTicketTracker field_219378_f;
    @Shadow
    @Final
    public Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> field_219377_e;

    @Shadow
    protected abstract SortedArraySet<Ticket<?>> func_229848_e_(long var1);

    @Shadow
    private static int func_229844_a_(SortedArraySet<Ticket<?>> p_229844_0_) {
        return 0;
    }

    @Override
    @Invoker(value="tick")
    public abstract void bridge$tick();

    public <T> boolean func_219356_a(TicketType<T> type, ChunkPos pos, int level, T value) {
        return this.addTicketAtLevel(type, pos, level, value);
    }

    public <T> boolean func_219345_b(TicketType<T> type, ChunkPos pos, int level, T value) {
        return this.removeTicketAtLevel(type, pos, level, value);
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket ticket = new Ticket(type, level, value);
        return this.addTicket(pos.func_201841_a(), ticket);
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket ticket = new Ticket(type, level, value);
        return this.removeTicket(pos.func_201841_a(), ticket);
    }

    @Override
    public <T> boolean bridge$addTicketAtLevel(TicketType<T> type, ChunkPos pos, int level, T value) {
        return this.addTicketAtLevel(type, pos, level, value);
    }

    @Override
    public <T> boolean bridge$removeTicketAtLevel(TicketType<T> type, ChunkPos pos, int level, T value) {
        return this.removeTicketAtLevel(type, pos, level, value);
    }

    private boolean func_219349_b(long chunkPosIn, Ticket<?> ticketIn) {
        return this.removeTicket(chunkPosIn, ticketIn);
    }

    private boolean removeTicket(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet<Ticket<?>> ticketSet = this.func_229848_e_(chunkPosIn);
        boolean removed = false;
        if (ticketSet.remove(ticketIn)) {
            removed = true;
        }
        if (ticketSet.isEmpty()) {
            this.field_219377_e.remove(chunkPosIn);
        }
        this.field_219378_f.func_215491_b(chunkPosIn, TicketManagerMixin.func_229844_a_(ticketSet), false);
        return removed;
    }

    @Override
    public boolean bridge$removeTicket(long chunkPos, Ticket<?> ticket) {
        return this.removeTicket(chunkPos, ticket);
    }

    private boolean func_219347_a(long chunkPosIn, Ticket<?> ticketIn) {
        return this.addTicket(chunkPosIn, ticketIn);
    }

    private boolean addTicket(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet<Ticket<?>> ticketSet = this.func_229848_e_(chunkPosIn);
        int level = TicketManagerMixin.func_229844_a_(ticketSet);
        Ticket ticket = (Ticket)ticketSet.func_226175_a_(ticketIn);
        ticket.func_229861_a_(this.field_219389_q);
        if (ticketIn.func_219477_b() < level) {
            this.field_219378_f.func_215491_b(chunkPosIn, ticketIn.func_219477_b(), true);
        }
        return ticketIn == ticket;
    }

    @Override
    public boolean bridge$addTicket(long chunkPos, Ticket<?> ticket) {
        return this.addTicket(chunkPos, ticket);
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket target = new Ticket(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.field_219377_e.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            SortedArraySet tickets = (SortedArraySet)entry.getValue();
            if (!tickets.remove((Object)target)) continue;
            this.field_219378_f.func_215491_b(entry.getLongKey(), TicketManagerMixin.func_229844_a_(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public <T> void bridge$removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }
}

