/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.world.storage.SaveHandlerBridge;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveHandler;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SaveHandler.class})
public class SaveHandlerMixin
implements SaveHandlerBridge {
    @Shadow(aliases={"field_215773_b"}, remap=false)
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private File field_215775_d;
    @Shadow
    @Final
    private File field_215774_c;
    private final Int2ObjectMap<UUID> uuidMap = new Int2ObjectOpenHashMap();

    @Inject(method={"readPlayerData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;contains(Ljava/lang/String;I)Z")})
    public void arclight$lastSeenTime(PlayerEntity player, CallbackInfoReturnable<CompoundNBT> cir) {
        if (player instanceof ServerPlayerEntity) {
            CraftPlayer craftPlayer = ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity();
            long modified = new File(this.field_215775_d, player.func_110124_au().toString() + ".dat").lastModified();
            if (modified < craftPlayer.getFirstPlayed()) {
                craftPlayer.setFirstPlayed(modified);
            }
        }
    }

    public String[] getSeenPlayers() {
        String[] arr = this.field_215775_d.list();
        if (arr == null) {
            arr = new String[]{};
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].endsWith(".dat")) continue;
            arr[i] = arr[i].substring(0, arr[i].length() - 4);
        }
        return arr;
    }

    public UUID getUUID() {
        return this.getUUID(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getUUID(ServerWorld world) {
        int dimId = world == null ? 0 : world.field_73011_w.func_186058_p().func_186068_a();
        UUID uuid = (UUID)this.uuidMap.get(dimId);
        if (uuid != null) {
            return uuid;
        }
        File folder = world == null ? this.field_215774_c : world.field_73011_w.func_186058_p().func_212679_a(this.field_215774_c);
        File file1 = new File(folder, "uid.dat");
        if (file1.exists()) {
            try (DataInputStream dis = new DataInputStream(new FileInputStream(file1));){
                uuid = new UUID(dis.readLong(), dis.readLong());
                this.uuidMap.put(dimId, (Object)uuid);
                UUID throwable3 = uuid;
                return throwable3;
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to read " + file1 + ", generating new random UUID", (Throwable)ex);
            }
        }
        uuid = UUID.randomUUID();
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file1));){
            dos.writeLong(uuid.getMostSignificantBits());
            dos.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to write " + file1, (Throwable)ex);
        }
        this.uuidMap.put(dimId, (Object)uuid);
        return uuid;
    }

    public File getPlayerDir() {
        return this.field_215775_d;
    }

    public CompoundNBT getPlayerData(String uuid) {
        try {
            File file1 = new File(this.field_215775_d, uuid + ".dat");
            if (file1.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load player data for " + uuid);
        }
        return null;
    }

    @Override
    public String[] bridge$getSeenPlayers() {
        return this.getSeenPlayers();
    }

    @Override
    public UUID bridge$getUUID(ServerWorld world) {
        return this.getUUID(world);
    }

    @Override
    public File bridge$getPlayerDir() {
        return this.getPlayerDir();
    }

    @Override
    public CompoundNBT bridge$getPlayerData(String uuid) {
        return this.getPlayerData(uuid);
    }
}

