/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import io.izzel.arclight.common.bridge.world.storage.WorldInfoBridge;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldInfo.class})
public abstract class WorldInfoMixin
implements WorldInfoBridge {
    @Shadow
    private boolean field_76104_m;
    @Shadow
    private boolean field_76102_o;
    public World world;

    @Shadow
    public abstract String func_76065_j();

    @Shadow
    public abstract boolean func_176123_z();

    @Inject(method={"updateTagCompound"}, at={@At(value="RETURN")})
    private void arclight$writeArclight(CompoundNBT nbt, CompoundNBT playerNbt, CallbackInfo ci) {
        nbt.func_74778_a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
    }

    @Inject(method={"setThundering"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$thunder(boolean thunderingIn, CallbackInfo ci) {
        if (this.field_76102_o == thunderingIn) {
            ci.cancel();
            return;
        }
        org.bukkit.World world = Bukkit.getWorld(this.func_76065_j());
        if (world != null) {
            ThunderChangeEvent event = new ThunderChangeEvent(world, thunderingIn);
            Bukkit.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setRaining"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$raining(boolean isRaining, CallbackInfo ci) {
        if (this.field_76104_m == isRaining) {
            ci.cancel();
            return;
        }
        org.bukkit.World world = Bukkit.getWorld(this.func_76065_j());
        if (world != null) {
            WeatherChangeEvent event = new WeatherChangeEvent(world, isRaining);
            Bukkit.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setDifficulty"}, at={@At(value="RETURN")})
    private void arclight$sendDiffChange(Difficulty newDifficulty, CallbackInfo ci) {
        SServerDifficultyPacket packet = new SServerDifficultyPacket(newDifficulty, this.func_176123_z());
        for (PlayerEntity player : this.world.func_217369_A()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    @Override
    public void bridge$setWorld(World world) {
        this.world = world;
    }

    @Override
    public World bridge$getWorld() {
        return this.world;
    }
}

