/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ArclightMixinPlugin
implements IMixinConfigPlugin {
    private final Map<String, Map.Entry<List<FieldNode>, List<MethodNode>>> accessTransformer = ImmutableMap.builder().put("net.minecraft.server.MinecraftServer", Maps.immutableEntry(ImmutableList.of(new FieldNode(9, "currentTick", "I", null, null)), ImmutableList.of(new MethodNode(9, "getServer", "()Lnet/minecraft/server/MinecraftServer;", null, null)))).put("net.minecraft.world.server.TicketType", Maps.immutableEntry(ImmutableList.of(new FieldNode(25, "PLUGIN", "Lnet/minecraft/world/server/TicketType;", null, null), new FieldNode(25, "PLUGIN_TICKET", "Lnet/minecraft/world/server/TicketType;", null, null)), ImmutableList.of())).put("net.minecraft.world.storage.loot.LootParameters", Maps.immutableEntry(ImmutableList.of(new FieldNode(25, "LOOTING_MOD", "Lnet/minecraft/world/storage/loot/LootParameter;", null, null)), ImmutableList.of())).put("net.minecraft.item.BlockItem", Maps.immutableEntry(ImmutableList.of(), ImmutableList.of(new MethodNode(9, "getBlockState", "(Lnet/minecraft/block/BlockState;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/block/BlockState;", null, null)))).put("net.minecraft.inventory.container.WorkbenchContainer", Maps.immutableEntry(ImmutableList.of(), ImmutableList.of(new MethodNode(9, "a", "(ILnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/inventory/CraftingInventory;Lnet/minecraft/inventory/CraftResultInventory;Lnet/minecraft/inventory/container/Container;)V", null, null)))).put("net.minecraft.entity.item.HangingEntity", Maps.immutableEntry(ImmutableList.of(), ImmutableList.of(new MethodNode(9, "calculateBoundingBox", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;II)Lnet/minecraft/util/math/AxisAlignedBB;", null, null)))).put("net.minecraft.entity.item.ItemFrameEntity", Maps.immutableEntry(ImmutableList.of(), ImmutableList.of(new MethodNode(9, "calculateBoundingBox", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;II)Lnet/minecraft/util/math/AxisAlignedBB;", null, null)))).put("net.minecraft.tileentity.SkullTileEntity", Maps.immutableEntry(ImmutableList.of(new FieldNode(9, "executor", "Ljava/util/concurrent/ExecutorService;", null, null), new FieldNode(9, "skinCache", "Lcom/google/common/cache/LoadingCache;", null, null)), ImmutableList.of(new MethodNode(9, "b", "(Lcom/mojang/authlib/GameProfile;Lcom/google/common/base/Predicate;Z)Ljava/util/concurrent/Future;", null, null)))).build();
    private final Set<String> modifyConstructor = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("net.minecraft.world.World")).add("net.minecraft.world.server.ServerWorld")).add("net.minecraft.world.ServerMultiWorld")).add("net.minecraft.inventory.Inventory")).add("net.minecraft.block.ComposterBlock")).add("net.minecraft.block.ComposterBlock$EmptyInventory")).add("net.minecraft.util.FoodStats")).add("net.minecraft.inventory.CraftingInventory")).add("net.minecraft.inventory.EnderChestInventory")).add("net.minecraft.world.server.TicketManager")).add("net.minecraft.item.MerchantOffer")).add("net.minecraft.inventory.container.LecternContainer")).add("net.minecraft.world.TrackedEntity")).add("net.minecraft.util.math.shapes.IndirectMerger")).add("net.minecraft.network.play.client.CCloseWindowPacket")).add("net.minecraft.world.dimension.DimensionType")).build();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Map.Entry<List<FieldNode>, List<MethodNode>> entry = this.accessTransformer.get(targetClassName);
        if (entry != null) {
            Iterator fields = entry.getKey();
            for (Object fieldNode : targetClass.fields) {
                this.tryTransform((List<FieldNode>)((Object)fields), (FieldNode)fieldNode);
            }
            List<MethodNode> methods = entry.getValue();
            for (MethodNode methodNode : targetClass.methods) {
                this.tryTransform(methods, methodNode);
            }
        }
        this.modifyConstructor(targetClassName, targetClass);
        if (targetClassName.equals("net.minecraft.entity.projectile.LlamaSpitEntity")) {
            for (FieldNode node : targetClass.fields) {
                if (!node.name.equals("field_190539_a")) continue;
                node.desc = "Lnet/minecraft/entity/LivingEntity;";
            }
            for (FieldNode node : targetClass.methods) {
                ListIterator iterator = node.instructions.iterator();
                while (iterator.hasNext()) {
                    AbstractInsnNode next;
                    FieldInsnNode fieldInsnNode;
                    AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                    if (!(insnNode instanceof FieldInsnNode) || (fieldInsnNode = (FieldInsnNode)insnNode).getOpcode() != 180 && fieldInsnNode.getOpcode() != 181 || !fieldInsnNode.name.equals("field_190539_a")) continue;
                    fieldInsnNode.desc = "Lnet/minecraft/entity/LivingEntity;";
                    if (!iterator.hasNext() || (next = (AbstractInsnNode)iterator.next()).getOpcode() != 182 || !((MethodInsnNode)next).name.equals("func_110124_au") || !((MethodInsnNode)next).desc.equals("()Ljava/util/UUID;")) continue;
                    ((MethodInsnNode)next).owner = "net/minecraft/entity/LivingEntity";
                }
            }
            FieldNode node = new FieldNode(1, "field_190539_a", "Lnet/minecraft/entity/passive/horse/LlamaEntity;", null, null);
            targetClass.fields.add(node);
        }
    }

    private void modifyConstructor(String targetClassName, ClassNode classNode) {
        if (this.modifyConstructor.contains(targetClassName)) {
            HashSet<String> presentCtor = new HashSet<String>();
            HashSet<String> overrideCtor = new HashSet<String>();
            for (MethodNode method : classNode.methods) {
                if (method.name.equals("<init>")) {
                    presentCtor.add(method.desc);
                }
                if (!method.name.equals("arclight$constructor$override")) continue;
                overrideCtor.add(method.desc);
            }
            ListIterator iterator = classNode.methods.listIterator();
            while (iterator.hasNext()) {
                MethodNode methodNode = (MethodNode)iterator.next();
                if (methodNode.name.equals("arclight$constructor")) {
                    String desc = methodNode.desc;
                    if (presentCtor.contains(desc)) {
                        iterator.remove();
                    } else {
                        methodNode.name = "<init>";
                        presentCtor.add(methodNode.desc);
                        this.remapCtor(classNode, methodNode);
                    }
                }
                if (methodNode.name.equals("arclight$constructor$super")) {
                    iterator.remove();
                }
                if (methodNode.name.equals("<init>") && overrideCtor.contains(methodNode.desc)) {
                    iterator.remove();
                    continue;
                }
                if (!methodNode.name.equals("arclight$constructor$override")) continue;
                methodNode.name = "<init>";
                this.remapCtor(classNode, methodNode);
            }
        }
    }

    private void remapCtor(ClassNode classNode, MethodNode methodNode) {
        boolean initialized = false;
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (methodInsnNode.name.equals("arclight$constructor")) {
                if (initialized) {
                    throw new ClassFormatError("Duplicate constructor call");
                }
                methodInsnNode.setOpcode(183);
                methodInsnNode.name = "<init>";
                initialized = true;
            }
            if (!methodInsnNode.name.equals("arclight$constructor$super")) continue;
            if (initialized) {
                throw new ClassFormatError("Duplicate constructor call");
            }
            methodInsnNode.setOpcode(183);
            methodInsnNode.owner = classNode.superName;
            methodInsnNode.name = "<init>";
            initialized = true;
        }
        if (!initialized) {
            if (classNode.superName.equals("java/lang/Object")) {
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
                methodNode.instructions.insert(insnList);
            } else {
                throw new ClassFormatError("No super constructor call present.");
            }
        }
    }

    private void tryTransform(List<FieldNode> fields, FieldNode fieldNode) {
        for (FieldNode field : fields) {
            if (!Objects.equals(fieldNode.name, field.name) || !Objects.equals(fieldNode.desc, field.desc)) continue;
            fieldNode.access = field.access;
        }
    }

    private void tryTransform(List<MethodNode> methods, MethodNode methodNode) {
        for (MethodNode method : methods) {
            if (!Objects.equals(methodNode.name, method.name) || !Objects.equals(methodNode.desc, method.desc)) continue;
            methodNode.access = method.access;
        }
    }
}

