/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.bridge.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.tools.product.Product;
import io.izzel.tools.product.Product2;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public class ArclightContainer {
    private static final long HANDLERS_OFFSET;
    private static final long COMPOSE_OFFSET;

    private static IInventory getActualInventoryForSlot(Slot slot) {
        if (slot instanceof SlotItemHandler) {
            return ArclightContainer.getInventoryFromWrapper(((SlotItemHandler)slot).getItemHandler());
        }
        return slot.field_75224_c;
    }

    private static IInventory getInventoryFromWrapper(IItemHandler handler) {
        if (handler instanceof CombinedInvWrapper) {
            IItemHandlerModifiable[] handlers = (IItemHandlerModifiable[])Unsafe.getObject(handler, HANDLERS_OFFSET);
            IInventory last = null;
            for (IItemHandlerModifiable modifiable : handlers) {
                IInventory inventory = ArclightContainer.getInventoryFromWrapper((IItemHandler)modifiable);
                if (inventory instanceof PlayerInventory) {
                    return inventory;
                }
                last = inventory;
            }
            return last;
        }
        if (handler instanceof InvWrapper) {
            return ((InvWrapper)handler).getInv();
        }
        if (handler instanceof RangedWrapper) {
            return ArclightContainer.getInventoryFromWrapper((IItemHandler)Unsafe.getObject(handler, COMPOSE_OFFSET));
        }
        return null;
    }

    public static InventoryView createInvView(Container container) {
        Product2<PlayerEntity, Integer> containerInfo = ArclightContainer.getContainerInfo(container);
        CraftInventory viewing = new CraftInventory(new ContainerInvWrapper(container, (Integer)containerInfo._2, (PlayerEntity)containerInfo._1));
        return new CraftInventoryView(((PlayerEntityBridge)containerInfo._1).bridge$getBukkitEntity(), viewing, container);
    }

    public static void updateView(Container container, InventoryView inventoryView) {
        IInventory inventory;
        Inventory topInventory = inventoryView.getTopInventory();
        if (topInventory instanceof CraftInventory && (inventory = ((CraftInventory)topInventory).getInventory()) instanceof ContainerInvWrapper) {
            Product2<PlayerEntity, Integer> containerInfo = ArclightContainer.getContainerInfo(container);
            ((ContainerInvWrapper)inventory).setOwner(((PlayerEntityBridge)containerInfo._1).bridge$getBukkitEntity());
            ((ContainerInvWrapper)inventory).setSize((Integer)containerInfo._2);
        }
    }

    private static Product2<PlayerEntity, Integer> getContainerInfo(Container container) {
        PlayerEntity candidate = ArclightCaptures.getContainerOwner();
        int bottomBegin = -1;
        int bottomEnd = -1;
        ListIterator iterator = container.field_75151_b.listIterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            IInventory inventory = ArclightContainer.getActualInventoryForSlot(slot);
            if (inventory instanceof PlayerInventory) {
                if (candidate != null && ((PlayerInventory)inventory).field_70458_d != candidate) {
                    ArclightMod.LOGGER.warn("Multiple player found in {}/{}, previous {}, new {}", (Object)container, container.getClass(), (Object)candidate, (Object)((PlayerInventory)inventory).field_70458_d);
                }
                candidate = ((PlayerInventory)inventory).field_70458_d;
                if (bottomBegin != -1 && bottomBegin >= bottomEnd) continue;
                bottomBegin = iterator.previousIndex();
                continue;
            }
            if (bottomEnd >= bottomBegin) continue;
            bottomEnd = iterator.previousIndex();
        }
        if (candidate == null) {
            throw new RuntimeException("candidate cannot be null, " + container + "/" + container.getClass());
        }
        if (bottomBegin < bottomEnd || bottomBegin == -1) {
            bottomBegin = container.field_75151_b.size();
        }
        return Product.of(candidate, bottomBegin);
    }

    static {
        try {
            Unsafe.ensureClassInitialized(CombinedInvWrapper.class);
            Field itemHandler = CombinedInvWrapper.class.getDeclaredField("itemHandler");
            HANDLERS_OFFSET = Unsafe.objectFieldOffset(itemHandler);
            Unsafe.ensureClassInitialized(RangedWrapper.class);
            Field compose = RangedWrapper.class.getDeclaredField("compose");
            COMPOSE_OFFSET = Unsafe.objectFieldOffset(compose);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ContainerInvWrapper
    implements IInventory,
    IInventoryBridge {
        private final Container container;
        private int size;
        private InventoryHolder owner;
        private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();

        public ContainerInvWrapper(Container container, int size, PlayerEntity owner) {
            this.container = container;
            this.size = size;
            this.owner = ((PlayerEntityBridge)owner).bridge$getBukkitEntity();
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int func_70302_i_() {
            return this.size;
        }

        public boolean func_191420_l() {
            for (Slot slot : this.container.field_75151_b) {
                if (slot.func_75211_c().func_190926_b()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack func_70301_a(int index) {
            if (index >= this.size) {
                return ItemStack.field_190927_a;
            }
            return this.container.func_75139_a(index).func_75211_c();
        }

        @NotNull
        public ItemStack func_70298_a(int index, int count) {
            if (index >= this.size) {
                return ItemStack.field_190927_a;
            }
            return this.container.func_75139_a(index).func_75209_a(count);
        }

        @NotNull
        public ItemStack func_70304_b(int index) {
            if (index >= this.size) {
                return ItemStack.field_190927_a;
            }
            return this.container.func_75139_a(index).func_75209_a(Integer.MAX_VALUE);
        }

        public void func_70299_a(int index, @NotNull ItemStack stack) {
            if (index >= this.size) {
                return;
            }
            this.container.func_75141_a(index, stack);
        }

        public int func_70297_j_() {
            if (this.size <= 0) {
                return 0;
            }
            return this.container.func_75139_a(0).func_75219_a();
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(@NotNull PlayerEntity player) {
            return this.container.func_75145_c(player);
        }

        public void func_174888_l() {
            for (Slot slot : this.container.field_75151_b) {
                slot.func_75209_a(Integer.MAX_VALUE);
            }
        }

        @Override
        public List<ItemStack> getContents() {
            this.container.func_75142_b();
            return this.container.field_75153_a.subList(0, this.size);
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        @Override
        public InventoryHolder getOwner() {
            return this.owner;
        }

        @Override
        public void setOwner(InventoryHolder owner) {
            this.owner = owner;
        }

        @Override
        public void setMaxStackSize(int size) {
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public IRecipe<?> getCurrentRecipe() {
            return null;
        }

        @Override
        public void setCurrentRecipe(IRecipe<?> recipe) {
        }
    }
}

