/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forgeinstaller;

import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.forgeinstaller.Util;
import io.izzel.arclight.i18n.LocalizedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;

public class FileDownloader
implements Supplier<Path> {
    private final String url;
    private final String target;
    private final String hash;

    public FileDownloader(String url, String target, String hash) {
        this.url = url;
        this.target = target;
        this.hash = hash;
    }

    @Override
    public Path get() {
        try {
            Path path = new File(this.target).toPath();
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                Files.delete(path);
            }
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    throw LocalizedException.checked("downloader.dir", this.target);
                }
                if (Util.hash(path).equals(this.hash)) {
                    return path;
                }
                Files.delete(path);
            }
            if (!Files.exists(path, new LinkOption[0]) && path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            URL url = new URL(this.url);
            try (InputStream stream = this.redirect(url);){
                Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (SocketTimeoutException e) {
                throw LocalizedException.checked("downloader.timeout", e, url);
            }
            if (Files.exists(path, new LinkOption[0])) {
                String hash = Util.hash(path);
                if (hash.equals(this.hash)) {
                    return path;
                }
                Files.delete(path);
                throw LocalizedException.checked("downloader.hash-not-match", this.hash, hash, url);
            }
            throw LocalizedException.checked("downloader.not-found", url);
        }
        catch (AccessDeniedException e) {
            throw LocalizedException.unchecked("downloader.access-denied", e.getFile(), e);
        }
        catch (Exception e) {
            Unsafe.throwException(e);
            return null;
        }
    }

    private InputStream redirect(URL url) throws IOException {
        return this.redirect(url, new HashSet<String>());
    }

    private InputStream redirect(URL url, Set<String> history) throws IOException {
        if (history.contains(url.toString())) {
            StringJoiner joiner = new StringJoiner("\n        ");
            joiner.add("");
            history.forEach(joiner::add);
            throw LocalizedException.unchecked("downloader.redirect-error", joiner.toString());
        }
        history.add(url.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setReadTimeout(15000);
        connection.setConnectTimeout(15000);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return connection.getInputStream();
        }
        if (responseCode == 301 || responseCode == 302) {
            String location = URLDecoder.decode(connection.getHeaderField("Location"), "UTF-8");
            return this.redirect(new URL(url, location));
        }
        if (responseCode == 404 || responseCode == 403) {
            throw LocalizedException.unchecked("downloader.not-found", url);
        }
        throw LocalizedException.unchecked("downloader.http-error", responseCode, url);
    }
}

