/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.projectiles.ProjectileSource;

public class CraftFishHook
extends AbstractProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, FishingBobberEntity entity) {
        super(server, (Entity)entity);
    }

    @Override
    public ProjectileSource getShooter() {
        if (this.getHandle().field_146042_b != null) {
            return this.getHandle().field_146042_b.getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof CraftHumanEntity) {
            this.getHandle().field_146042_b = (PlayerEntity)((CraftHumanEntity)shooter).entity;
        }
    }

    public FishingBobberEntity getHandle() {
        return (FishingBobberEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    @Override
    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    @Override
    public double getBiteChance() {
        FishingBobberEntity hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.field_70170_p.func_175727_C(new BlockPos(MathHelper.func_76128_c((double)hook.func_226277_ct_()), MathHelper.func_76128_c((double)hook.func_226278_cu_()) + 1, MathHelper.func_76128_c((double)hook.func_226281_cx_())))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    @Override
    public void setBiteChance(double chance) {
        Validate.isTrue((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (String)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }
}

