/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, FoxEntity entity) {
        super(server, (AnimalEntity)entity);
    }

    public FoxEntity getHandle() {
        return (FoxEntity)super.getHandle();
    }

    @Override
    public EntityType getType() {
        return EntityType.FOX;
    }

    @Override
    public String toString() {
        return "CraftFox";
    }

    @Override
    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().func_213471_dV().ordinal()];
    }

    @Override
    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument(type != null, "type");
        this.getHandle().func_213474_a(FoxEntity.Type.values()[type.ordinal()]);
    }

    @Override
    public boolean isCrouching() {
        return this.getHandle().func_213453_ef();
    }

    @Override
    public void setCrouching(boolean crouching) {
        this.getHandle().func_213451_t(crouching);
    }

    @Override
    public boolean isSitting() {
        return this.getHandle().func_213455_dW();
    }

    @Override
    public void setSitting(boolean sitting) {
        this.getHandle().func_213466_r(sitting);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.getHandle().func_213485_x(sleeping);
    }

    @Override
    public AnimalTamer getFirstTrustedPlayer() {
        UUID uuid = ((Optional)this.getHandle().func_184212_Q().func_187225_a(FoxEntity.field_213509_bB)).orElse(null);
        if (uuid == null) {
            return null;
        }
        OfflinePlayer player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    @Override
    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null && ((Optional)this.getHandle().func_184212_Q().func_187225_a(FoxEntity.field_213510_bD)).isPresent()) {
            throw new IllegalStateException("Must remove second trusted player first");
        }
        this.getHandle().func_184212_Q().func_187227_b(FoxEntity.field_213509_bB, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    @Override
    public AnimalTamer getSecondTrustedPlayer() {
        UUID uuid = ((Optional)this.getHandle().func_184212_Q().func_187225_a(FoxEntity.field_213510_bD)).orElse(null);
        if (uuid == null) {
            return null;
        }
        OfflinePlayer player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    @Override
    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null && !((Optional)this.getHandle().func_184212_Q().func_187225_a(FoxEntity.field_213509_bB)).isPresent()) {
            throw new IllegalStateException("Must add first trusted player first");
        }
        this.getHandle().func_184212_Q().func_187227_b(FoxEntity.field_213510_bD, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }
}

