/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_15_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, net.minecraft.entity.LivingEntity entity) {
        super(server, (net.minecraft.entity.Entity)entity);
        if (entity instanceof MobEntity || entity instanceof ArmorStandEntity) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    @Override
    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().func_110143_aJ()), this.getMaxHealth());
    }

    @Override
    public void setHealth(double health) {
        if ((health = (double)((float)health)) < 0.0 || health > this.getMaxHealth()) {
            throw new IllegalArgumentException("Health must be between 0 and " + this.getMaxHealth() + "(" + health + ")");
        }
        this.getHandle().func_70606_j((float)health);
        if (health == 0.0) {
            this.getHandle().func_70645_a(DamageSource.field_76377_j);
        }
    }

    @Override
    public double getAbsorptionAmount() {
        return this.getHandle().func_110139_bj();
    }

    @Override
    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument(amount >= 0.0 && Double.isFinite(amount), "amount < 0 or non-finite");
        this.getHandle().func_110149_m((float)amount);
    }

    @Override
    public double getMaxHealth() {
        return this.getHandle().func_110138_aP();
    }

    @Override
    public void setMaxHealth(double amount) {
        Validate.isTrue((amount > 0.0 ? 1 : 0) != 0, (String)"Max health must be greater than 0");
        this.getHandle().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    @Override
    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111123_a().func_111110_b());
    }

    @Override
    public double getEyeHeight() {
        return this.getHandle().func_70047_e();
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        if (transparent == null) {
            transparent = Sets.newHashSet(Material.AIR, Material.CAVE_AIR, Material.VOID_AIR);
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator(this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (!transparent.contains(material = block.getType())) break;
        }
        return blocks;
    }

    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    @Override
    public int getRemainingAir() {
        return this.getHandle().func_70086_ai();
    }

    @Override
    public void setRemainingAir(int ticks) {
        this.getHandle().func_70050_g(ticks);
    }

    @Override
    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    @Override
    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    @Override
    public void damage(double amount) {
        this.damage(amount, null);
    }

    @Override
    public void damage(double amount, Entity source) {
        DamageSource reason = DamageSource.field_76377_j;
        if (source instanceof HumanEntity) {
            reason = DamageSource.func_76365_a((PlayerEntity)((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = DamageSource.func_76358_a((net.minecraft.entity.LivingEntity)((CraftLivingEntity)source).getHandle());
        }
        this.entity.func_70097_a(reason, (float)amount);
    }

    @Override
    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    @Override
    public int getMaximumNoDamageTicks() {
        return this.getHandle().field_70771_an;
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().field_70771_an = ticks;
    }

    @Override
    public double getLastDamage() {
        return this.getHandle().field_110153_bc;
    }

    @Override
    public void setLastDamage(double damage) {
        this.getHandle().field_110153_bc = (float)damage;
    }

    @Override
    public int getNoDamageTicks() {
        return this.getHandle().field_70172_ad;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        this.getHandle().field_70172_ad = ticks;
    }

    public net.minecraft.entity.LivingEntity getHandle() {
        return (net.minecraft.entity.LivingEntity)this.entity;
    }

    public void setHandle(net.minecraft.entity.LivingEntity entity) {
        super.setHandle((net.minecraft.entity.Entity)entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + '}';
    }

    @Override
    public Player getKiller() {
        return this.getHandle().field_70717_bb == null ? null : (Player)((Object)this.getHandle().field_70717_bb.getBukkitEntity());
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        this.getHandle().addEffect(new EffectInstance(Effect.func_188412_a((int)effect.getType().getId()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    @Override
    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().func_70644_a(Effect.func_188412_a((int)type.getId()));
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type) {
        EffectInstance handle = this.getHandle().func_70660_b(Effect.func_188412_a((int)type.getId()));
        return handle == null ? null : new PotionEffect(PotionEffectType.getById(Effect.func_188409_a((Effect)handle.func_188419_a())), handle.func_76459_b(), handle.func_76458_c(), handle.func_82720_e(), handle.func_188418_e());
    }

    @Override
    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(Effect.func_188412_a((int)type.getId()), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    @Override
    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (EffectInstance handle : this.getHandle().field_70713_bf.values()) {
            effects.add(new PotionEffect(PotionEffectType.getById(Effect.func_188409_a((Effect)handle.func_188419_a())), handle.func_76459_b(), handle.func_76458_c(), handle.func_82720_e(), handle.func_188418_e()));
        }
        return effects;
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        ServerWorld world = ((CraftWorld)this.getWorld()).getHandle();
        Object launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new SnowballEntity((World)world, this.getHandle());
            ((ThrowableEntity)launch).func_184538_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EggEntity((World)world, this.getHandle());
            ((ThrowableEntity)launch).func_184538_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EnderPearlEntity((World)world, this.getHandle());
            ((ThrowableEntity)launch).func_184538_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new ArrowEntity((World)world, this.getHandle());
                ((ArrowEntity)launch).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new SpectralArrowEntity((World)world, this.getHandle()) : (Trident.class.isAssignableFrom(projectile) ? new TridentEntity((World)world, this.getHandle(), new net.minecraft.item.ItemStack((IItemProvider)Items.field_203184_eO)) : new ArrowEntity((World)world, this.getHandle()));
            }
            ((AbstractArrowEntity)launch).func_184547_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new PotionEntity((World)world, this.getHandle());
                ((PotionEntity)launch).func_184541_a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new PotionEntity((World)world, this.getHandle());
                ((PotionEntity)launch).func_184541_a(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
            ((ThrowableEntity)launch).func_184538_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new ExperienceBottleEntity((World)world, this.getHandle());
            ((ThrowableEntity)launch).func_184538_a((net.minecraft.entity.Entity)this.getHandle(), this.getHandle().field_70125_A, this.getHandle().field_70177_z, -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof PlayerEntity) {
            launch = new FishingBobberEntity((PlayerEntity)this.getHandle(), (World)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new SmallFireballEntity((World)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new WitherSkullEntity((World)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (DragonFireball.class.isAssignableFrom(projectile) ? new DragonFireballEntity((World)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new FireballEntity((World)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ())));
            ((DamagingProjectileEntity)launch).projectileSource = this;
            launch.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityType.field_200770_J.func_200721_a((World)world);
            ((LlamaSpitEntity)launch).field_190539_a = this.getHandle();
            ((LlamaSpitEntity)launch).func_70186_c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new ShulkerBulletEntity((World)world, this.getHandle(), null, null);
            launch.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.func_217376_c((net.minecraft.entity.Entity)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }

    @Override
    public org.bukkit.entity.EntityType getType() {
        return org.bukkit.entity.EntityType.UNKNOWN;
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        return this.getHandle().func_70685_l(((CraftEntity)other).getHandle());
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof MobEntity && !((MobEntity)this.getHandle()).field_82179_bU;
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof MobEntity) {
            ((MobEntity)this.getHandle()).field_82179_bU = !remove;
        }
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        this.getHandle().canPickUpLoot = pickup;
    }

    @Override
    public boolean getCanPickupItems() {
        return this.getHandle().canPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    @Override
    public boolean isLeashed() {
        if (!(this.getHandle() instanceof MobEntity)) {
            return false;
        }
        return ((MobEntity)this.getHandle()).func_110166_bE() != null;
    }

    @Override
    public Entity getLeashHolder() throws IllegalStateException {
        if (!this.isLeashed()) {
            throw new IllegalStateException("Entity not leashed");
        }
        return ((MobEntity)this.getHandle()).func_110166_bE().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((MobEntity)this.getHandle()).func_110160_i(true, false);
        return true;
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle() instanceof WitherEntity || !(this.getHandle() instanceof MobEntity)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((MobEntity)this.getHandle()).func_110162_b(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public boolean isGliding() {
        return this.getHandle().func_70083_f(7);
    }

    @Override
    public void setGliding(boolean gliding) {
        this.getHandle().func_70052_a(7, gliding);
    }

    @Override
    public boolean isSwimming() {
        return this.getHandle().func_203007_ba();
    }

    @Override
    public void setSwimming(boolean swimming) {
        this.getHandle().func_204711_a(swimming);
    }

    @Override
    public boolean isRiptiding() {
        return this.getHandle().func_204805_cN();
    }

    @Override
    public boolean isSleeping() {
        return this.getHandle().func_70608_bn();
    }

    @Override
    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    @Override
    public void setAI(boolean ai) {
        if (this.getHandle() instanceof MobEntity) {
            ((MobEntity)this.getHandle()).func_94061_f(!ai);
        }
    }

    @Override
    public boolean hasAI() {
        return this.getHandle() instanceof MobEntity ? !((MobEntity)this.getHandle()).func_175446_cd() : false;
    }

    @Override
    public void attack(Entity target) {
        Preconditions.checkArgument(target != null, "target == null");
        this.getHandle().func_70652_k(((CraftEntity)target).getHandle());
    }

    @Override
    public void swingMainHand() {
        this.getHandle().func_226292_a_(Hand.MAIN_HAND, true);
    }

    @Override
    public void swingOffHand() {
        this.getHandle().func_226292_a_(Hand.OFF_HAND, true);
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    @Override
    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    @Override
    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().func_213375_cj().func_218207_c(CraftMemoryKey.fromMemoryKey(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    @Override
    public <T> void setMemory(MemoryKey<T> memoryKey, T t) {
        this.getHandle().func_213375_cj().func_218205_a(CraftMemoryKey.fromMemoryKey(memoryKey), CraftMemoryMapper.toNms(t));
    }
}

