/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PandaEntity;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, PandaEntity entity) {
        super(server, (AnimalEntity)entity);
    }

    public PandaEntity getHandle() {
        return (PandaEntity)super.getHandle();
    }

    @Override
    public EntityType getType() {
        return EntityType.PANDA;
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    @Override
    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().func_213549_ef());
    }

    @Override
    public void setMainGene(Panda.Gene gene) {
        this.getHandle().func_213589_a(CraftPanda.toNms(gene));
    }

    @Override
    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().func_213536_eg());
    }

    @Override
    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().func_213541_b(CraftPanda.toNms(gene));
    }

    public static Panda.Gene fromNms(PandaEntity.Type gene) {
        Preconditions.checkArgument(gene != null, "Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static PandaEntity.Type toNms(Panda.Gene gene) {
        Preconditions.checkArgument(gene != null, "Gene may not be null");
        return PandaEntity.Type.values()[gene.ordinal()];
    }
}

