/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.SStopSoundPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhitelistEntry;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapDecoration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_15_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_15_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_15_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftSound;
import org.bukkit.craftbukkit.v1_15_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_15_R1.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_15_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_15_R1.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_15_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> hiddenPlayers = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private ITextComponent playerListHeader;
    private ITextComponent playerListFooter;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().field_71135_a.field_147371_a.getRawAddress();
        }

        @Override
        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.isCollidable();
        }

        @Override
        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.setCollidable(collides);
        }

        @Override
        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().func_184103_al().func_72368_a(CraftPlayer.this.getHandle(), DimensionType.field_223227_a_, false);
            }
        }

        @Override
        public Set<Player> getHiddenPlayers() {
            HashSet<Player> ret = new HashSet<Player>();
            for (UUID u : CraftPlayer.this.hiddenPlayers.keySet()) {
                ret.add(CraftPlayer.this.getServer().getPlayer(u));
            }
            return Collections.unmodifiableSet(ret);
        }

        @Override
        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().field_71135_a == null) {
                return;
            }
            SChatPacket packet = new SChatPacket(null, ChatType.SYSTEM);
            packet.components = components;
            CraftPlayer.this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().field_71135_a == null) {
                return;
            }
            SChatPacket packet = new SChatPacket(null, ChatType.func_192582_a((byte)((byte)position.ordinal())));
            if (position == ChatMessageType.ACTION_BAR) {
                components = new BaseComponent[]{new TextComponent(BaseComponent.toLegacyText(components))};
            }
            packet.components = components;
            CraftPlayer.this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
        }
    };

    public CraftPlayer(CraftServer server, ServerPlayerEntity entity) {
        super(server, (PlayerEntity)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().func_146103_bH();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().func_152596_g(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().func_152605_a(this.getProfile());
        } else {
            this.server.getHandle().func_152610_b(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().field_71135_a == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().field_71135_a.field_147371_a.func_74430_c();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    @Override
    public void sendRawMessage(String message) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        ITextComponent[] iTextComponentArray = CraftChatMessage.fromString(message);
        int n = iTextComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITextComponent component = iTextComponentArray[n2];
            this.getHandle().field_71135_a.func_147359_a((IPacket)new SChatPacket(component));
            ++n2;
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            this.sendMessage(message);
            ++n2;
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    @Override
    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (ServerPlayerEntity player : this.server.getHandle().field_72404_b) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.field_71135_a.func_147359_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_DISPLAY_NAME, new ServerPlayerEntity[]{this.getHandle()}));
        }
    }

    @Override
    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : CraftChatMessage.fromComponent(this.playerListHeader);
    }

    @Override
    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : CraftChatMessage.fromComponent(this.playerListFooter);
    }

    @Override
    public void setPlayerListHeader(String header) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListFooter(String footer) {
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        SPlayerListHeaderFooterPacket packet = new SPlayerListHeaderFooterPacket();
        packet.field_179703_a = this.playerListHeader == null ? new StringTextComponent("") : this.playerListHeader;
        packet.field_179702_b = this.playerListFooter == null ? new StringTextComponent("") : this.playerListFooter;
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            boolean bl = idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        this.getHandle().field_71135_a.disconnect(message == null ? "" : message);
    }

    @Override
    public void setCompassTarget(Location loc) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SSpawnPositionPacket(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())));
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void chat(String msg) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        this.getHandle().field_71135_a.chat(msg, false);
    }

    @Override
    public boolean performCommand(String command) {
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(CraftSound.getSoundEffect("block.note_block." + instrumentName), net.minecraft.util.SoundCategory.RECORDS, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, f));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
                break;
            }
            case 10: {
                instrumentName = "iron_xylophone";
                break;
            }
            case 11: {
                instrumentName = "cow_bell";
                break;
            }
            case 12: {
                instrumentName = "didgeridoo";
                break;
            }
            case 13: {
                instrumentName = "bit";
                break;
            }
            case 14: {
                instrumentName = "banjo";
                break;
            }
            case 15: {
                instrumentName = "pling";
                break;
            }
            case 16: {
                instrumentName = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0);
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(CraftSound.getSoundEffect("block.note_block." + instrumentName), net.minecraft.util.SoundCategory.RECORDS, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, f));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().field_71135_a == null) {
            return;
        }
        SPlaySoundEffectPacket packet = new SPlaySoundEffectPacket(CraftSound.getSoundEffect(CraftSound.getSound(sound)), net.minecraft.util.SoundCategory.valueOf((String)category.name()), loc.getX(), loc.getY(), loc.getZ(), volume, pitch);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().field_71135_a == null) {
            return;
        }
        SPlaySoundPacket packet = new SPlaySoundPacket(new ResourceLocation(sound), net.minecraft.util.SoundCategory.valueOf((String)category.name()), new Vec3d(loc.getX(), loc.getY(), loc.getZ()), volume, pitch);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(CraftSound.getSound(sound), category);
    }

    @Override
    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SStopSoundPacket(new ResourceLocation(sound), category == null ? net.minecraft.util.SoundCategory.MASTER : net.minecraft.util.SoundCategory.valueOf((String)category.name())));
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        int packetData = effect.getId();
        SPlaySoundEventPacket packet = new SPlaySoundEventPacket(packetData, new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), data, false);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)((CraftWorld)loc.getWorld()).getHandle(), new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        packet.field_197686_b = CraftMagicNumbers.getBlock(material, data);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)((CraftWorld)loc.getWorld()).getHandle(), new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        packet.field_197686_b = ((CraftBlockData)block).getState();
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        Validate.notNull((Object)loc, (String)"Location can not be null");
        Validate.notNull((Object)((Object)dyeColor), (String)"DyeColor can not be null");
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        ITextComponent[] components = CraftSign.sanitizeLines(lines);
        SignTileEntity sign = new SignTileEntity();
        sign.func_174878_a(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        sign.func_214068_a(net.minecraft.item.DyeColor.func_196056_a((int)dyeColor.getWoolData()));
        System.arraycopy(components, 0, sign.field_145915_a, 0, sign.field_145915_a.length);
        this.getHandle().field_71135_a.func_147359_a((IPacket)sign.func_189518_D_());
    }

    @Override
    public boolean sendChunkChange(Location loc, int sx, int sy, int sz, byte[] data) {
        if (this.getHandle().field_71135_a == null) {
            return false;
        }
        throw new NotImplementedException("Chunk changes do not yet work");
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapDecoration(MapDecoration.Type.func_191159_a((byte)cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull(cursor.getCaption())));
        }
        SMapDataPacket packet = new SMapDataPacket(map.getId(), map.getScale().getValue(), true, map.isLocked(), icons, data.buffer, 0, 0, 128, 128);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument(location != null, "location");
        Preconditions.checkArgument(location.getWorld() != null, "location.world");
        location.checkFinite();
        ServerPlayerEntity entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.field_70128_L) {
            return false;
        }
        if (entity.field_71135_a == null) {
            return false;
        }
        if (entity.func_184207_aI()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        entity.func_184210_p();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        ServerWorld fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        ServerWorld toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().field_71070_bA != this.getHandle().field_71069_bz) {
            this.getHandle().func_71053_j();
        }
        if (fromWorld == toWorld) {
            entity.field_71135_a.teleport(to);
        } else {
            this.server.getHandle().moveToWorld(entity, toWorld.func_201675_m().func_186058_p(), true, to, true);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().func_226284_e_(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().func_225608_bj_();
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().func_70051_ag();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().func_70031_b(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().field_72412_k.func_75752_b((PlayerEntity)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().field_72412_k.func_75753_a((PlayerEntity)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().func_71120_a(this.getHandle().field_71070_bA);
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().func_72854_c();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic);
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic);
    }

    @Override
    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().func_147099_x(), statistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().func_147099_x(), statistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic, material);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic, material);
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().func_147099_x(), statistic, material);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic, material, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic, material, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().func_147099_x(), statistic, material, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic, entityType);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic, entityType);
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().func_147099_x(), statistic, entityType);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().func_147099_x(), statistic, entityType, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().func_147099_x(), statistic, entityType, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().func_147099_x(), statistic, entityType, newValue);
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().func_152599_k().func_152705_a(this.getProfile());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().func_152599_k().func_152687_a((UserListEntry)new WhitelistEntry(this.getProfile()));
        } else {
            this.server.getHandle().func_152599_k().func_152684_c((Object)this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.getHandle().func_71033_a(GameType.func_77146_a((int)mode.getValue()));
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().field_71134_c.func_73081_b().func_77148_a());
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().func_195068_e(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().func_82242_a(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().field_71106_cc;
    }

    @Override
    public void setExp(float exp) {
        Preconditions.checkArgument((double)exp >= 0.0 && (double)exp <= 1.0, "Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().field_71106_cc = exp;
        this.getHandle().field_71144_ck = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().field_71068_ca;
    }

    @Override
    public void setLevel(int level) {
        Preconditions.checkArgument(level >= 0, "Experience level must not be negative (%s)", level);
        this.getHandle().field_71068_ca = level;
        this.getHandle().field_71144_ck = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().field_71067_cb;
    }

    @Override
    public void setTotalExperience(int exp) {
        Preconditions.checkArgument(exp >= 0, "Total experience points must not be negative (%s)", exp);
        this.getHandle().field_71067_cb = exp;
    }

    @Override
    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    @Override
    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument((double)progress >= 0.0 && (double)progress <= 1.0, "Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument(level >= 0, "Experience level must not be negative (%s)", level);
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        SSetExperiencePacket packet = new SSetExperiencePacket(progress, this.getTotalExperience(), level);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().func_71024_bL().field_75126_c;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().func_71024_bL().field_75126_c = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().func_71024_bL().field_75125_b;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().func_71024_bL().field_75125_b = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().func_71024_bL().field_75127_a;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().func_71024_bL().field_75127_a = value;
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Override
    @Deprecated
    public void hidePlayer(Player player) {
        this.hidePlayer0(null, player);
    }

    @Override
    public void hidePlayer(Plugin plugin, Player player) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.isTrue((boolean)plugin.isEnabled(), (String)"Plugin attempted to hide player while disabled");
        this.hidePlayer0(plugin, player);
    }

    private void hidePlayer0(@Nullable Plugin plugin, Player player) {
        Validate.notNull((Object)player, (String)"hidden player cannot be null");
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenPlayers.get(player.getUniqueId());
        if (hidingPlugins != null) {
            hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return;
        }
        hidingPlugins = new HashSet<WeakReference<Plugin>>();
        hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.hiddenPlayers.put(player.getUniqueId(), hidingPlugins);
        ChunkManager tracker = ((ServerWorld)this.entity.field_70170_p).func_72863_F().field_217237_a;
        ServerPlayerEntity other = ((CraftPlayer)player).getHandle();
        ChunkManager.EntityTracker entry = (ChunkManager.EntityTracker)tracker.field_219272_z.get(other.func_145782_y());
        if (entry != null) {
            entry.func_219399_a(this.getHandle());
        }
        if (other.sentListPacket) {
            this.getHandle().field_71135_a.func_147359_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER, new ServerPlayerEntity[]{other}));
        }
    }

    @Override
    @Deprecated
    public void showPlayer(Player player) {
        this.showPlayer0(null, player);
    }

    @Override
    public void showPlayer(Plugin plugin, Player player) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        this.showPlayer0(plugin, player);
    }

    private void showPlayer0(@Nullable Plugin plugin, Player player) {
        Validate.notNull((Object)player, (String)"shown player cannot be null");
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenPlayers.get(player.getUniqueId());
        if (hidingPlugins == null) {
            return;
        }
        hidingPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!hidingPlugins.isEmpty()) {
            return;
        }
        this.hiddenPlayers.remove(player.getUniqueId());
        ChunkManager tracker = ((ServerWorld)this.entity.field_70170_p).func_72863_F().field_217237_a;
        ServerPlayerEntity other = ((CraftPlayer)player).getHandle();
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{other}));
        ChunkManager.EntityTracker entry = (ChunkManager.EntityTracker)tracker.field_219272_z.get(other.func_145782_y());
        if (entry != null && !entry.field_219406_f.contains(this.getHandle())) {
            entry.func_219400_b(this.getHandle());
        }
    }

    public void removeDisconnectingPlayer(Player player) {
        this.hiddenPlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getUniqueId());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    public ServerPlayerEntity getHandle() {
        return (ServerPlayerEntity)this.entity;
    }

    public void setHandle(ServerPlayerEntity entity) {
        super.setHandle((PlayerEntity)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + '}';
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(CompoundNBT nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.func_74764_b("bukkit")) {
            CompoundNBT data = nbttagcompound.func_74775_l("bukkit");
            if (data.func_74764_b("firstPlayed")) {
                this.firstPlayed = data.func_74763_f("firstPlayed");
                this.lastPlayed = data.func_74763_f("lastPlayed");
            }
            if (data.func_74764_b("newExp")) {
                ServerPlayerEntity handle = this.getHandle();
                handle.newExp = data.func_74762_e("newExp");
                handle.newTotalExp = data.func_74762_e("newTotalExp");
                handle.newLevel = data.func_74762_e("newLevel");
                handle.expToDrop = data.func_74762_e("expToDrop");
                handle.keepLevel = data.func_74767_n("keepLevel");
            }
        }
    }

    public void setExtraData(CompoundNBT nbttagcompound) {
        if (!nbttagcompound.func_74764_b("bukkit")) {
            nbttagcompound.func_218657_a("bukkit", (INBT)new CompoundNBT());
        }
        CompoundNBT data = nbttagcompound.func_74775_l("bukkit");
        ServerPlayerEntity handle = this.getHandle();
        data.func_74768_a("newExp", handle.newExp);
        data.func_74768_a("newTotalExp", handle.newTotalExp);
        data.func_74768_a("newLevel", handle.newLevel);
        data.func_74768_a("expToDrop", handle.expToDrop);
        data.func_74757_a("keepLevel", handle.keepLevel);
        data.func_74772_a("firstPlayed", this.getFirstPlayed());
        data.func_74772_a("lastPlayed", System.currentTimeMillis());
        data.func_74778_a("lastKnownName", handle.func_195047_I_());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            channel = StandardMessenger.validateAndCorrectChannel(channel);
            SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(new ResourceLocation(channel), new PacketBuffer(Unpooled.wrappedBuffer((byte[])message)));
            this.getHandle().field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    @Override
    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        this.getHandle().func_175397_a(url, "null");
    }

    @Override
    public void setResourcePack(String url, byte[] hash) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        Validate.notNull((Object)hash, (String)"Resource pack hash cannot be null");
        Validate.isTrue((hash.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hash.length));
        this.getHandle().func_175397_a(url, BaseEncoding.base16().lowerCase().encode(hash));
    }

    public void addChannel(String channel) {
        Preconditions.checkState(this.channels.size() < 128, "Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel(channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel(channel))) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(new ResourceLocation("register"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])stream.toByteArray()))));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        Container container = this.getHandle().field_71070_bA;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        this.getHandle().func_71112_a(container, prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().field_71075_bZ.field_75100_b;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().field_71075_bZ.field_75100_b = value;
        this.getHandle().func_71016_p();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().field_71075_bZ.field_75101_c;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().field_71075_bZ.field_75100_b = false;
        }
        this.getHandle().field_71075_bZ.field_75101_c = value;
        this.getHandle().func_71016_p();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().field_147101_bU > 0) {
            return Math.max(this.getHandle().field_147101_bU, this.getHandle().field_70172_ad);
        }
        return this.getHandle().field_70172_ad;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        ServerPlayerEntity player = this.getHandle();
        player.field_71075_bZ.field_75096_f = value / 2.0f;
        player.func_71016_p();
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        ServerPlayerEntity player = this.getHandle();
        player.field_71075_bZ.field_75097_g = value / 2.0f;
        player.func_71016_p();
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().field_71075_bZ.field_75096_f * 2.0f;
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().field_71075_bZ.field_75097_g * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(String.valueOf(value) + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(String.valueOf(value) + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().func_71118_n();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().func_71118_n();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        ServerPlayNetHandler playerConnection = this.getHandle().field_71135_a;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        playerConnection.isDisconnected();
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMap attributemapserver = (AttributeMap)this.getHandle().func_110140_aT();
        Collection set = attributemapserver.func_111160_c();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().field_71135_a != null) {
            this.getHandle().field_71135_a.func_147359_a((IPacket)new SEntityPropertiesPacket(this.getHandle().func_145782_y(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().func_184212_Q().func_187227_b(LivingEntity.field_184632_c, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate() {
        this.getHandle().field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(this.getScaledHealth(), this.getHandle().func_71024_bL().func_75116_a(), this.getHandle().func_71024_bL().func_75115_e()));
    }

    public void injectScaledMaxHealth(Collection<IAttributeInstance> collection, boolean force) {
        double healthMod;
        if (!this.scaledHealth && !force) {
            return;
        }
        for (IAttributeInstance genericInstance : collection) {
            if (!genericInstance.func_111123_a().func_111108_a().equals("generic.maxHealth")) continue;
            collection.remove(genericInstance);
            break;
        }
        double d = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(String.valueOf(this.getName()) + " tried to crash the server with a large health attribute");
        }
        collection.add((IAttributeInstance)new ModifiableAttributeInstance(this.getHandle().func_110140_aT(), (IAttribute)new RangedAttribute(null, "generic.maxHealth", healthMod, 0.0, 3.4028234663852886E38).func_111117_a("Max Health").func_111112_a(true)));
    }

    @Override
    public Entity getSpectatorTarget() {
        net.minecraft.entity.Entity followed = this.getHandle().func_175398_C();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    @Override
    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument(this.getGameMode() == GameMode.SPECTATOR, "Player must be in spectator mode");
        this.getHandle().func_175399_e(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    @Override
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        STitlePacket times = new STitlePacket(fadeIn, stay, fadeOut);
        this.getHandle().field_71135_a.func_147359_a((IPacket)times);
        if (title != null) {
            STitlePacket packetTitle = new STitlePacket(STitlePacket.Type.TITLE, CraftChatMessage.fromStringOrNull(title));
            this.getHandle().field_71135_a.func_147359_a((IPacket)packetTitle);
        }
        if (subtitle != null) {
            STitlePacket packetSubtitle = new STitlePacket(STitlePacket.Type.SUBTITLE, CraftChatMessage.fromStringOrNull(subtitle));
            this.getHandle().field_71135_a.func_147359_a((IPacket)packetSubtitle);
        }
    }

    @Override
    public void resetTitle() {
        STitlePacket packetReset = new STitlePacket(STitlePacket.Type.RESET, null);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packetReset);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        SSpawnParticlePacket packetplayoutworldparticles = new SSpawnParticlePacket(CraftParticle.toNMS(particle, data), true, (double)((float)x), (double)((float)y), (double)((float)z), (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().field_71135_a.func_147359_a((IPacket)packetplayoutworldparticles);
    }

    @Override
    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument(advancement != null, "advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        PlayerAdvancements data = this.getHandle().func_192039_O();
        AdvancementProgress progress = data.func_192747_a(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    @Override
    public int getClientViewDistance() {
        return this.getHandle().clientViewDistance == null ? Bukkit.getViewDistance() : this.getHandle().clientViewDistance;
    }

    @Override
    public String getLocale() {
        return this.getHandle().field_71148_cg;
    }

    @Override
    public void updateCommands() {
        if (this.getHandle().field_71135_a == null) {
            return;
        }
        this.getHandle().field_71133_b.func_195571_aL().func_197051_a(this.getHandle());
    }

    @Override
    public void openBook(ItemStack book) {
        Validate.isTrue((book != null ? 1 : 0) != 0, (String)"book == null");
        Validate.isTrue((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"Book must be Material.WRITTEN_BOOK");
        ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().func_184814_a(CraftItemStack.asNMSCopy(book), Hand.MAIN_HAND);
        this.getInventory().setItemInMainHand(hand);
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }
}

