/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, VillagerEntity entity) {
        super(server, (AbstractVillagerEntity)entity);
    }

    public VillagerEntity getHandle() {
        return (VillagerEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public Villager.Profession getProfession() {
        return CraftVillager.nmsToBukkitProfession(this.getHandle().func_213700_eh().func_221130_b());
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221126_a(CraftVillager.bukkitToNmsProfession(profession)));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(Registry.field_218369_K.func_177774_c((Object)this.getHandle().func_213700_eh().func_221129_a()).func_110623_a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221134_a((IVillagerType)Registry.field_218369_K.func_82594_a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public int getVillagerLevel() {
        return this.getHandle().func_213700_eh().func_221132_c();
    }

    @Override
    public void setVillagerLevel(int level) {
        Preconditions.checkArgument(1 <= level && level <= 5, "level must be between [1, 5]");
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221135_a(level));
    }

    @Override
    public int getVillagerExperience() {
        return this.getHandle().func_213708_dV();
    }

    @Override
    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument(experience >= 0, "Experience must be positive");
        this.getHandle().func_213761_t(experience);
    }

    @Override
    public boolean sleep(Location location) {
        Preconditions.checkArgument(location != null, "Location cannot be null");
        Preconditions.checkArgument(location.getWorld() != null, "Location needs to be in a world");
        Preconditions.checkArgument(location.getWorld().equals(this.getWorld()), "Cannot sleep across worlds");
        BlockPos position = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockState iblockdata = this.getHandle().field_70170_p.func_180495_p(position);
        if (!(iblockdata.func_177230_c() instanceof BedBlock)) {
            return false;
        }
        this.getHandle().func_213342_e(position);
        return true;
    }

    @Override
    public void wakeup() {
        Preconditions.checkState(this.isSleeping(), "Cannot wakeup if not sleeping");
        this.getHandle().func_213366_dy();
    }

    public static Villager.Profession nmsToBukkitProfession(VillagerProfession nms) {
        return Villager.Profession.valueOf(Registry.field_218370_L.func_177774_c((Object)nms).func_110623_a().toUpperCase(Locale.ROOT));
    }

    public static VillagerProfession bukkitToNmsProfession(Villager.Profession bukkit) {
        return (VillagerProfession)Registry.field_218370_L.func_82594_a(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
    }
}

