/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, ZombieVillagerEntity entity) {
        super(server, (ZombieEntity)entity);
    }

    public ZombieVillagerEntity getHandle() {
        return (ZombieVillagerEntity)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public EntityType getType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return Villager.Profession.valueOf(Registry.field_218370_L.func_177774_c((Object)this.getHandle().func_213700_eh().func_221130_b()).func_110623_a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().func_213792_a(this.getHandle().func_213700_eh().func_221126_a((VillagerProfession)Registry.field_218370_L.func_82594_a(new ResourceLocation(profession.name().toLowerCase(Locale.ROOT)))));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(Registry.field_218369_K.func_177774_c((Object)this.getHandle().func_213700_eh().func_221129_a()).func_110623_a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().func_213792_a(this.getHandle().func_213700_eh().func_221134_a((IVillagerType)Registry.field_218369_K.func_82594_a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().func_82230_o();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState(this.isConverting(), "Entity not converting");
        return this.getHandle().field_82234_d;
    }

    @Override
    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().field_82234_d = -1;
            this.getHandle().func_184212_Q().func_187227_b(ZombieVillagerEntity.field_184739_bx, (Object)false);
            this.getHandle().field_82179_bU = false;
            this.getHandle().field_191992_by = null;
            this.getHandle().removeEffect(Effects.field_76420_g, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().func_191991_a(null, time);
        }
    }

    @Override
    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().field_191992_by == null ? null : Bukkit.getOfflinePlayer(this.getHandle().field_191992_by);
    }

    @Override
    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().field_191992_by = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

