/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.generator;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkSection;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_15_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public final class CraftChunkData
implements ChunkGenerator.ChunkData {
    private final int maxHeight;
    private final ChunkSection[] sections;
    private Set<BlockPos> tiles;

    public CraftChunkData(World world) {
        this(world.getMaxHeight());
    }

    CraftChunkData(int maxHeight) {
        if (maxHeight > 256) {
            throw new IllegalArgumentException("World height exceeded max chunk height");
        }
        this.maxHeight = maxHeight;
        this.sections = new ChunkSection[maxHeight >> 4];
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void setBlock(int x, int y, int z, Material material) {
        this.setBlock(x, y, z, material.createBlockData());
    }

    @Override
    public void setBlock(int x, int y, int z, MaterialData material) {
        this.setBlock(x, y, z, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setBlock(int x, int y, int z, BlockData blockData) {
        this.setBlock(x, y, z, ((CraftBlockData)blockData).getState());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    @Override
    public Material getType(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z).func_177230_c());
    }

    @Override
    public MaterialData getTypeAndData(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z));
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getTypeId(x, y, z));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < 0) {
            yMin = 0;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        int y = yMin;
        while (y < yMax) {
            ChunkSection section = this.getChunkSection(y, true);
            int offsetBase = y & 0xF;
            int x = xMin;
            while (x < xMax) {
                int z = zMin;
                while (z < zMax) {
                    section.func_222629_a(x, offsetBase, z, type);
                    ++z;
                }
                ++x;
            }
            ++y;
        }
    }

    public BlockState getTypeId(int x, int y, int z) {
        if (x != (x & 0xF) || y < 0 || y >= this.maxHeight || z != (z & 0xF)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ChunkSection section = this.getChunkSection(y, false);
        if (section == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return section.func_177485_a(x, y & 0xF, z);
    }

    @Override
    public byte getData(int x, int y, int z) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x, y, z));
    }

    private void setBlock(int x, int y, int z, BlockState type) {
        if (x != (x & 0xF) || y < 0 || y >= this.maxHeight || z != (z & 0xF)) {
            return;
        }
        ChunkSection section = this.getChunkSection(y, true);
        section.func_222629_a(x, y & 0xF, z, type);
        if (type.func_177230_c().func_149716_u()) {
            if (this.tiles == null) {
                this.tiles = new HashSet<BlockPos>();
            }
            this.tiles.add(new BlockPos(x, y, z));
        }
    }

    private ChunkSection getChunkSection(int y, boolean create) {
        ChunkSection section = this.sections[y >> 4];
        if (create && section == null) {
            this.sections[y >> 4] = section = new ChunkSection(y >> 4 << 4);
        }
        return section;
    }

    ChunkSection[] getRawChunkData() {
        return this.sections;
    }

    Set<BlockPos> getTiles() {
        return this.tiles;
    }
}

