/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.generator;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.EndChunkGenerator;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NetherChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_15_R1.generator.InternalChunkGenerator;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator<GenerationSettings> {
    private final ChunkGenerator delegate;
    private final org.bukkit.generator.ChunkGenerator generator;
    private final ServerWorld world;
    private final Random random = new Random();

    public CustomChunkGenerator(World world, org.bukkit.generator.ChunkGenerator generator) {
        super((IWorld)world, world.field_73011_w.func_186060_c().func_202090_b(), new GenerationSettings());
        switch (world.getWorld().getEnvironment()) {
            case NORMAL: {
                this.delegate = new OverworldChunkGenerator((IWorld)world, world.field_73011_w.func_186060_c().func_202090_b(), new OverworldGenSettings());
                break;
            }
            case NETHER: {
                this.delegate = new NetherChunkGenerator(world, world.field_73011_w.func_186060_c().func_202090_b(), new NetherGenSettings());
                break;
            }
            case THE_END: {
                this.delegate = new EndChunkGenerator((IWorld)world, world.field_73011_w.func_186060_c().func_202090_b(), new EndGenerationSettings());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown delegate for environment " + (Object)((Object)world.getWorld().getEnvironment())));
            }
        }
        this.world = (ServerWorld)world;
        this.generator = generator;
    }

    public void func_222539_a(IChunk ichunkaccess) {
    }

    public <C extends IFeatureConfig> C func_202087_b(Biome biomebase, Structure<C> structuregenerator) {
        return (C)this.delegate.func_202087_b(biomebase, structuregenerator);
    }

    public BiomeProvider func_202090_b() {
        return this.delegate.func_202090_b();
    }

    public void func_222528_a(IWorld generatoraccess, IChunk ichunkaccess) {
        this.delegate.func_222528_a(generatoraccess, ichunkaccess);
    }

    public int func_222530_f() {
        return this.delegate.func_222530_f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_225551_a_(WorldGenRegion regionlimitedworldaccess, IChunk ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int x = ichunkaccess.func_76632_l().field_77276_a;
        int z = ichunkaccess.func_76632_l().field_77275_b;
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        CustomBiomeGrid biomegrid = new CustomBiomeGrid(new BiomeContainer(ichunkaccess.func_76632_l(), this.func_202090_b()));
        if (this.generator.isParallelCapable()) {
            data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
        } else {
            CustomChunkGenerator customChunkGenerator = this;
            synchronized (customChunkGenerator) {
                data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
            }
        }
        Preconditions.checkArgument(data instanceof CraftChunkData, "Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        CraftChunkData craftData = (CraftChunkData)data;
        ChunkSection[] sections = craftData.getRawChunkData();
        ChunkSection[] csect = ichunkaccess.func_76587_i();
        int scnt = Math.min(csect.length, sections.length);
        int sec = 0;
        while (sec < scnt) {
            if (sections[sec] != null) {
                ChunkSection section;
                csect[sec] = section = sections[sec];
            }
            ++sec;
        }
        ((ChunkPrimer)ichunkaccess).func_225548_a_(biomegrid.biome);
        if (craftData.getTiles() != null) {
            for (BlockPos pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.func_177958_n();
                Block block = craftData.getTypeId(tx, ty = pos.func_177956_o(), tz = pos.func_177952_p()).func_177230_c();
                if (!block.func_149716_u()) continue;
                TileEntity tile = ((ITileEntityProvider)block).func_196283_a_((IBlockReader)this.world);
                ichunkaccess.func_177426_a(new BlockPos((x << 4) + tx, ty, (z << 4) + tz), tile);
            }
        }
    }

    public void func_227058_a_(BiomeManager biomemanager, IChunk ichunkaccess, ChunkGenerator<?> chunkgenerator, TemplateManager definedstructuremanager) {
        if (this.generator.shouldGenerateStructures()) {
            this.delegate.func_227058_a_(biomemanager, ichunkaccess, chunkgenerator, definedstructuremanager);
        }
    }

    public void func_225550_a_(BiomeManager biomemanager, IChunk ichunkaccess, GenerationStage.Carving worldgenstage_features) {
        if (this.generator.shouldGenerateCaves()) {
            this.delegate.func_225550_a_(biomemanager, ichunkaccess, worldgenstage_features);
        }
    }

    public void func_222537_b(IWorld generatoraccess, IChunk ichunkaccess) {
    }

    public int func_222529_a(int i, int j, Heightmap.Type heightmap_type) {
        return this.delegate.func_222529_a(i, j, heightmap_type);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification enumcreaturetype, BlockPos blockposition) {
        return this.delegate.func_177458_a(enumcreaturetype, blockposition);
    }

    public void func_202092_b(WorldGenRegion regionlimitedworldaccess) {
        if (this.generator.shouldGenerateDecorations()) {
            this.delegate.func_202092_b(regionlimitedworldaccess);
        }
    }

    public void func_202093_c(WorldGenRegion regionlimitedworldaccess) {
        if (this.generator.shouldGenerateMobs()) {
            this.delegate.func_202093_c(regionlimitedworldaccess);
        }
    }

    public BlockPos func_211403_a(World world, String s2, BlockPos blockposition, int i, boolean flag) {
        return this.delegate.func_211403_a(world, s2, blockposition, i, flag);
    }

    public GenerationSettings func_201496_a_() {
        return this.delegate.func_201496_a_();
    }

    public void func_203222_a(ServerWorld worldserver, boolean flag, boolean flag1) {
        this.delegate.func_203222_a(worldserver, flag, flag1);
    }

    public boolean func_202094_a(Biome biomebase, Structure<? extends IFeatureConfig> structuregenerator) {
        return this.delegate.func_202094_a(biomebase, structuregenerator);
    }

    public long func_202089_c() {
        return this.delegate.func_202089_c();
    }

    public int func_205470_d() {
        return this.delegate.func_205470_d();
    }

    public int func_207511_e() {
        return this.delegate.func_207511_e();
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final BiomeContainer biome;

        public CustomBiomeGrid(BiomeContainer biome) {
            this.biome = biome;
        }

        @Override
        public org.bukkit.block.Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        @Override
        public void setBiome(int x, int z, org.bukkit.block.Biome bio) {
            int y = 0;
            while (y < CustomChunkGenerator.this.world.getWorld().getMaxHeight()) {
                this.setBiome(x, y, z, bio);
                y += 4;
            }
        }

        @Override
        public org.bukkit.block.Biome getBiome(int x, int y, int z) {
            return CraftBlock.biomeBaseToBiome(this.biome.func_225526_b_(x >> 2, y >> 2, z >> 2));
        }

        @Override
        public void setBiome(int x, int y, int z, org.bukkit.block.Biome bio) {
            this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBlock.biomeToBiomeBase(bio));
        }
    }
}

