/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.BeaconContainer;
import net.minecraft.inventory.container.BlastFurnaceContainer;
import net.minecraft.inventory.container.BrewingStandContainer;
import net.minecraft.inventory.container.CartographyContainer;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.DispenserContainer;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.FurnaceContainer;
import net.minecraft.inventory.container.GrindstoneContainer;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.inventory.container.LecternContainer;
import net.minecraft.inventory.container.LoomContainer;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.inventory.container.SmokerContainer;
import net.minecraft.inventory.container.StonecutterContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryCustom;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends Container {
    private final InventoryView view;
    private InventoryType cachedType;
    private String cachedTitle;
    private Container delegate;
    private final int cachedSize;

    public CraftContainer(InventoryView view, PlayerEntity player, int id) {
        super(CraftContainer.getNotchInventoryType(view.getTopInventory()), id);
        this.view = view;
        IInventory top = ((CraftInventory)view.getTopInventory()).getInventory();
        PlayerInventory bottom = (PlayerInventory)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.cachedTitle = view.getTitle();
        this.cachedSize = this.getSize();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final PlayerEntity player, int id) {
        this(new InventoryView(){

            @Override
            public Inventory getTopInventory() {
                return inventory;
            }

            @Override
            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            @Override
            public HumanEntity getPlayer() {
                return player.getBukkitEntity();
            }

            @Override
            public InventoryType getType() {
                return inventory.getType();
            }

            @Override
            public String getTitle() {
                return inventory instanceof CraftInventoryCustom ? ((CraftInventoryCustom.MinecraftInventory)((CraftInventory)inventory).getInventory()).getTitle() : inventory.getType().getDefaultTitle();
            }
        }, player, id);
    }

    public InventoryView getBukkitView() {
        return this.view;
    }

    private int getSize() {
        return this.view.getTopInventory().getSize();
    }

    public boolean func_75129_b(PlayerEntity entityhuman) {
        if (this.cachedType == this.view.getType() && this.cachedSize == this.getSize() && this.cachedTitle.equals(this.view.getTitle())) {
            return true;
        }
        boolean typeChanged = this.cachedType != this.view.getType();
        this.cachedType = this.view.getType();
        this.cachedTitle = this.view.getTitle();
        if (this.view.getPlayer() instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)this.view.getPlayer();
            ContainerType type = CraftContainer.getNotchInventoryType(this.view.getTopInventory());
            IInventory top = ((CraftInventory)this.view.getTopInventory()).getInventory();
            PlayerInventory bottom = (PlayerInventory)((CraftInventory)this.view.getBottomInventory()).getInventory();
            this.field_75153_a.clear();
            this.field_75151_b.clear();
            if (typeChanged) {
                this.setupSlots(top, bottom, (PlayerEntity)player.getHandle());
            }
            int size = this.getSize();
            player.getHandle().field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(this.field_75152_c, type, (ITextComponent)new StringTextComponent(this.cachedTitle)));
            player.updateInventory();
        }
        return true;
    }

    public static ContainerType getNotchInventoryType(Inventory inventory) {
        switch (inventory.getType()) {
            case CHEST: 
            case PLAYER: 
            case ENDER_CHEST: 
            case BARREL: {
                switch (inventory.getSize()) {
                    case 9: {
                        return ContainerType.field_221507_a;
                    }
                    case 18: {
                        return ContainerType.field_221508_b;
                    }
                    case 27: {
                        return ContainerType.field_221509_c;
                    }
                    case 36: 
                    case 41: {
                        return ContainerType.field_221510_d;
                    }
                    case 45: {
                        return ContainerType.field_221511_e;
                    }
                    case 54: {
                        return ContainerType.field_221512_f;
                    }
                }
                throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
            }
            case WORKBENCH: {
                return ContainerType.field_221518_l;
            }
            case FURNACE: {
                return ContainerType.field_221520_n;
            }
            case DISPENSER: {
                return ContainerType.field_221513_g;
            }
            case ENCHANTING: {
                return ContainerType.field_221519_m;
            }
            case BREWING: {
                return ContainerType.field_221517_k;
            }
            case BEACON: {
                return ContainerType.field_221515_i;
            }
            case ANVIL: {
                return ContainerType.field_221514_h;
            }
            case HOPPER: {
                return ContainerType.field_221522_p;
            }
            case DROPPER: {
                return ContainerType.field_221513_g;
            }
            case SHULKER_BOX: {
                return ContainerType.field_221526_t;
            }
            case BLAST_FURNACE: {
                return ContainerType.field_221516_j;
            }
            case LECTERN: {
                return ContainerType.field_221523_q;
            }
            case SMOKER: {
                return ContainerType.field_221527_u;
            }
            case LOOM: {
                return ContainerType.field_221524_r;
            }
            case CARTOGRAPHY: {
                return ContainerType.field_226625_v_;
            }
            case GRINDSTONE: {
                return ContainerType.field_221521_o;
            }
            case STONECUTTER: {
                return ContainerType.field_221529_w;
            }
            case CRAFTING: 
            case CREATIVE: 
            case MERCHANT: {
                throw new IllegalArgumentException("Can't open a " + (Object)((Object)inventory.getType()) + " inventory!");
            }
        }
        return ContainerType.field_221509_c;
    }

    private void setupSlots(IInventory top, PlayerInventory bottom, PlayerEntity entityhuman) {
        int windowId = -1;
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case CHEST: 
            case PLAYER: 
            case ENDER_CHEST: 
            case BARREL: {
                this.delegate = new ChestContainer(ContainerType.field_221509_c, windowId, bottom, top, top.func_70302_i_() / 9);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new DispenserContainer(windowId, bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new FurnaceContainer(windowId, bottom, top, (IIntArray)new IntArray(4));
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, (IInventory)bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new EnchantmentContainer(windowId, bottom);
                break;
            }
            case BREWING: {
                this.delegate = new BrewingStandContainer(windowId, bottom, top, (IIntArray)new IntArray(2));
                break;
            }
            case HOPPER: {
                this.delegate = new HopperContainer(windowId, bottom, top);
                break;
            }
            case ANVIL: {
                this.delegate = new RepairContainer(windowId, bottom);
                break;
            }
            case BEACON: {
                this.delegate = new BeaconContainer(windowId, (IInventory)bottom);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new ShulkerBoxContainer(windowId, bottom, top);
                break;
            }
            case BLAST_FURNACE: {
                this.delegate = new BlastFurnaceContainer(windowId, bottom, top, (IIntArray)new IntArray(4));
                break;
            }
            case LECTERN: {
                this.delegate = new LecternContainer(windowId, top, (IIntArray)new IntArray(1), bottom);
                break;
            }
            case SMOKER: {
                this.delegate = new SmokerContainer(windowId, bottom, top, (IIntArray)new IntArray(4));
                break;
            }
            case LOOM: {
                this.delegate = new LoomContainer(windowId, bottom);
                break;
            }
            case CARTOGRAPHY: {
                this.delegate = new CartographyContainer(windowId, bottom);
                break;
            }
            case GRINDSTONE: {
                this.delegate = new GrindstoneContainer(windowId, bottom);
                break;
            }
            case STONECUTTER: {
                this.delegate = new StonecutterContainer(windowId, bottom);
                break;
            }
            case MERCHANT: {
                this.delegate = new MerchantContainer(windowId, bottom);
            }
        }
        if (this.delegate != null) {
            this.field_75153_a = this.delegate.field_75153_a;
            this.field_75151_b = this.delegate.field_75151_b;
        }
        if (this.cachedType == InventoryType.WORKBENCH) {
            this.delegate = new WorkbenchContainer(windowId, bottom);
        }
    }

    private void setupWorkbench(IInventory top, IInventory bottom) {
        int col;
        this.func_75146_a(new Slot(top, 0, 124, 35));
        int row = 0;
        while (row < 3) {
            col = 0;
            while (col < 3) {
                this.func_75146_a(new Slot(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < 3) {
            col = 0;
            while (col < 9) {
                this.func_75146_a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
                ++col;
            }
            ++row;
        }
        col = 0;
        while (col < 9) {
            this.func_75146_a(new Slot(bottom, col, 8 + col * 18, 142));
            ++col;
        }
    }

    public ItemStack func_82846_b(PlayerEntity entityhuman, int i) {
        return this.delegate != null ? this.delegate.func_82846_b(entityhuman, i) : super.func_82846_b(entityhuman, i);
    }

    public boolean func_75145_c(PlayerEntity entity) {
        return true;
    }

    public ContainerType<?> func_216957_a() {
        return CraftContainer.getNotchInventoryType(this.view.getTopInventory());
    }
}

