/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_15_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftLegacy;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    net.minecraft.item.ItemStack handle;

    public static net.minecraft.item.ItemStack asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? net.minecraft.item.ItemStack.field_190927_a : stack.handle.func_77946_l();
        }
        if (original == null || original.getType() == Material.AIR) {
            return net.minecraft.item.ItemStack.field_190927_a;
        }
        Item item = CraftMagicNumbers.getItem(original.getType(), original.getDurability());
        if (item == null) {
            return net.minecraft.item.ItemStack.field_190927_a;
        }
        net.minecraft.item.ItemStack stack = new net.minecraft.item.ItemStack((IItemProvider)item, original.getAmount());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static net.minecraft.item.ItemStack copyNMSStack(net.minecraft.item.ItemStack original, int amount) {
        net.minecraft.item.ItemStack stack = original.func_77946_l();
        stack.func_190920_e(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.item.ItemStack original) {
        if (original.func_190926_b()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftMagicNumbers.getMaterial(original.func_77973_b()), original.func_190916_E());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(net.minecraft.item.ItemStack original) {
        return new CraftItemStack(original == null || original.func_190926_b() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.func_77946_l());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftMagicNumbers.getMaterial(item), amount, 0, null);
    }

    private CraftItemStack(net.minecraft.item.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @Override
    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.func_77973_b()) : super.getData();
    }

    @Override
    public Material getType() {
        return this.handle != null ? CraftMagicNumbers.getMaterial(this.handle.func_77973_b()) : Material.AIR;
    }

    @Override
    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftMagicNumbers.getItem(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.item.ItemStack((IItemProvider)CraftMagicNumbers.getItem(type), 1);
        } else {
            this.handle.setItem(CraftMagicNumbers.getItem(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.func_190916_E() : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.func_190920_e(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.func_196085_b((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.func_77952_i();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.func_77973_b().func_77639_j();
    }

    @Override
    public void addUnsafeEnchantment(org.bukkit.enchantments.Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        ListNBT list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new ListNBT();
            this.handle.func_77978_p().func_218657_a(CraftMetaItem.ENCHANTMENTS.NBT, (INBT)list);
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            CompoundNBT tag = (CompoundNBT)list.get(i);
            String id = tag.func_74779_i(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id.equals(ench.getKey().toString())) {
                tag.func_74777_a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
                return;
            }
            ++i;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(CraftMetaItem.ENCHANTMENTS_ID.NBT, ench.getKey().toString());
        tag.func_74777_a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.add((Object)tag);
    }

    static boolean makeTag(net.minecraft.item.ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77978_p() == null) {
            item.func_77982_d(new CompoundNBT());
        }
        return true;
    }

    @Override
    public boolean containsEnchantment(org.bukkit.enchantments.Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(org.bukkit.enchantments.Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment");
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentHelper.func_77506_a((Enchantment)CraftEnchantment.getRaw(ench), (net.minecraft.item.ItemStack)this.handle);
    }

    @Override
    public int removeEnchantment(org.bukkit.enchantments.Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment");
        ListNBT list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.size();
        int i = 0;
        while (i < size) {
            CompoundNBT enchantment = (CompoundNBT)list.get(i);
            String id = enchantment.func_74779_i(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id.equals(ench.getKey().toString())) {
                index = i;
                level = 0xFFFF & enchantment.func_74765_d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
                break;
            }
            ++i;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.func_77978_p().func_82580_o(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.func_77978_p().isEmpty()) {
                this.handle.func_77982_d(null);
            }
            return level;
        }
        ListNBT listCopy = new ListNBT();
        i = 0;
        while (i < size) {
            if (i != index) {
                listCopy.add((Object)list.get(i));
            }
            ++i;
        }
        this.handle.func_77978_p().func_218657_a(CraftMetaItem.ENCHANTMENTS.NBT, (INBT)listCopy);
        return level;
    }

    @Override
    public Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(net.minecraft.item.ItemStack item) {
        ListNBT list;
        ListNBT listNBT = list = item != null && item.func_77948_v() ? item.func_77986_q() : null;
        if (list == null || list.size() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<org.bukkit.enchantments.Enchantment, Integer> result = ImmutableMap.builder();
        int i = 0;
        while (i < list.size()) {
            String id = ((CompoundNBT)list.get(i)).func_74779_i(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((CompoundNBT)list.get(i)).func_74765_d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            org.bukkit.enchantments.Enchantment enchant = org.bukkit.enchantments.Enchantment.getByKey(CraftNamespacedKey.fromStringOrNull(id));
            if (enchant != null) {
                result.put(enchant, level);
            }
            ++i;
        }
        return result.build();
    }

    static ListNBT getEnchantmentList(net.minecraft.item.ItemStack item) {
        return item != null && item.func_77948_v() ? item.func_77986_q() : null;
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.func_77946_l();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(net.minecraft.item.ItemStack item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        switch (CraftItemStack.getType(item)) {
            case WRITTEN_BOOK: {
                return new CraftMetaBookSigned(item.func_77978_p());
            }
            case WRITABLE_BOOK: {
                return new CraftMetaBook(item.func_77978_p());
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: 
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return new CraftMetaSkull(item.func_77978_p());
            }
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_HELMET: 
            case LEATHER_HORSE_ARMOR: 
            case LEATHER_LEGGINGS: {
                return new CraftMetaLeatherArmor(item.func_77978_p());
            }
            case LINGERING_POTION: 
            case POTION: 
            case SPLASH_POTION: 
            case TIPPED_ARROW: {
                return new CraftMetaPotion(item.func_77978_p());
            }
            case FILLED_MAP: {
                return new CraftMetaMap(item.func_77978_p());
            }
            case FIREWORK_ROCKET: {
                return new CraftMetaFirework(item.func_77978_p());
            }
            case FIREWORK_STAR: {
                return new CraftMetaCharge(item.func_77978_p());
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.func_77978_p());
            }
            case BLACK_BANNER: 
            case BLACK_WALL_BANNER: 
            case BLUE_BANNER: 
            case BLUE_WALL_BANNER: 
            case BROWN_BANNER: 
            case BROWN_WALL_BANNER: 
            case CYAN_BANNER: 
            case CYAN_WALL_BANNER: 
            case GRAY_BANNER: 
            case GRAY_WALL_BANNER: 
            case GREEN_BANNER: 
            case GREEN_WALL_BANNER: 
            case LIGHT_BLUE_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: 
            case LIGHT_GRAY_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: 
            case LIME_BANNER: 
            case LIME_WALL_BANNER: 
            case MAGENTA_BANNER: 
            case MAGENTA_WALL_BANNER: 
            case ORANGE_BANNER: 
            case ORANGE_WALL_BANNER: 
            case PINK_BANNER: 
            case PINK_WALL_BANNER: 
            case PURPLE_BANNER: 
            case PURPLE_WALL_BANNER: 
            case RED_BANNER: 
            case RED_WALL_BANNER: 
            case WHITE_BANNER: 
            case WHITE_WALL_BANNER: 
            case YELLOW_BANNER: 
            case YELLOW_WALL_BANNER: {
                return new CraftMetaBanner(item.func_77978_p());
            }
            case BAT_SPAWN_EGG: 
            case BEE_SPAWN_EGG: 
            case BLAZE_SPAWN_EGG: 
            case CAT_SPAWN_EGG: 
            case CAVE_SPIDER_SPAWN_EGG: 
            case CHICKEN_SPAWN_EGG: 
            case COD_SPAWN_EGG: 
            case COW_SPAWN_EGG: 
            case CREEPER_SPAWN_EGG: 
            case DOLPHIN_SPAWN_EGG: 
            case DONKEY_SPAWN_EGG: 
            case DROWNED_SPAWN_EGG: 
            case ELDER_GUARDIAN_SPAWN_EGG: 
            case ENDERMAN_SPAWN_EGG: 
            case ENDERMITE_SPAWN_EGG: 
            case EVOKER_SPAWN_EGG: 
            case FOX_SPAWN_EGG: 
            case GHAST_SPAWN_EGG: 
            case GUARDIAN_SPAWN_EGG: 
            case HORSE_SPAWN_EGG: 
            case HUSK_SPAWN_EGG: 
            case LLAMA_SPAWN_EGG: 
            case MAGMA_CUBE_SPAWN_EGG: 
            case MOOSHROOM_SPAWN_EGG: 
            case MULE_SPAWN_EGG: 
            case OCELOT_SPAWN_EGG: 
            case PANDA_SPAWN_EGG: 
            case PARROT_SPAWN_EGG: 
            case PHANTOM_SPAWN_EGG: 
            case PIG_SPAWN_EGG: 
            case PILLAGER_SPAWN_EGG: 
            case POLAR_BEAR_SPAWN_EGG: 
            case PUFFERFISH_SPAWN_EGG: 
            case RABBIT_SPAWN_EGG: 
            case RAVAGER_SPAWN_EGG: 
            case SALMON_SPAWN_EGG: 
            case SHEEP_SPAWN_EGG: 
            case SHULKER_SPAWN_EGG: 
            case SILVERFISH_SPAWN_EGG: 
            case SKELETON_HORSE_SPAWN_EGG: 
            case SKELETON_SPAWN_EGG: 
            case SLIME_SPAWN_EGG: 
            case SPIDER_SPAWN_EGG: 
            case SQUID_SPAWN_EGG: 
            case STRAY_SPAWN_EGG: 
            case TRADER_LLAMA_SPAWN_EGG: 
            case TROPICAL_FISH_SPAWN_EGG: 
            case TURTLE_SPAWN_EGG: 
            case VEX_SPAWN_EGG: 
            case VILLAGER_SPAWN_EGG: 
            case VINDICATOR_SPAWN_EGG: 
            case WANDERING_TRADER_SPAWN_EGG: 
            case WITCH_SPAWN_EGG: 
            case WITHER_SKELETON_SPAWN_EGG: 
            case WOLF_SPAWN_EGG: 
            case ZOMBIE_HORSE_SPAWN_EGG: 
            case ZOMBIE_PIGMAN_SPAWN_EGG: 
            case ZOMBIE_SPAWN_EGG: 
            case ZOMBIE_VILLAGER_SPAWN_EGG: {
                return new CraftMetaSpawnEgg(item.func_77978_p());
            }
            case ARMOR_STAND: {
                return new CraftMetaArmorStand(item.func_77978_p());
            }
            case KNOWLEDGE_BOOK: {
                return new CraftMetaKnowledgeBook(item.func_77978_p());
            }
            case ACACIA_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BARREL: 
            case BEACON: 
            case BEEHIVE: 
            case BEE_NEST: 
            case BELL: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_SIGN: 
            case BLACK_SHULKER_BOX: 
            case BLAST_FURNACE: 
            case BLUE_SHULKER_BOX: 
            case BREWING_STAND: 
            case BROWN_SHULKER_BOX: 
            case CAMPFIRE: 
            case CHAIN_COMMAND_BLOCK: 
            case CHEST: 
            case COMMAND_BLOCK: 
            case COMPARATOR: 
            case CYAN_SHULKER_BOX: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case DAYLIGHT_DETECTOR: 
            case DISPENSER: 
            case DROPPER: 
            case ENCHANTING_TABLE: 
            case ENDER_CHEST: 
            case FURNACE: 
            case GRAY_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case HOPPER: 
            case JIGSAW: 
            case JUKEBOX: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case LECTERN: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case OAK_SIGN: 
            case OAK_WALL_SIGN: 
            case ORANGE_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case REPEATING_COMMAND_BLOCK: 
            case SHIELD: 
            case SHULKER_BOX: 
            case SMOKER: 
            case SPAWNER: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case STRUCTURE_BLOCK: 
            case TRAPPED_CHEST: 
            case WHITE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: {
                return new CraftMetaBlockState(item.func_77978_p(), CraftMagicNumbers.getMaterial(item.func_77973_b()));
            }
            case TROPICAL_FISH_BUCKET: {
                return new CraftMetaTropicalFishBucket(item.func_77978_p());
            }
            case CROSSBOW: {
                return new CraftMetaCrossbow(item.func_77978_p());
            }
            case SUSPICIOUS_STEW: {
                return new CraftMetaSuspiciousStew(item.func_77978_p());
            }
        }
        return new CraftMetaItem(item.func_77978_p());
    }

    static Material getType(net.minecraft.item.ItemStack item) {
        return item == null ? Material.AIR : CraftMagicNumbers.getMaterial(item.func_77973_b());
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(net.minecraft.item.ItemStack item, ItemMeta itemMeta) {
        Item newItem;
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.func_77982_d(null);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        Item oldItem = item.func_77973_b();
        if (oldItem != (newItem = CraftMagicNumbers.getItem(CraftItemFactory.instance().updateMaterial(itemMeta, CraftMagicNumbers.getMaterial(oldItem))))) {
            item.setItem(newItem);
        }
        CompoundNBT tag = new CompoundNBT();
        item.func_77982_d(tag);
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        item.convertStack(((CraftMetaItem)itemMeta).getVersion());
        if (item.func_77973_b() != null && item.func_77973_b().func_77645_m()) {
            item.func_196085_b(item.func_77952_i());
        }
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.func_77978_p().equals((Object)that.handle.func_77978_p()) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(net.minecraft.item.ItemStack item) {
        return item != null && item.func_77978_p() != null && !item.func_77978_p().isEmpty();
    }
}

