/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.inventory.meta.BookMeta;
import org.spigotmc.ValidateUtils;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBook
extends CraftMetaItem
implements BookMeta {
    static final CraftMetaItem.ItemMetaKey BOOK_TITLE = new CraftMetaItem.ItemMetaKey("title");
    static final CraftMetaItem.ItemMetaKey BOOK_AUTHOR = new CraftMetaItem.ItemMetaKey("author");
    static final CraftMetaItem.ItemMetaKey BOOK_PAGES = new CraftMetaItem.ItemMetaKey("pages");
    static final CraftMetaItem.ItemMetaKey RESOLVED = new CraftMetaItem.ItemMetaKey("resolved");
    static final CraftMetaItem.ItemMetaKey GENERATION = new CraftMetaItem.ItemMetaKey("generation");
    static final int MAX_PAGES = 100;
    static final int MAX_PAGE_LENGTH = 320;
    static final int MAX_TITLE_LENGTH = 32;
    protected String title;
    protected String author;
    public List<ITextComponent> pages = new ArrayList<ITextComponent>();
    protected Integer generation;
    private final BookMeta.Spigot spigot = new BookMeta.Spigot(){

        @Override
        public BaseComponent[] getPage(int page) {
            Validate.isTrue((boolean)CraftMetaBook.this.isValidPage(page), (String)"Invalid page number");
            return ComponentSerializer.parse(ITextComponent.Serializer.func_150696_a((ITextComponent)CraftMetaBook.this.pages.get(page - 1)));
        }

        @Override
        public void setPage(int page, BaseComponent ... text) {
            if (!CraftMetaBook.this.isValidPage(page)) {
                throw new IllegalArgumentException("Invalid page number " + page + "/" + CraftMetaBook.this.pages.size());
            }
            BaseComponent[] newText = text == null ? new BaseComponent[]{} : text;
            CraftMetaBook.this.pages.set(page - 1, ITextComponent.Serializer.func_150699_a((String)ComponentSerializer.toString(newText)));
        }

        @Override
        public void setPages(BaseComponent[] ... pages) {
            CraftMetaBook.this.pages.clear();
            this.addPage(pages);
        }

        @Override
        public void addPage(BaseComponent[] ... pages) {
            BaseComponent[][] baseComponentArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                BaseComponent[] page = baseComponentArray[n2];
                if (CraftMetaBook.this.pages.size() >= 100) {
                    return;
                }
                if (page == null) {
                    page = new BaseComponent[]{};
                }
                CraftMetaBook.this.pages.add(ITextComponent.Serializer.func_150699_a((String)ComponentSerializer.toString(page)));
                ++n2;
            }
        }

        @Override
        public List<BaseComponent[]> getPages() {
            final ImmutableList<ITextComponent> copy = ImmutableList.copyOf(CraftMetaBook.this.pages);
            return new AbstractList<BaseComponent[]>(){

                @Override
                public BaseComponent[] get(int index) {
                    return ComponentSerializer.parse(ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)copy.get(index))));
                }

                @Override
                public int size() {
                    return copy.size();
                }
            };
        }

        @Override
        public void setPages(List<BaseComponent[]> pages) {
            CraftMetaBook.this.pages.clear();
            for (BaseComponent[] page : pages) {
                this.addPage(new BaseComponent[][]{page});
            }
        }
    };

    public CraftMetaBook(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook bookMeta = (CraftMetaBook)meta;
            this.title = bookMeta.title;
            this.author = bookMeta.author;
            this.pages.addAll(bookMeta.pages);
            this.generation = bookMeta.generation;
        }
    }

    CraftMetaBook(CompoundNBT tag) {
        this(tag, true);
    }

    CraftMetaBook(CompoundNBT tag, boolean handlePages) {
        super(tag);
        if (tag.func_74764_b(CraftMetaBook.BOOK_TITLE.NBT)) {
            this.title = ValidateUtils.limit(tag.func_74779_i(CraftMetaBook.BOOK_TITLE.NBT), 1024);
        }
        if (tag.func_74764_b(CraftMetaBook.BOOK_AUTHOR.NBT)) {
            this.author = ValidateUtils.limit(tag.func_74779_i(CraftMetaBook.BOOK_AUTHOR.NBT), 1024);
        }
        boolean resolved = false;
        if (tag.func_74764_b(CraftMetaBook.RESOLVED.NBT)) {
            resolved = tag.func_74767_n(CraftMetaBook.RESOLVED.NBT);
        }
        if (tag.func_74764_b(CraftMetaBook.GENERATION.NBT)) {
            this.generation = tag.func_74762_e(CraftMetaBook.GENERATION.NBT);
        }
        if (tag.func_74764_b(CraftMetaBook.BOOK_PAGES.NBT) && handlePages) {
            ListNBT pages = tag.func_150295_c(CraftMetaBook.BOOK_PAGES.NBT, 8);
            int i = 0;
            while (i < Math.min(pages.size(), 100)) {
                block9: {
                    String page = pages.func_150307_f(i);
                    if (resolved) {
                        try {
                            this.pages.add(ITextComponent.Serializer.func_150699_a((String)page));
                            break block9;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.addPage(ValidateUtils.limit(page, 2048));
                }
                ++i;
            }
        }
    }

    CraftMetaBook(Map<String, Object> map) {
        super(map);
        this.setAuthor(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_AUTHOR.BUKKIT, true));
        this.setTitle(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_TITLE.BUKKIT, true));
        Iterable pages = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaBook.BOOK_PAGES.BUKKIT, true);
        if (pages != null) {
            for (Object page : pages) {
                if (!(page instanceof String)) continue;
                this.addPage((String)page);
            }
        }
        this.generation = CraftMetaItem.SerializableMeta.getObject(Integer.class, map, CraftMetaBook.GENERATION.BUKKIT, true);
    }

    @Override
    void applyToItem(CompoundNBT itemData) {
        this.applyToItem(itemData, true);
    }

    void applyToItem(CompoundNBT itemData, boolean handlePages) {
        super.applyToItem(itemData);
        if (this.hasTitle()) {
            itemData.func_74778_a(CraftMetaBook.BOOK_TITLE.NBT, this.title);
        }
        if (this.hasAuthor()) {
            itemData.func_74778_a(CraftMetaBook.BOOK_AUTHOR.NBT, this.author);
        }
        if (handlePages) {
            if (this.hasPages()) {
                ListNBT list = new ListNBT();
                for (ITextComponent page : this.pages) {
                    list.add((Object)StringNBT.func_229705_a_((String)(page == null ? "" : CraftChatMessage.fromComponent(page))));
                }
                itemData.func_218657_a(CraftMetaBook.BOOK_PAGES.NBT, (INBT)list);
            }
            itemData.func_82580_o(CraftMetaBook.RESOLVED.NBT);
        }
        if (this.generation != null) {
            itemData.func_74768_a(CraftMetaBook.GENERATION.NBT, this.generation.intValue());
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBookEmpty();
    }

    boolean isBookEmpty() {
        return !this.hasPages() && !this.hasAuthor() && !this.hasTitle();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAuthor() {
        return this.author != null;
    }

    @Override
    public boolean hasTitle() {
        return this.title != null;
    }

    @Override
    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    @Override
    public boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 32) {
            return false;
        }
        this.title = title;
        return true;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public BookMeta.Generation getGeneration() {
        return this.generation == null ? null : BookMeta.Generation.values()[this.generation];
    }

    @Override
    public void setGeneration(BookMeta.Generation generation) {
        this.generation = generation == null ? null : Integer.valueOf(generation.ordinal());
    }

    @Override
    public String getPage(int page) {
        Validate.isTrue((boolean)this.isValidPage(page), (String)"Invalid page number");
        return CraftChatMessage.fromComponent(this.pages.get(page - 1));
    }

    @Override
    public void setPage(int page, String text) {
        if (!this.isValidPage(page)) {
            throw new IllegalArgumentException("Invalid page number " + page + "/" + this.pages.size());
        }
        String newText = text == null ? "" : (text.length() > 320 ? text.substring(0, 320) : text);
        this.pages.set(page - 1, CraftChatMessage.fromString(newText, true)[0]);
    }

    @Override
    public void setPages(String ... pages) {
        this.pages.clear();
        this.addPage(pages);
    }

    @Override
    public void addPage(String ... pages) {
        String[] stringArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            String page = stringArray[n2];
            if (this.pages.size() >= 100) {
                return;
            }
            if (page == null) {
                page = "";
            } else if (page.length() > 320) {
                page = page.substring(0, 320);
            }
            this.pages.add(CraftChatMessage.fromString(page, true)[0]);
            ++n2;
        }
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public List<String> getPages() {
        return this.pages.stream().map(CraftChatMessage::fromComponent).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void setPages(List<String> pages) {
        this.pages.clear();
        for (String page : pages) {
            this.addPage(page);
        }
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.pages.size();
    }

    @Override
    public CraftMetaBook clone() {
        CraftMetaBook meta = (CraftMetaBook)super.clone();
        meta.pages = new ArrayList<ITextComponent>(this.pages);
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasTitle()) {
            hash = 61 * hash + this.title.hashCode();
        }
        if (this.hasAuthor()) {
            hash = 61 * hash + 13 * this.author.hashCode();
        }
        if (this.hasPages()) {
            hash = 61 * hash + 17 * this.pages.hashCode();
        }
        if (this.hasGeneration()) {
            hash = 61 * hash + 19 * this.generation.hashCode();
        }
        return original != hash ? CraftMetaBook.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook that = (CraftMetaBook)meta;
            return (this.hasTitle() ? that.hasTitle() && this.title.equals(that.title) : !that.hasTitle()) && (this.hasAuthor() ? that.hasAuthor() && this.author.equals(that.author) : !that.hasAuthor()) && (this.hasPages() ? that.hasPages() && this.pages.equals(that.pages) : !that.hasPages()) && (this.hasGeneration() ? that.hasGeneration() && this.generation.equals(that.generation) : !that.hasGeneration());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBook || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasTitle()) {
            builder.put(CraftMetaBook.BOOK_TITLE.BUKKIT, this.title);
        }
        if (this.hasAuthor()) {
            builder.put(CraftMetaBook.BOOK_AUTHOR.BUKKIT, this.author);
        }
        if (this.hasPages()) {
            ArrayList<String> pagesString = new ArrayList<String>();
            for (ITextComponent comp : this.pages) {
                pagesString.add(CraftChatMessage.fromComponent(comp));
            }
            builder.put(CraftMetaBook.BOOK_PAGES.BUKKIT, pagesString);
        }
        if (this.generation != null) {
            builder.put(CraftMetaBook.GENERATION.BUKKIT, this.generation);
        }
        return builder;
    }

    @Override
    public BookMeta.Spigot spigot() {
        return this.spigot;
    }
}

