/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftTeam;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements org.bukkit.scoreboard.Scoreboard {
    final Scoreboard board;

    CraftScoreboard(Scoreboard board) {
        this.board = board;
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Objective name cannot be null");
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.notNull((Object)((Object)renderType), (String)"RenderType cannot be null");
        Validate.isTrue((name.length() <= 16 ? 1 : 0) != 0, (String)("The name '" + name + "' is longer than the limit of 16 characters"));
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("The display name '" + displayName + "' is longer than the limit of 128 characters"));
        Validate.isTrue((this.board.func_96518_b(name) == null ? 1 : 0) != 0, (String)("An objective of name '" + name + "' already exists"));
        CraftCriteria craftCriteria = CraftCriteria.getFromBukkit(criteria);
        ScoreObjective objective = this.board.func_199868_a(name, craftCriteria.criteria, CraftChatMessage.fromStringOrNull(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType));
        return new CraftObjective(this, objective);
    }

    @Override
    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        ScoreObjective nms = this.board.func_96518_b(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (ScoreObjective netObjective : this.board.func_96514_c()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add(objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf(Iterables.transform(this.board.func_96514_c(), new Function<ScoreObjective, Objective>(){

            @Override
            public Objective apply(ScoreObjective input) {
                return new CraftObjective(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Display slot cannot be null");
        ScoreObjective objective = this.board.func_96539_a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (ScoreObjective objective : this.board.func_96514_c()) {
            scores.add(new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    @Override
    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.resetScores(player.getName());
    }

    @Override
    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        for (ScoreObjective objective : this.board.func_96514_c()) {
            this.board.func_178822_d(entry, objective);
        }
    }

    @Override
    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        ScorePlayerTeam team = this.board.func_96509_i(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        ScorePlayerTeam team = this.board.func_96509_i(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull((Object)teamName, (String)"Team name cannot be null");
        ScorePlayerTeam team = this.board.func_96508_e(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf(Iterables.transform(this.board.func_96525_g(), new Function<ScorePlayerTeam, Team>(){

            @Override
            public Team apply(ScorePlayerTeam input) {
                return new CraftTeam(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Team name cannot be null");
        Validate.isTrue((name.length() <= 16 ? 1 : 0) != 0, (String)("Team name '" + name + "' is longer than the limit of 16 characters"));
        Validate.isTrue((this.board.func_96508_e(name) == null ? 1 : 0) != 0, (String)("Team name '" + name + "' is already in use"));
        return new CraftTeam(this, this.board.func_96527_f(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (Object playerName : this.board.func_96526_d()) {
            players.add(Bukkit.getOfflinePlayer(playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (Object entry : this.board.func_96526_d()) {
            entries.add(entry.toString());
        }
        return entries.build();
    }

    @Override
    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Slot cannot be null");
        this.board.func_96530_a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public Scoreboard getHandle() {
        return this.board;
    }
}

