/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public final class CraftRayTraceResult {
    private CraftRayTraceResult() {
    }

    public static RayTraceResult fromNMS(World world, net.minecraft.util.math.RayTraceResult nmsHitResult) {
        if (nmsHitResult == null || nmsHitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return null;
        }
        Vec3d nmsHitPos = nmsHitResult.func_216347_e();
        Vector hitPosition = new Vector(nmsHitPos.field_72450_a, nmsHitPos.field_72448_b, nmsHitPos.field_72449_c);
        BlockFace hitBlockFace = null;
        if (nmsHitResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            CraftEntity hitEntity = ((EntityRayTraceResult)nmsHitResult).func_216348_a().getBukkitEntity();
            return new RayTraceResult(hitPosition, hitEntity, null);
        }
        Block hitBlock = null;
        BlockPos nmsBlockPos = null;
        if (nmsHitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockHitResult = (BlockRayTraceResult)nmsHitResult;
            hitBlockFace = CraftBlock.notchToBlockFace(blockHitResult.func_216354_b());
            nmsBlockPos = blockHitResult.func_216350_a();
        }
        if (nmsBlockPos != null && world != null) {
            hitBlock = world.getBlockAt(nmsBlockPos.func_177958_n(), nmsBlockPos.func_177956_o(), nmsBlockPos.func_177952_p());
        }
        return new RayTraceResult(hitPosition, hitBlock, hitBlockFace);
    }
}

