/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.bukkit.EntityTypeBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.i18n.LocalizedException;
import io.izzel.arclight.i18n.conf.EntityPropertySpec;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityType.class}, remap=false)
public class EntityTypeMixin
implements EntityTypeBridge {
    @Shadow
    @Final
    @Mutable
    private NamespacedKey key;
    @Shadow
    @Final
    @Mutable
    private Class<? extends Entity> clazz;
    @Shadow
    @Final
    @Mutable
    private String name;
    private class_1299<?> handleType;
    private EntityPropertySpec spec;
    private Function<Location, ? extends class_1297> factory;

    @Override
    public void bridge$setup(class_2960 location, class_1299<?> entityType, EntityPropertySpec spec) {
        this.key = CraftNamespacedKey.fromMinecraft(location);
        this.name = location.toString();
        this.handleType = entityType;
        this.spec = spec.clone();
        this.setup();
    }

    private void setup() {
        if (this.spec.entityClass != null) {
            try {
                Class<?> cl = Class.forName(this.spec.entityClass);
                if (!Entity.class.isAssignableFrom(cl)) {
                    throw LocalizedException.checked("registry.entity.not-subclass", cl, Entity.class);
                }
                this.clazz = cl;
            }
            catch (Exception e) {
                if (e instanceof LocalizedException) {
                    ArclightServer.LOGGER.warn(((LocalizedException)((Object)e)).node(), ((LocalizedException)((Object)e)).args());
                }
                ArclightServer.LOGGER.warn("registry.entity.error", (Object)this, (Object)this.spec.entityClass, (Object)e);
            }
        }
        this.factory = loc -> {
            if (loc != null && loc.getWorld() != null) {
                class_3218 world = ((CraftWorld)loc.getWorld()).getHandle();
                class_1297 entity = this.handleType.method_5883((class_1937)world);
                if (entity != null) {
                    entity.method_5808(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
                }
                if (entity instanceof class_1309) {
                    entity.method_5847(loc.getYaw());
                    entity.method_5636(loc.getYaw());
                }
                return entity;
            }
            return null;
        };
    }

    @Override
    public class_1299<?> bridge$getHandle() {
        return this.handleType;
    }

    @Override
    public void bridge$setHandle(class_1299<?> entityType) {
        this.handleType = entityType;
    }

    @Override
    public EntityPropertySpec bridge$getSpec() {
        return this.spec;
    }

    @Override
    public Function<Location, ? extends class_1297> bridge$entityFactory() {
        return this.factory;
    }

    @Override
    public void bridge$setEntityFactory(Function<Location, ? extends class_1297> function) {
        this.factory = function;
    }
}

