/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.network.common.ServerCommonPacketListenerBridge;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_124;
import net.minecraft.class_1255;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2600;
import net.minecraft.class_2661;
import net.minecraft.class_2759;
import net.minecraft.class_2817;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import net.minecraft.class_7648;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.class_9091;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_8609.class})
public abstract class ServerCommonPacketListenerImplMixin
implements ServerCommonPacketListenerBridge,
class_2547,
CraftPlayer.TransferCookieConnection {
    @Shadow
    @Final
    protected class_2535 field_45013;
    @Shadow
    @Final
    protected MinecraftServer field_45012;
    @Shadow
    @Final
    private static Logger field_45014;
    @Shadow
    @Final
    private boolean field_48274;
    protected class_3222 player;
    protected CraftServer cserver;
    public boolean processedDisconnect;
    private static final class_2960 CUSTOM_REGISTER;
    private static final class_2960 CUSTOM_UNREGISTER;

    @Shadow
    public abstract void method_14364(class_2596<?> var1);

    @Shadow
    protected abstract boolean method_52402();

    @Shadow
    public abstract void method_60673(class_9812 var1);

    @Shadow
    public abstract void method_10839(class_9812 var1);

    @Shadow
    public abstract void method_52396(class_2561 var1);

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : ((ServerPlayerEntityBridge)this.player).bridge$getBukkitEntity();
    }

    @Override
    public CraftServer bridge$getCraftServer() {
        return this.cserver;
    }

    @Override
    public CraftPlayer bridge$getCraftPlayer() {
        return this.getCraftPlayer();
    }

    @Override
    public class_3222 bridge$getPlayer() {
        return this.player;
    }

    @Override
    public void bridge$setPlayer(class_3222 player) {
        this.player = player;
        ((ServerPlayerEntityBridge)this.player).bridge$setTransferCookieConnection(this);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(MinecraftServer p_299469_, class_2535 p_300872_, class_8792 p_300277_, CallbackInfo ci) {
        this.cserver = (CraftServer)Bukkit.getServer();
    }

    @ModifyConstant(method={"keepConnectionAlive"}, constant={@Constant(longValue=15000L)})
    private long arclight$incrKeepaliveTimeout(long l) {
        return 25000L;
    }

    @Override
    public boolean bridge$processedDisconnect() {
        return this.processedDisconnect;
    }

    public final boolean isDisconnected() {
        return !((ServerPlayerEntityBridge)this.player).bridge$isJoining() && !this.field_45013.method_10758();
    }

    @Override
    public boolean bridge$isDisconnected() {
        return this.isDisconnected();
    }

    public void disconnect(String s) {
        this.method_52396((class_2561)class_2561.method_43470((String)s));
    }

    @Override
    public void bridge$disconnect(String s) {
        this.disconnect(s);
    }

    @Decorate(method={"disconnect(Lnet/minecraft/network/DisconnectionDetails;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"))
    private void arclight$kickEvent(class_2535 instance, class_2596<?> packet, class_7648 packetSendListener, final class_9812 disconnectionDetails) throws Throwable {
        if (this.processedDisconnect) {
            DecorationOps.cancel().invoke();
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable<Object> waitable = new Waitable<Object>(){

                @Override
                protected Object evaluate() {
                    ServerCommonPacketListenerImplMixin.this.method_60673(disconnectionDetails);
                    return null;
                }
            };
            ((MinecraftServerBridge)this.field_45012).bridge$queuedProcess(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            DecorationOps.cancel().invoke();
            return;
        }
        String leaveMessage = String.valueOf(class_124.field_1054) + this.player.method_5820() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent(this.getCraftPlayer(), CraftChatMessage.fromComponent(disconnectionDetails.comp_2853()), leaveMessage);
        if (this.cserver.getServer().method_3806()) {
            this.cserver.getPluginManager().callEvent(event);
        }
        if (event.isCancelled()) {
            DecorationOps.cancel().invoke();
            return;
        }
        ArclightCaptures.captureQuitMessage(event.getLeaveMessage());
        class_2561 textComponent = CraftChatMessage.fromString(event.getReason(), true)[0];
        class_2661 newPacket = new class_2661(textComponent);
        DecorationOps.callsite().invoke(instance, (class_2596)newPacket, packetSendListener);
        this.method_10839(disconnectionDetails);
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$updateCompassTarget(class_2596<?> packetIn, class_7648 futureListeners, CallbackInfo ci) {
        if (packetIn == null || this.processedDisconnect) {
            ci.cancel();
            return;
        }
        if (packetIn instanceof class_2759) {
            class_2759 packet6 = (class_2759)packetIn;
            ((ServerPlayerEntityBridge)this.player).bridge$setCompassTarget(new Location(this.getCraftPlayer().getWorld(), packet6.field_12615.method_10263(), packet6.field_12615.method_10264(), packet6.field_12615.method_10260()));
        }
    }

    @Inject(method={"handleResourcePackResponse"}, at={@At(value="RETURN")})
    private void arclight$handleResourcePackStatus(class_2856 packetIn, CallbackInfo ci) {
        this.cserver.getPluginManager().callEvent(new PlayerResourcePackStatusEvent(this.getCraftPlayer(), packetIn.comp_2163(), PlayerResourcePackStatusEvent.Status.values()[packetIn.comp_2164().ordinal()]));
    }

    @Inject(method={"handleCookieResponse"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$handleCookie(class_9091 serverboundCookieResponsePacket, CallbackInfo ci) {
        class_2600.method_11074((class_2596)serverboundCookieResponsePacket, (class_2547)((class_8609)this), (class_1255)this.field_45012);
        if (((CraftPlayer)this.player.bridge$getBukkitEntity()).handleCookieResponse(serverboundCookieResponsePacket)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    private void arclight$customPayload(class_2817 packet, CallbackInfo ci) {
        class_2540 data = this.bridge$getDiscardedData(packet);
        if (data != null) {
            int readerIndex = data.readerIndex();
            byte[] buf = new byte[data.readableBytes()];
            data.method_52979(buf);
            data.method_52988(readerIndex);
            ArclightServer.getMinecraftServer().method_40000(() -> {
                if (((MinecraftServerBridge)ArclightServer.getMinecraftServer()).bridge$hasStopped() || this.bridge$processedDisconnect()) {
                    return;
                }
                if (this.field_45013.method_10758()) {
                    if (packet.comp_1647().method_56479().comp_2242().equals((Object)CUSTOM_REGISTER)) {
                        try {
                            String channels = new String(buf, StandardCharsets.UTF_8);
                            for (String channel : channels.split("\u0000")) {
                                if (class_3544.method_15438((String)channel)) continue;
                                this.bridge$getCraftPlayer().addChannel(channel);
                            }
                        }
                        catch (Exception ex) {
                            field_45014.error("Couldn't register custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid payload REGISTER!");
                        }
                    } else if (packet.comp_1647().method_56479().comp_2242().equals((Object)CUSTOM_UNREGISTER)) {
                        try {
                            String channels = new String(buf, StandardCharsets.UTF_8);
                            for (String channel : channels.split("\u0000")) {
                                if (class_3544.method_15438((String)channel)) continue;
                                this.bridge$getCraftPlayer().removeChannel(channel);
                            }
                        }
                        catch (Exception ex) {
                            field_45014.error("Couldn't unregister custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid payload UNREGISTER!");
                        }
                    } else {
                        try {
                            this.bridge$getCraftServer().getMessenger().dispatchIncomingMessage(((ServerPlayerEntityBridge)this.bridge$getPlayer()).bridge$getBukkitEntity(), packet.comp_1647().method_56479().comp_2242().toString(), buf);
                        }
                        catch (Exception ex) {
                            field_45014.error("Couldn't dispatch custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid custom payload!");
                        }
                    }
                }
            });
        }
    }

    @Override
    public boolean isTransferred() {
        return this.field_48274;
    }

    @Override
    public class_2539 getProtocol() {
        return this.method_52280();
    }

    @Override
    public void sendPacket(class_2596<?> packet) {
        this.method_14364(packet);
    }

    static {
        CUSTOM_REGISTER = class_2960.method_60656((String)"register");
        CUSTOM_UNREGISTER = class_2960.method_60656((String)"unregister");
    }
}

