/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import io.izzel.arclight.common.bridge.core.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.core.network.handshake.ServerHandshakeNetHandlerBridge;
import io.izzel.arclight.common.mod.util.VelocitySupport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2889;
import net.minecraft.class_2909;
import net.minecraft.class_3246;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3246.class})
public abstract class ServerHandshakeNetHandlerMixin
implements ServerHandshakeNetHandlerBridge {
    private static final Gson gson = new Gson();
    private static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    @Shadow
    @Final
    private class_2535 field_14153;

    @Inject(method={"handleIntention"}, at={@At(value="HEAD")})
    private void arclight$setHostName(class_2889 packet, CallbackInfo ci) {
        if (!this.bridge$forge$handleSpecialLogin(packet)) {
            return;
        }
        ((NetworkManagerBridge)this.field_14153).bridge$setHostname(packet.comp_1564() + ":" + packet.comp_1565());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"beginLogin"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/Connection;setupOutboundProtocol(Lnet/minecraft/network/ProtocolInfo;)V")})
    private void arclight$throttler(class_2889 packet, boolean bl, CallbackInfo ci) {
        try {
            long currentTime = System.currentTimeMillis();
            long connectionThrottle = Bukkit.getServer().getConnectionThrottle();
            InetAddress address = ((InetSocketAddress)this.field_14153.method_10755()).getAddress();
            HashMap<InetAddress, Long> hashMap = throttleTracker;
            synchronized (hashMap) {
                if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                    throttleTracker.put(address, currentTime);
                    class_5250 component = class_2561.method_43470((String)"Connection throttled! Please wait before reconnecting.");
                    this.field_14153.method_10743((class_2596)new class_2909((class_2561)component));
                    this.field_14153.method_10747((class_2561)component);
                    ci.cancel();
                    return;
                }
                throttleTracker.put(address, currentTime);
                if (++throttleCounter > 200) {
                    throttleCounter = 0;
                    throttleTracker.entrySet().removeIf(entry -> (Long)entry.getValue() > connectionThrottle);
                }
            }
        }
        catch (Throwable t) {
            LogManager.getLogger().debug("Failed to check connection throttle", t);
        }
    }

    @Inject(method={"beginLogin"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/Connection;setupInboundProtocol(Lnet/minecraft/network/ProtocolInfo;Lnet/minecraft/network/PacketListener;)V")})
    private void arclight$proxySupport(class_2889 packet, boolean bl, CallbackInfo ci) {
        if (!VelocitySupport.isEnabled()) {
            String[] split = packet.comp_1564().split("\u0000");
            if (SpigotConfig.bungee) {
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                    class_5250 component = class_2561.method_43470((String)"If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                    this.field_14153.method_10743((class_2596)new class_2909((class_2561)component));
                    this.field_14153.method_10747((class_2561)component);
                    ci.cancel();
                    return;
                }
                ((NetworkManagerBridge)this.field_14153).bridge$setHostname(split[0]);
                this.field_14153.field_11645 = new InetSocketAddress(split[1], ((InetSocketAddress)this.field_14153.method_10755()).getPort());
                ((NetworkManagerBridge)this.field_14153).bridge$setSpoofedUUID(UndashedUuid.fromStringLenient((String)split[2]));
                if (split.length == 4) {
                    ((NetworkManagerBridge)this.field_14153).bridge$setSpoofedProfile((Property[])gson.fromJson(split[3], Property[].class));
                }
            } else if ((split.length == 3 || split.length == 4) && HOST_PATTERN.matcher(split[1]).matches()) {
                class_5250 component = class_2561.method_43470((String)"Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.field_14153.method_10743((class_2596)new class_2909((class_2561)component));
                this.field_14153.method_10747((class_2561)component);
                ci.cancel();
            }
        }
    }
}

