/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server;

import com.mojang.datafixers.DataFixer;
import io.izzel.arclight.api.ArclightVersion;
import io.izzel.arclight.common.bridge.bukkit.CraftServerBridge;
import io.izzel.arclight.common.bridge.core.command.ICommandSourceBridge;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.mixins.annotation.TransformAccess;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.BukkitRegistry;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.BukkitOptionParser;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_269;
import net.minecraft.class_2784;
import net.minecraft.class_2926;
import net.minecraft.class_2991;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_3324;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3738;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_4093;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6396;
import net.minecraft.class_6904;
import net.minecraft.class_7237;
import net.minecraft.class_7497;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.WatchdogThread;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends class_4093<class_3738>
implements MinecraftServerBridge,
ICommandSourceBridge {
    @Shadow
    private int field_4572;
    @Shadow
    protected long field_47139;
    @Shadow
    private class_2926 field_4593;
    @Shadow
    @Nullable
    private String field_4564;
    @Shadow
    private volatile boolean field_4544;
    @Shadow
    private long field_47138;
    @Shadow
    @Final
    static Logger field_4546;
    @Shadow
    private boolean field_19249;
    @Shadow
    private long field_47140;
    @Shadow
    private volatile boolean field_4547;
    @Shadow
    private boolean field_4561;
    @Shadow
    private class_3695 field_16258;
    @Shadow
    private Map<class_5321<class_1937>, class_3218> field_4589;
    @Shadow
    protected class_5219 field_24372;
    @Shadow
    @Final
    private class_3283 field_4595;
    @Shadow
    @Final
    public Executor field_17200;
    @Shadow
    public MinecraftServer.class_6897 field_25318;
    @Shadow
    @Final
    private class_2991 field_4591;
    @Shadow
    @Final
    protected class_7497 field_39440;
    @Shadow
    @Final
    private class_3485 field_24370;
    @Shadow
    private boolean field_33979;
    @Shadow
    @Nullable
    private MinecraftServer.class_6414 field_33978;
    @Shadow
    @Nullable
    private class_2926.class_8145 field_42958;
    @Shadow
    @Final
    private class_8915 field_47142;
    @Shadow
    @Final
    private static long field_47143;
    @Shadow
    @Final
    private static long field_47145;
    @Shadow
    private float field_47141;
    public class_7237.class_7660 worldLoader;
    private boolean forceTicks;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public RemoteConsoleCommandSender remoteConsole;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public class_2170 vanillaCommandDispatcher;
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    private static final int TPS = 20;
    private static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    @TransformAccess(value=9)
    private static int currentTick;
    public final double[] recentTps = new double[3];

    @Shadow
    protected abstract boolean method_3823() throws IOException;

    @Shadow
    public abstract void method_3748(BooleanSupplier var1);

    @Shadow
    protected abstract boolean method_3866();

    @Shadow
    protected abstract void method_16208();

    @Shadow
    protected abstract void method_3744(class_128 var1);

    @Shadow
    public abstract void method_3782();

    @Shadow
    public abstract void method_3821();

    @Shadow
    public abstract class_2170 method_3734();

    @Shadow
    protected abstract void method_27729();

    @Shadow
    public abstract class_3218 method_30002();

    @Shadow
    protected abstract void method_17977(class_5219 var1);

    @Shadow
    private static void method_27901(class_3218 p_177897_, class_5268 p_177898_, boolean p_177899_, boolean p_177900_) {
    }

    @Shadow
    public abstract boolean method_3783();

    @Shadow
    public abstract boolean method_3796();

    @Shadow
    protected abstract void method_24487();

    @Shadow
    protected abstract void method_24490();

    @Shadow
    public abstract class_6396 method_37324(class_6396 var1);

    @Shadow
    public abstract boolean method_3816();

    @Shadow
    public abstract int method_21714();

    @Shadow
    public abstract class_5455.class_6890 method_30611();

    @Shadow
    public abstract class_3324 method_3760();

    @Shadow
    public abstract boolean method_43500();

    @Shadow
    private static class_128 method_40376(Throwable p_206569_) {
        return null;
    }

    @Shadow
    public abstract class_7780<class_7659> method_46221();

    @Shadow
    protected abstract class_2926 method_49385();

    @Shadow
    protected abstract Optional<class_2926.class_8145> method_49384();

    @Shadow
    public abstract boolean method_54809();

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    @Override
    public boolean bridge$hasStopped() {
        return this.hasStopped();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$loadOptions(Thread p_236723_, class_32.class_5143 p_236724_, class_3283 p_236725_, class_6904 worldStem, Proxy p_236727_, DataFixer p_236728_, class_7497 p_236729_, class_3950 p_236730_, CallbackInfo ci) {
        String[] arguments = ManagementFactory.getRuntimeMXBean().getInputArguments().toArray(new String[0]);
        BukkitOptionParser parser = new BukkitOptionParser();
        try {
            this.options = parser.parse(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.vanillaCommandDispatcher = worldStem.comp_357().method_29472();
        this.worldLoader = ArclightCaptures.getDataLoadContext();
        ArclightServer.setMinecraftServer((MinecraftServer)this);
    }

    @Decorate(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;buildServerStatus()Lnet/minecraft/network/protocol/status/ServerStatus;"))
    private class_2926 arclight$initTickParam(MinecraftServer instance, @Local(allocate="tickSection") long tickSection, @Local(allocate="tickCount") long tickCount) throws Throwable {
        class_2926 serverStatus = DecorationOps.callsite().invoke(instance);
        Arrays.fill(this.recentTps, 20.0);
        tickSection = class_156.method_658();
        tickCount = 1L;
        DecorationOps.blackhole().invoke(tickSection, tickCount);
        return serverStatus;
    }

    @Decorate(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;startMetricsRecordingTick()V"))
    private void arclight$updateTickParam(MinecraftServer instance, @Local(allocate="tickSection") long tickSection, @Local(allocate="tickCount") long tickCount) throws Throwable {
        if (tickCount++ % 100L == 0L) {
            long curTime = class_156.method_658();
            double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
            this.recentTps[0] = MinecraftServerMixin.calcTps(this.recentTps[0], 0.92, currentTps);
            this.recentTps[1] = MinecraftServerMixin.calcTps(this.recentTps[1], 0.9835, currentTps);
            this.recentTps[2] = MinecraftServerMixin.calcTps(this.recentTps[2], 0.9945, currentTps);
            tickSection = curTime;
        }
        DecorationOps.blackhole().invoke(tickSection, tickCount);
        currentTick = (int)(System.currentTimeMillis() / 50L);
        DecorationOps.callsite().invoke(instance);
    }

    @Decorate(method={"runServer"}, at=@At(value="INVOKE", remap=false, target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"))
    private void arclight$warnOnLoad(Logger instance, String s, Object o, Object o2) throws Throwable {
        if (this.server.getWarnOnOverload()) {
            DecorationOps.callsite().invoke(instance, s, o, o2);
        }
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;onServerExit()V")})
    private void arclight$watchdogExit(CallbackInfo ci) {
        WatchdogThread.doStop();
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"stopServer"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setStopped(CallbackInfo ci) {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                ci.cancel();
                return;
            }
            this.hasStopped = true;
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="INVOKE", remap=false, ordinal=0, shift=At.Shift.AFTER, target="Lorg/slf4j/Logger;info(Ljava/lang/String;)V")})
    public void arclight$unloadPlugins(CallbackInfo ci) {
        if (this.server != null) {
            this.server.disablePlugins();
        }
    }

    @Inject(method={"createLevels"}, at={@At(value="RETURN")})
    public void arclight$enablePlugins(class_3949 p_240787_1_, CallbackInfo ci) {
        this.bridge$forge$unlockRegistries();
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.bridge$forge$lockRegistries();
        this.server.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
    }

    private void executeModerately() {
        this.method_5383();
        this.bridge$drainQueuedTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    @Override
    public void bridge$drainQueuedTasks() {
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
    }

    @Inject(method={"haveTime"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forceAheadOfTime(CallbackInfoReturnable<Boolean> cir) {
        if (this.forceTicks) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"createLevels"}, at={@At(value="NEW", ordinal=0, target="(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;Lnet/minecraft/server/level/progress/ChunkProgressListener;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)Lnet/minecraft/server/level/ServerLevel;")})
    private void arclight$registerEnv(class_3949 p_240787_1_, CallbackInfo ci) {
        BukkitRegistry.registerEnvironments((class_2378<class_5363>)this.method_30611().method_30530(class_7924.field_41224));
    }

    @Decorate(method={"createLevels"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object arclight$worldInit(Map<Object, Object> instance, Object k, Object v, class_3949 chunkProgressListener) throws Throwable {
        class_3218 serverWorld = (class_3218)v;
        if (serverWorld != null) {
            if (((CraftServer)Bukkit.getServer()).scoreboardManager == null) {
                ((CraftServer)Bukkit.getServer()).scoreboardManager = new CraftScoreboardManager((MinecraftServer)this, (class_269)serverWorld.method_14170());
            }
            if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
                serverWorld.bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(serverWorld.bridge$getWorld()));
            }
            Bukkit.getPluginManager().callEvent(new WorldInitEvent(serverWorld.bridge$getWorld()));
        }
        return DecorationOps.callsite().invoke(instance, k, v);
    }

    @Overwrite
    public final void method_3774(class_3949 listener) {
        int j;
        class_3218 serverworld = this.method_30002();
        this.forceTicks = true;
        field_4546.info("Preparing start region for dimension {}", (Object)serverworld.method_27983().method_29177());
        class_2338 blockpos = serverworld.method_43126();
        listener.method_17669(new class_1923(blockpos));
        class_3215 serverchunkprovider = serverworld.method_14178();
        this.field_47139 = class_156.method_648();
        serverworld.method_8554(blockpos, serverworld.method_43127());
        int i = serverworld.method_8450().method_8356(class_1928.field_48374);
        int n = j = i > 0 ? class_3532.method_34954((int)class_3949.method_56041((int)i)) : 0;
        while (serverchunkprovider.method_17301() < j) {
            this.executeModerately();
        }
        this.executeModerately();
        for (class_3218 serverWorld : this.field_4589.values()) {
            class_1932 forcedchunkssavedata;
            if (serverWorld.bridge$getWorld().getKeepSpawnInMemory() && (forcedchunkssavedata = (class_1932)serverWorld.method_17983().method_20786(class_1932.method_52570(), "chunks")) != null) {
                LongIterator longiterator = forcedchunkssavedata.method_8375().iterator();
                while (longiterator.hasNext()) {
                    long k = longiterator.nextLong();
                    class_1923 chunkpos = new class_1923(k);
                    serverWorld.method_14178().method_12124(chunkpos, true);
                }
                this.bridge$forge$reinstatePersistentChunks(serverWorld, forcedchunkssavedata);
            }
            Bukkit.getPluginManager().callEvent(new WorldLoadEvent(serverWorld.bridge$getWorld()));
        }
        this.executeModerately();
        listener.method_17671();
        this.method_27729();
        this.forceTicks = false;
    }

    public void initWorld(class_3218 serverWorld, class_5268 worldInfo, class_5219 saveData, class_5285 worldOptions) {
        boolean flag = saveData.method_45556();
        if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
            serverWorld.bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(serverWorld.bridge$getWorld()));
        }
        class_2784 worldborder = serverWorld.method_8621();
        worldborder.method_17905(worldInfo.method_27422());
        if (!worldInfo.method_222()) {
            try {
                MinecraftServerMixin.method_27901(serverWorld, worldInfo, worldOptions.method_28030(), flag);
                worldInfo.method_223(true);
                if (flag) {
                    this.method_17977(this.field_24372);
                }
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Exception initializing level");
                try {
                    serverWorld.method_8538(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new class_148(crashreport);
            }
            worldInfo.method_223(true);
        }
    }

    public void prepareLevels(class_3949 listener, class_3218 serverWorld) {
        int j;
        this.bridge$forge$markLevelsDirty();
        this.bridge$platform$loadLevel((class_1937)serverWorld);
        if (!serverWorld.bridge$getWorld().getKeepSpawnInMemory()) {
            return;
        }
        this.forceTicks = true;
        field_4546.info("Preparing start region for dimension {}", (Object)serverWorld.method_27983().method_29177());
        class_2338 blockpos = serverWorld.method_43126();
        listener.method_17669(new class_1923(blockpos));
        class_3215 serverchunkprovider = serverWorld.method_14178();
        this.field_47139 = class_156.method_648();
        serverWorld.method_8554(blockpos, serverWorld.method_43127());
        int i = serverWorld.method_8450().method_8356(class_1928.field_48374);
        int n = j = i > 0 ? class_3532.method_34954((int)class_3949.method_56041((int)i)) : 0;
        while (serverchunkprovider.method_17301() < j) {
            this.executeModerately();
        }
        this.executeModerately();
        class_1932 forcedchunkssavedata = (class_1932)serverWorld.method_17983().method_20786(class_1932.method_52570(), "chunks");
        if (forcedchunkssavedata != null) {
            LongIterator longiterator = forcedchunkssavedata.method_8375().iterator();
            while (longiterator.hasNext()) {
                long k = longiterator.nextLong();
                class_1923 chunkpos = new class_1923(k);
                serverWorld.method_14178().method_12124(chunkpos, true);
            }
            this.bridge$forge$reinstatePersistentChunks(serverWorld, forcedchunkssavedata);
        }
        this.executeModerately();
        listener.method_17671();
        serverWorld.method_8424(this.method_3783(), this.method_3796());
        this.forceTicks = false;
    }

    public void addLevel(class_3218 level) {
        this.field_4589.put((class_5321<class_1937>)level.method_27983(), level);
        this.bridge$forge$markLevelsDirty();
    }

    public void removeLevel(class_3218 level) {
        this.bridge$platform$unloadLevel((class_1937)level);
        this.field_4589.remove(level.method_27983());
        this.bridge$forge$markLevelsDirty();
        ((CraftServerBridge)((Object)Bukkit.getServer())).bridge$removeWorld(level);
    }

    @Inject(method={"tickChildren"}, at={@At(value="HEAD")})
    public void arclight$runScheduler(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ArclightConstants.currentTick = (int)(System.currentTimeMillis() / 50L);
        this.server.getScheduler().mainThreadHeartbeat(this.field_4572);
        this.bridge$drainQueuedTasks();
    }

    @Inject(method={"stopServer"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/MinecraftServer;saveAllChunks(ZZZ)Z")})
    private void arclight$unloadLevel(CallbackInfo ci) {
        for (class_3218 serverLevel : this.method_3738()) {
            ((CraftServerBridge)((Object)Bukkit.getServer())).bridge$removeWorld(serverLevel);
        }
    }

    @Inject(method={"saveAllChunks"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;overworld()Lnet/minecraft/server/level/ServerLevel;")})
    private void arclight$skipSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(!this.field_4589.isEmpty() ? 1 : 0));
    }

    @Inject(method={"*"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/WorldData;setDataConfiguration(Lnet/minecraft/world/level/WorldDataConfiguration;)V")})
    private void arclight$syncCommand(CallbackInfo ci) {
        this.server.syncCommands();
    }

    @Inject(method={"getServerModName"}, remap=false, cancellable=true, at={@At(value="RETURN")})
    private void arclight$brand(CallbackInfoReturnable<String> cir) {
        cir.setReturnValue((Object)((String)cir.getReturnValue() + " arclight/" + ArclightVersion.current().getReleaseName()));
    }

    @Override
    public void bridge$setAutosavePeriod(int autosavePeriod) {
        this.autosavePeriod = autosavePeriod;
    }

    @Override
    public void bridge$setConsole(ConsoleCommandSender console) {
        this.console = console;
    }

    @Override
    public void bridge$setServer(CraftServer server) {
        this.server = server;
    }

    @Override
    public RemoteConsoleCommandSender bridge$getRemoteConsole() {
        return this.remoteConsole;
    }

    @Override
    public void bridge$setRemoteConsole(RemoteConsoleCommandSender sender) {
        this.remoteConsole = sender;
    }

    @Override
    public void bridge$queuedProcess(Runnable runnable) {
        this.processQueue.add(runnable);
    }

    public CommandSender getBukkitSender(class_2168 wrapper) {
        return this.console;
    }

    @Override
    public CommandSender bridge$getBukkitSender(class_2168 wrapper) {
        return this.getBukkitSender(wrapper);
    }

    @Override
    public class_2170 bridge$getVanillaCommands() {
        return this.vanillaCommandDispatcher;
    }

    public boolean isDebugging() {
        return false;
    }

    @TransformAccess(value=9)
    private static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    @TransformAccess(value=9)
    private static class_5455 getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    static {
        currentTick = (int)(System.currentTimeMillis() / 50L);
    }
}

