/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.dedicated;

import io.izzel.arclight.common.bridge.core.server.dedicated.DedicatedServerBridge;
import io.izzel.arclight.common.mixin.core.server.MinecraftServerMixin;
import io.izzel.arclight.common.mod.server.ArclightServer;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2976;
import net.minecraft.class_3176;
import net.minecraft.class_3350;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftRemoteConsoleCommandSender;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3176.class})
public abstract class DedicatedServerMixin
extends MinecraftServerMixin
implements DedicatedServerBridge {
    @Shadow
    @Final
    public class_3350 field_13811;

    public DedicatedServerMixin(String name) {
        super(name);
    }

    @Inject(method={"initServer"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/dedicated/DedicatedServer;setPlayerList(Lnet/minecraft/server/players/PlayerList;)V")})
    public void arclight$loadPlugins(CallbackInfoReturnable<Boolean> cir) {
        this.bridge$forge$unlockRegistries();
        ((CraftServer)Bukkit.getServer()).loadPlugins();
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.STARTUP);
        this.bridge$forge$lockRegistries();
    }

    @Inject(method={"initServer"}, at={@At(value="FIELD", target="Lnet/minecraft/server/dedicated/DedicatedServerProperties;enableRcon:Z")})
    public void arclight$setRcon(CallbackInfoReturnable<Boolean> cir) {
        this.remoteConsole = new CraftRemoteConsoleCommandSender(this.field_13811);
    }

    @Redirect(method={"handleConsoleInputs"}, at=@At(value="INVOKE", target="Lnet/minecraft/commands/Commands;performPrefixedCommand(Lnet/minecraft/commands/CommandSourceStack;Ljava/lang/String;)V"))
    private void arclight$serverCommandEvent(class_2170 commands, class_2168 source, String command) {
        if (command.isEmpty()) {
            return;
        }
        ServerCommandEvent event = new ServerCommandEvent(this.console, command);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.server.dispatchServerCommand(this.console, new class_2976(event.getCommand(), source));
        }
    }

    @Overwrite
    public String method_12934(String command) {
        this.field_13811.method_14702();
        this.method_19537(() -> {
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(this.remoteConsole, command);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            this.server.dispatchServerCommand(this.remoteConsole, new class_2976(event.getCommand(), this.field_13811.method_14700()));
        });
        return this.field_13811.method_14701();
    }

    @Inject(method={"onServerExit"}, at={@At(value="RETURN")})
    public void arclight$exitNow(CallbackInfo ci) {
        this.bridge$platform$exitNow();
        Thread exitThread = new Thread(this::arclight$exit, "Exit Thread");
        exitThread.setDaemon(true);
        exitThread.start();
    }

    private void arclight$exit() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<String> threads = new ArrayList<String>();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.isDaemon() || thread.getName().equals("DestroyJavaVM")) continue;
            threads.add(thread.getName());
        }
        if (!threads.isEmpty()) {
            ArclightServer.LOGGER.debug("Threads {} not shutting down", (Object)String.join((CharSequence)", ", threads));
            ArclightServer.LOGGER.info("{} threads not shutting down correctly, force exiting", (Object)threads.size());
        }
        System.exit(0);
    }

    @Overwrite
    public String method_12916() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i = 0; i < plugins.length; ++i) {
                if (i > 0) {
                    result.append("; ");
                }
                result.append(plugins[i].getDescription().getName());
                result.append(" ");
                result.append(plugins[i].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }
}

