/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.level;

import io.izzel.arclight.common.bridge.core.world.server.TicketManagerBridge;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_4076;
import net.minecraft.class_4706;
import net.minecraft.class_6609;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3204.class})
public abstract class DistanceManagerMixin
implements TicketManagerBridge {
    @Shadow
    private long field_13894;
    @Shadow
    @Final
    private class_3204.class_4077 field_18252;
    @Shadow
    @Final
    public Long2ObjectOpenHashMap<class_4706<class_3228<?>>> field_13895;

    @Shadow
    protected abstract class_4706<class_3228<?>> method_14050(long var1);

    @Shadow
    private static int method_14046(class_4706<class_3228<?>> p_229844_0_) {
        return 0;
    }

    @Shadow
    abstract class_6609 method_38631();

    @Override
    @Invoker(value="purgeStaleTickets")
    public abstract void bridge$tick();

    @Inject(method={"removePlayer"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", remap=false, target="Lit/unimi/dsi/fastutil/objects/ObjectSet;remove(Ljava/lang/Object;)Z")})
    private void arclight$remove(class_4076 p_140829_, class_3222 p_140830_, CallbackInfo ci, class_1923 pos, long l, ObjectSet<?> set) {
        if (set == null) {
            ci.cancel();
        }
    }

    public <T> boolean addRegionTicketAtDistance(class_3230<T> type, class_1923 pos, int level, T value) {
        class_3228 ticket = new class_3228(type, 33 - level, value);
        boolean ret = this.addTicket(pos.method_8324(), ticket);
        this.method_38631().method_38637(pos.method_8324(), ticket);
        return ret;
    }

    public <T> boolean removeRegionTicketAtDistance(class_3230<T> type, class_1923 pos, int level, T value) {
        class_3228 ticket = new class_3228(type, 33 - level, value);
        boolean ret = this.removeTicket(pos.method_8324(), ticket);
        this.method_38631().method_38641(pos.method_8324(), ticket);
        return ret;
    }

    public <T> boolean addTicketAtLevel(class_3230<T> type, class_1923 pos, int level, T value) {
        class_3228 ticket = new class_3228(type, level, value);
        return this.addTicket(pos.method_8324(), ticket);
    }

    public <T> boolean removeTicketAtLevel(class_3230<T> type, class_1923 pos, int level, T value) {
        class_3228 ticket = new class_3228(type, level, value);
        return this.removeTicket(pos.method_8324(), ticket);
    }

    @Override
    public <T> boolean bridge$addTicketAtLevel(class_3230<T> type, class_1923 pos, int level, T value) {
        return this.addTicketAtLevel(type, pos, level, value);
    }

    @Override
    public <T> boolean bridge$removeTicketAtLevel(class_3230<T> type, class_1923 pos, int level, T value) {
        return this.removeTicketAtLevel(type, pos, level, value);
    }

    boolean removeTicket(long chunkPosIn, class_3228<?> ticketIn) {
        class_4706<class_3228<?>> ticketSet = this.method_14050(chunkPosIn);
        boolean removed = false;
        if (ticketSet.remove(ticketIn)) {
            removed = true;
        }
        if (ticketSet.isEmpty()) {
            this.field_13895.remove(chunkPosIn);
        }
        this.field_18252.method_14027(chunkPosIn, DistanceManagerMixin.method_14046(ticketSet), false);
        if (this.bridge$platform$isTicketForceTick(ticketIn)) {
            this.bridge$forge$removeForcedTicket(chunkPosIn, ticketIn);
        }
        return removed;
    }

    @Override
    public boolean bridge$removeTicket(long chunkPos, class_3228<?> ticket) {
        return this.removeTicket(chunkPos, ticket);
    }

    boolean addTicket(long chunkPosIn, class_3228<?> ticketIn) {
        class_4706<class_3228<?>> ticketSet = this.method_14050(chunkPosIn);
        int level = DistanceManagerMixin.method_14046(ticketSet);
        class_3228 ticket = (class_3228)ticketSet.method_23862(ticketIn);
        ticket.method_23956(this.field_13894);
        if (ticketIn.method_14283() < level) {
            this.field_18252.method_14027(chunkPosIn, ticketIn.method_14283(), true);
        }
        if (this.bridge$platform$isTicketForceTick(ticketIn)) {
            this.bridge$forge$addForcedTicket(chunkPosIn, ticketIn);
        }
        return ticketIn == ticket;
    }

    @Override
    public boolean bridge$addTicket(long chunkPos, class_3228<?> ticket) {
        return this.addTicket(chunkPos, ticket);
    }

    public <T> void removeAllTicketsFor(class_3230<T> ticketType, int ticketLevel, T ticketIdentifier) {
        class_3228 target = new class_3228(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.field_13895.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            class_4706 tickets = (class_4706)entry.getValue();
            if (!tickets.remove((Object)target)) continue;
            this.field_18252.method_14027(entry.getLongKey(), DistanceManagerMixin.method_14046(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public <T> void bridge$removeAllTicketsFor(class_3230<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }
}

