/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.server.management.PlayerInteractionManagerBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2272;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3244;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public abstract class ServerPlayerGameModeMixin
implements PlayerInteractionManagerBridge {
    @Shadow
    protected class_3218 field_14007;
    @Shadow
    @Final
    protected class_3222 field_14008;
    @Shadow
    private class_1934 field_14005;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public class_2338 interactPosition;
    public class_1268 interactHand;
    public class_1799 interactItemStack;

    @Shadow
    public abstract boolean method_14268();

    @Inject(method={"changeGameModeForPlayer"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;setGameModeForPlayer(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/level/GameType;)V")})
    private void arclight$gameModeEvent(class_1934 gameType, CallbackInfoReturnable<Boolean> cir) {
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)((ServerPlayerEntityBridge)this.field_14008).bridge$getBukkitEntity(), GameMode.getByValue(gameType.method_8379()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"handleBlockBreakAction"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;mayInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;)Z")))
    private void arclight$mayNotInteractEvent(class_3244 instance, class_2596<?> packet, class_2338 blockPos, class_2846.class_2847 action, class_2350 direction) throws Throwable {
        CraftEventFactory.callPlayerInteractEvent((class_1657)this.field_14008, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.field_14008.method_31548().method_7391(), class_1268.field_5808);
        DecorationOps.callsite().invoke(instance, packet);
        class_2586 blockEntity = this.field_14007.method_8321(blockPos);
        if (blockEntity != null) {
            this.field_14008.field_13987.method_14364(blockEntity.method_38235());
        }
    }

    @Decorate(method={"handleBlockBreakAction"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;isCreative()Z"))
    private void arclight$interactEvent(class_2338 blockPos, class_2846.class_2847 action, class_2350 direction, @Local(allocate="playerInteractEvent") PlayerInteractEvent event) throws Throwable {
        event = CraftEventFactory.callPlayerInteractEvent((class_1657)this.field_14008, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.field_14008.method_31548().method_7391(), class_1268.field_5808);
        if (event.isCancelled()) {
            this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockPos));
            class_2586 blockEntity = this.field_14007.method_8321(blockPos);
            if (blockEntity != null) {
                this.field_14008.field_13987.method_14364(blockEntity.method_38235());
            }
            DecorationOps.cancel().invoke();
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Decorate(method={"handleBlockBreakAction"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z"))
    private boolean arclight$playerInteractCancelled(class_2680 instance, class_2338 blockPos, class_2846.class_2847 action, class_2350 direction, @Local(allocate="playerInteractEvent") PlayerInteractEvent event) throws Throwable {
        boolean result = false;
        if (event.useInteractedBlock() == Event.Result.DENY) {
            class_2680 data = this.field_14007.method_8320(blockPos);
            if (data.method_26204() instanceof class_2323) {
                boolean bottom = data.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607;
                this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockPos));
                this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, bottom ? blockPos.method_10084() : blockPos.method_10074()));
            } else if (data.method_26204() instanceof class_2533) {
                this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockPos));
            }
            result = true;
        } else {
            result = DecorationOps.callsite().invoke(instance);
        }
        return result;
    }

    @Decorate(method={"handleBlockBreakAction"}, inject=true, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z"))
    private void arclight$blockDamageEvent(class_2338 blockPos, class_2846.class_2847 action, class_2350 direction, @Local(ordinal=-1) float f, @Local(allocate="playerInteractEvent") PlayerInteractEvent event) throws Throwable {
        if (event.useItemInHand() == Event.Result.DENY) {
            if (f > 1.0f) {
                this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockPos));
            }
            return;
        }
        BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.field_14008, blockPos, this.field_14008.method_31548().method_7391(), f >= 1.0f);
        if (blockEvent.isCancelled()) {
            this.field_14008.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockPos));
            return;
        }
        if (blockEvent.getInstaBreak()) {
            f = 2.0f;
        }
        DecorationOps.blackhole().invoke(f);
    }

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="CONSTANT", args={"stringValue=aborted destroying"})})
    private void arclight$abortBlockBreak(class_2338 blockPos, class_2846.class_2847 action, class_2350 direction, int i, int j, CallbackInfo ci) {
        CraftEventFactory.callBlockDamageAbortEvent(this.field_14008, blockPos, this.field_14008.method_31548().method_7391());
    }

    @Inject(method={"destroyBlock"}, at={@At(value="RETURN")})
    public void arclight$resetBlockBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        ArclightCaptures.BlockBreakEventContext breakEventContext = ArclightCaptures.popPrimaryBlockBreakEvent();
        if (breakEventContext != null) {
            this.bridge$handleBlockDrop(breakEventContext, pos);
        }
    }

    @Inject(method={"tick", "destroyAndAck"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;destroyBlock(Lnet/minecraft/core/BlockPos;)Z")})
    public void arclight$clearCaptures(CallbackInfo ci) {
        ArclightCaptures.clearBlockBreakEventContexts();
    }

    @Override
    public void bridge$handleBlockDrop(ArclightCaptures.BlockBreakEventContext breakEventContext, class_2338 pos) {
        BlockBreakEvent breakEvent = breakEventContext.getEvent();
        ArrayList<class_1542> blockDrops = breakEventContext.getBlockDrops();
        BlockState state = breakEventContext.getBlockBreakPlayerState();
        if (blockDrops != null && (breakEvent == null || breakEvent.isDropItems())) {
            CraftBlock craftBlock = CraftBlock.at((class_1936)this.field_14007, pos);
            CraftEventFactory.handleBlockDropItemEvent(craftBlock, state, this.field_14008, blockDrops);
        }
    }

    @Override
    public boolean bridge$isFiredInteract() {
        return this.firedInteract;
    }

    @Override
    public void bridge$setFiredInteract(boolean b) {
        this.firedInteract = b;
    }

    @Override
    public boolean bridge$getInteractResult() {
        return this.interactResult;
    }

    @Override
    public void bridge$setInteractResult(boolean b) {
        this.interactResult = b;
    }

    @Override
    public class_2338 bridge$getInteractPosition() {
        return this.interactPosition;
    }

    @Override
    public class_1268 bridge$getInteractHand() {
        return this.interactHand;
    }

    @Override
    public class_1799 bridge$getInteractItemStack() {
        return this.interactItemStack;
    }

    @Inject(method={"useItemOn"}, cancellable=true, at={@At(value="FIELD", opcode=180, ordinal=0, target="Lnet/minecraft/server/level/ServerPlayerGameMode;gameModeForPlayer:Lnet/minecraft/world/level/GameType;")})
    private void arclight$rightClickBlock(class_3222 playerIn, class_1937 worldIn, class_1799 stackIn, class_1268 handIn, class_3965 blockRaytraceResultIn, CallbackInfoReturnable<class_1269> cir) {
        class_2338 blockpos = blockRaytraceResultIn.method_17777();
        class_2680 blockstate = worldIn.method_8320(blockpos);
        boolean cancelledBlock = false;
        if (this.field_14005 == class_1934.field_9219) {
            class_3908 provider = blockstate.method_26196(worldIn, blockpos);
            boolean bl = cancelledBlock = !(provider instanceof class_3908);
        }
        if (playerIn.method_7357().method_7904(stackIn.method_7909())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent bukkitEvent = CraftEventFactory.callPlayerInteractEvent((class_1657)playerIn, Action.RIGHT_CLICK_BLOCK, blockpos, blockRaytraceResultIn.method_17780(), stackIn, cancelledBlock, handIn, blockRaytraceResultIn.method_17784());
        this.bridge$setFiredInteract(true);
        this.bridge$setInteractResult(bukkitEvent.useItemInHand() == Event.Result.DENY);
        this.interactPosition = blockpos.method_10062();
        this.interactHand = handIn;
        this.interactItemStack = stackIn.method_7972();
        if (bukkitEvent.useInteractedBlock() == Event.Result.DENY) {
            if (blockstate.method_26204() instanceof class_2323) {
                boolean bottom = blockstate.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607;
                playerIn.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, bottom ? blockpos.method_10084() : blockpos.method_10074()));
            } else if (blockstate.method_26204() instanceof class_2272) {
                ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().sendHealthUpdate();
            } else if (stackIn.method_7909() instanceof class_1765) {
                playerIn.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockpos.method_10093(blockRaytraceResultIn.method_17780()).method_10084()));
                playerIn.field_13987.method_14364((class_2596)new class_2626((class_1922)this.field_14007, blockpos.method_10084()));
            }
            ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().updateInventory();
            cir.setReturnValue((Object)(bukkitEvent.useItemInHand() != Event.Result.ALLOW ? class_1269.field_5812 : class_1269.field_5811));
        }
    }

    @Decorate(method={"useItemOn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemCooldowns;isOnCooldown(Lnet/minecraft/world/item/Item;)Z"))
    private boolean arclight$useInteractResult(class_1796 instance, class_1792 item) throws Throwable {
        boolean result = DecorationOps.callsite().invoke(instance, item);
        DecorationOps.blackhole().invoke(result);
        return this.interactResult;
    }
}

