/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.core.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.mixin.core.world.entity.EntityMixin;
import io.izzel.arclight.common.mod.util.EntityDamageResult;
import io.izzel.arclight.common.util.IteratorUtil;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import io.izzel.tools.collection.XmapList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8080;
import net.minecraft.class_8103;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge {
    @Shadow
    protected int field_6238;
    @Shadow
    public class_1657 field_6258;
    @Shadow
    public int field_6213;
    @Shadow
    protected boolean field_6272;
    @Shadow
    public boolean field_6285;
    @Shadow
    @Final
    public static class_2940<Float> field_6247;
    @Shadow
    protected int field_6278;
    @Shadow
    public float field_6253;
    @Shadow
    public int field_6254;
    @Shadow
    public int field_6235;
    @Shadow
    private class_1282 field_6276;
    @Shadow
    private long field_6226;
    @Shadow
    @Final
    private class_5131 field_6260;
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6232;
    @Shadow
    @Nullable
    public class_1309 field_6274;
    @Shadow
    public class_1283 field_6256;
    @Shadow
    @Final
    private static class_2940<Boolean> field_6214;
    @Shadow
    @Final
    public Map<class_1291, class_1293> field_6280;
    @Shadow
    @Final
    public static class_2940<Integer> field_6219;
    @Shadow
    @Final
    public class_8080 field_42108;
    @Shadow
    public int field_6269;
    public int expToDrop;
    public CraftAttributeMap craftAttributes;
    public boolean collides;
    public boolean bukkitPickUpLoot;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    private boolean isTickingEffects = false;
    private final List<Map.Entry<Either<class_1293, class_6880<class_1291>>, EntityPotionEffectEvent.Cause>> effectsToProcess = Lists.newArrayList();
    private transient EntityPotionEffectEvent.Cause arclight$cause;
    private transient class_1297 arclight$knockbackAttacker;
    private transient EntityKnockbackEvent.KnockbackCause arclight$knockbackCause;
    @Unique
    protected transient EntityDamageResult entityDamageResult;
    protected transient boolean arclight$damageResult;
    private transient EntityRegainHealthEvent.RegainReason arclight$regainReason;
    @Unique
    private List<class_1542> arclight$capturedDrops;

    @Shadow
    public abstract float method_6063();

    @Shadow
    public abstract void method_6025(float var1);

    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract void method_6033(float var1);

    @Shadow
    public abstract float method_5791();

    @Shadow
    protected abstract boolean method_6054();

    @Shadow
    protected abstract boolean method_6071();

    @Shadow
    public abstract boolean method_6012();

    @Shadow
    public abstract boolean method_6113();

    @Shadow
    public abstract void method_18400();

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract boolean method_6061(class_1282 var1);

    @Shadow
    protected abstract void method_6056(float var1);

    @Shadow
    protected abstract void method_6090(class_1309 var1);

    @Shadow
    public abstract void method_6015(@Nullable class_1309 var1);

    @Shadow
    @Nullable
    protected abstract class_3414 method_6002();

    @Shadow
    protected abstract float method_6107();

    @Shadow
    public abstract float method_6017();

    @Shadow
    public abstract void method_6078(class_1282 var1);

    @Shadow
    protected abstract void method_6013(class_1282 var1);

    @Shadow
    protected abstract float method_6132(class_1282 var1, float var2);

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    protected abstract float method_6036(class_1282 var1, float var2);

    @Shadow
    public abstract float method_6067();

    @Shadow
    public abstract void method_6073(float var1);

    @Shadow
    public abstract class_1283 method_6066();

    @Shadow
    public abstract boolean method_6101();

    @Shadow
    public abstract void method_6103(class_1297 var1, int var2);

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract void method_5728(boolean var1);

    @Shadow
    public abstract void method_6114(class_1297 var1);

    @Shadow
    public abstract void method_6122(class_1268 var1, class_1799 var2);

    @Shadow
    @Nullable
    public abstract class_1309 method_6124();

    @Shadow
    public abstract Collection<class_1293> method_6026();

    @Shadow
    public abstract void method_6097(int var1);

    @Shadow
    public abstract class_1799 method_6079();

    @Shadow
    public abstract Optional<class_2338> method_18398();

    @Shadow
    protected abstract void method_6129(class_1293 var1);

    @Shadow
    protected abstract void method_6027();

    @Shadow
    public abstract boolean method_6049(class_1293 var1);

    @Shadow
    protected abstract void method_23733(@Nullable class_1309 var1);

    @Shadow
    protected abstract void method_6105(class_1282 var1, float var2);

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract int method_6022();

    @Shadow
    public abstract void method_5673(class_1304 var1, class_1799 var2);

    @Shadow
    protected abstract void method_6009(class_1293 var1, boolean var2, @org.jetbrains.annotations.Nullable class_1297 var3);

    @Shadow
    protected abstract void method_6020(class_1293 var1, @org.jetbrains.annotations.Nullable class_1297 var2);

    @Shadow
    public abstract void method_6005(double var1, double var3, double var5);

    @Shadow
    public abstract boolean method_18395(class_1309 var1);

    @Shadow
    public abstract boolean method_6057(class_1297 var1);

    @Shadow
    protected abstract void method_36977(class_1282 var1, float var2);

    @Shadow
    public abstract void method_6021();

    @Shadow
    protected abstract boolean method_44201(class_1304 var1);

    @Shadow
    protected abstract void method_37410(class_1799 var1);

    @Shadow
    public abstract boolean method_41330();

    @Shadow
    @Nullable
    protected abstract class_3414 method_6011(class_1282 var1);

    @Shadow
    protected abstract class_3414 method_6041(int var1);

    @Shadow
    protected abstract class_3414 method_18807(class_1799 var1);

    @Shadow
    public abstract class_3414 method_18869(class_1799 var1);

    @Shadow
    public abstract class_1268 method_6058();

    @Shadow
    public abstract void method_48761(double var1, double var3);

    @Shadow
    protected void method_6074(class_1282 p_21240_, float p_21241_) {
    }

    @Shadow
    public abstract void method_41329();

    @Shadow
    public abstract class_5131 method_6127();

    @Shadow
    protected abstract void method_36362();

    @Shadow
    public abstract int method_59923(class_3218 var1, @org.jetbrains.annotations.Nullable class_1297 var2);

    @Shadow
    protected abstract void method_60699(class_1297.class_5529 var1);

    @Shadow
    @org.jetbrains.annotations.Nullable
    public abstract class_1324 method_5996(class_6880<class_1320> var1);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    @org.jetbrains.annotations.Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Shadow
    public abstract boolean method_6016(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_37222(class_1293 var1, @org.jetbrains.annotations.Nullable class_1297 var2);

    @Shadow
    @org.jetbrains.annotations.Nullable
    public abstract class_1293 method_6111(class_6880<class_1291> var1);

    @Shadow
    public abstract int method_6096();

    @Shadow
    public abstract class_1304 method_32326(class_1799 var1);

    @Shadow
    protected abstract void method_16080(class_3218 var1, class_1282 var2);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setHealth(F)V"))
    private void arclight$muteHealth(class_1309 entity, float health) {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(class_1299<? extends class_1309> type, class_1937 worldIn, CallbackInfo ci) {
        this.collides = true;
        this.craftAttributes = new CraftAttributeMap(this.field_6260);
        this.field_6011.method_12778(field_6247, (Object)Float.valueOf((float)this.method_45325((class_6880<class_1320>)class_5134.field_23716)));
    }

    public class_3414 getHurtSound0(class_1282 damagesource) {
        return this.method_6011(damagesource);
    }

    public class_3414 getDeathSound0() {
        return this.method_6002();
    }

    public class_3414 getFallDamageSound0(int fallHeight) {
        return this.method_6041(fallHeight);
    }

    public class_3414 getDrinkingSound0(class_1799 itemstack) {
        return this.method_18807(itemstack);
    }

    public class_3414 getEatingSound0(class_1799 itemstack) {
        return this.method_18869(itemstack);
    }

    @Overwrite
    protected void method_23883(class_1297 entity) {
        if (!(this instanceof class_1510)) {
            int reward = this.bridge$forge$getExperienceDrop((class_1309)this, this.field_6258, this.expToDrop);
            class_1303.method_31493((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (int)reward);
            this.bridge$setExpToDrop(0);
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void arclight$startTicking(CallbackInfo ci) {
        this.isTickingEffects = true;
    }

    @Decorate(method={"tickEffects"}, inject=true, at=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V"))
    private void arclight$effectExpire(@Local(ordinal=-1) class_1293 mobeffect) throws Throwable {
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((class_1309)this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
        if (event.isCancelled()) {
            throw DecorationOps.jumpToLoopStart();
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/world/entity/LivingEntity;effectsDirty:Z")})
    private void arclight$pendingEffects(CallbackInfo ci) {
        this.isTickingEffects = false;
        for (Map.Entry<Either<class_1293, class_6880<class_1291>>, EntityPotionEffectEvent.Cause> e : this.effectsToProcess) {
            Either<class_1293, class_6880<class_1291>> either = e.getKey();
            EntityPotionEffectEvent.Cause cause = e.getValue();
            if (either.left().isPresent()) {
                this.addEffect((class_1293)either.left().get(), cause);
                continue;
            }
            this.removeEffect((class_6880<class_1291>)((class_6880)either.right().get()), cause);
        }
        this.effectsToProcess.clear();
    }

    public boolean addEffect(class_1293 effect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effect, null, cause);
    }

    public boolean addEffect(class_1293 effect, class_1297 entity, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.method_37222(effect, entity);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.method_6012();
    }

    @Override
    public boolean bridge$removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        return this.removeAllEffects(cause);
    }

    @Decorate(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, inject=true, at=@At(value="JUMP", opcode=154, ordinal=0))
    private void arclight$addPendingEffects(class_1293 mobEffectInstance, class_1297 entity, @Local(allocate="cause") EntityPotionEffectEvent.Cause cause) throws Throwable {
        cause = this.bridge$getEffectCause().orElse(EntityPotionEffectEvent.Cause.UNKNOWN);
        if (this.isTickingEffects) {
            this.effectsToProcess.add(Maps.immutableEntry((Object)Either.left((Object)mobEffectInstance), (Object)((Object)cause)));
            DecorationOps.cancel().invoke(true);
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Decorate(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, inject=true, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private void arclight$effectAdd(class_1293 mobEffectInstance, class_1297 entity, @Local(allocate="cause") EntityPotionEffectEvent.Cause cause) throws Throwable {
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((class_1309)this, null, mobEffectInstance, cause, false);
        if (event.isCancelled()) {
            DecorationOps.cancel().invoke(false);
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Decorate(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;update(Lnet/minecraft/world/effect/MobEffectInstance;)Z"))
    private boolean arclight$effectReplace(class_1293 oldEffect, class_1293 newEffect, class_1293 mobEffectInstance, class_1297 entity, @Local(allocate="cause") EntityPotionEffectEvent.Cause cause) throws Throwable {
        boolean override = new class_1293(oldEffect).method_5590(newEffect);
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((class_1309)this, oldEffect, newEffect, cause, override);
        if (event.isCancelled()) {
            return DecorationOps.cancel().invoke(false);
        }
        if (event.isOverride()) {
            boolean b = DecorationOps.callsite().invoke(oldEffect, newEffect);
            DecorationOps.blackhole().invoke(b);
        }
        return event.isOverride();
    }

    public boolean removeEffect(class_6880<class_1291> effect, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.method_6016(effect);
    }

    @Override
    public boolean bridge$removeEffect(class_6880<class_1291> effect, EntityPotionEffectEvent.Cause cause) {
        return this.removeEffect(effect, cause);
    }

    public class_1293 removeEffectNoUpdate(@Nullable class_6880<class_1291> holder, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.method_6111(holder);
    }

    @Inject(method={"removeEffectNoUpdate"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$clearActive(class_6880<class_1291> holder, CallbackInfoReturnable<class_1293> cir) {
        EntityPotionEffectEvent.Cause cause = this.bridge$getEffectCause().orElse(EntityPotionEffectEvent.Cause.UNKNOWN);
        if (this.isTickingEffects) {
            this.effectsToProcess.add(Maps.immutableEntry((Object)Either.right(holder), (Object)((Object)cause)));
            cir.setReturnValue(null);
            return;
        }
        class_1293 effectInstance = this.field_6280.get(holder);
        if (effectInstance == null) {
            cir.setReturnValue(null);
            return;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((class_1309)this, effectInstance, null, cause);
        if (event.isCancelled()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"triggerOnDeathMobEffects"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/Map;clear()V")})
    private void arclight$fireRemoveEvents(class_1297.class_5529 removalReason, CallbackInfo ci) {
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
    }

    @Override
    public boolean bridge$canPickUpLoot() {
        return this.bukkitPickUpLoot;
    }

    @Override
    public float getBukkitYaw() {
        return this.method_5791();
    }

    public int getExpReward(class_1297 entity) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!this.method_41330() && (this.method_6071() || this.field_6238 > 0 && this.method_6054() && this.method_37908().method_8450().method_8355(class_1928.field_19391))) {
                int exp = this.method_59923(serverLevel, entity);
                return this.bridge$forge$getExperienceDrop((class_1309)this, this.field_6258, exp);
            }
        }
        return 0;
    }

    @Override
    public int bridge$getExpReward(class_1297 entity) {
        return this.getExpReward(entity);
    }

    @Override
    public void bridge$setExpToDrop(int amount) {
        this.expToDrop = amount;
    }

    @Override
    public int bridge$getExpToDrop() {
        return this.expToDrop;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void arclight$readMaxHealth(class_2487 compound, CallbackInfo ci) {
        if (compound.method_10545("Bukkit.MaxHealth")) {
            class_2520 nbtbase = compound.method_10580("Bukkit.MaxHealth");
            if (nbtbase.method_10711() == 5) {
                this.method_5996((class_6880<class_1320>)class_5134.field_23716).method_6192(((class_2494)nbtbase).method_10697());
            } else if (nbtbase.method_10711() == 3) {
                this.method_5996((class_6880<class_1320>)class_5134.field_23716).method_6192(((class_2497)nbtbase).method_10697());
            }
        }
    }

    @Decorate(method={"removeAllEffects"}, at=@At(value="INVOKE", target="Ljava/util/Collection;iterator()Ljava/util/Iterator;"))
    private Iterator<class_1293> arclight$clearReason(Collection<class_1293> instance) throws Throwable {
        EntityPotionEffectEvent.Cause cause = this.bridge$getEffectCause().orElse(EntityPotionEffectEvent.Cause.UNKNOWN);
        return IteratorUtil.filter(DecorationOps.callsite().invoke(instance), effect -> {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((class_1309)this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            return !event.isCancelled();
        });
    }

    @Override
    @Overwrite
    public boolean method_5805() {
        return !this.method_31481() && ((Float)this.field_6011.method_12789(field_6247)).floatValue() > 0.0f;
    }

    @Inject(method={"getHealth"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$scaledHealth(CallbackInfoReturnable<Float> cir) {
        if (this instanceof ServerPlayerEntityBridge && ((ServerPlayerEntityBridge)((Object)this)).bridge$initialized()) {
            cir.setReturnValue((Object)Float.valueOf((float)((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().getHealth()));
        }
    }

    @Inject(method={"setHealth"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setScaled(float health, CallbackInfo ci) {
        if (this instanceof ServerPlayerEntityBridge && ((ServerPlayerEntityBridge)((Object)this)).bridge$initialized()) {
            CraftPlayer player = ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity();
            double realHealth = class_3532.method_15350((double)health, (double)0.0, (double)player.getMaxHealth());
            player.setRealHealth(realHealth);
            player.updateScaledHealth(false);
            player.setRealHealth(realHealth);
            ci.cancel();
        }
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")})
    private void arclight$shieldKnockback(class_1309 livingEntity, CallbackInfo ci) {
        this.bridge$pushKnockbackCause(null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    @Override
    public void bridge$pushKnockbackCause(class_1297 attacker, EntityKnockbackEvent.KnockbackCause cause) {
        this.arclight$knockbackAttacker = attacker;
        this.arclight$knockbackCause = cause;
    }

    public void knockback(double d, double e, double f, class_1297 attacker, EntityKnockbackEvent.KnockbackCause cause) {
        this.bridge$pushKnockbackCause(attacker, cause);
        this.method_6005(d, e, f);
    }

    @Decorate(method={"knockback"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(DDD)V"))
    private void arclight$knockbackEvent(class_1309 instance, double x, double y, double z, double d, double e, double f) throws Throwable {
        class_1297 attacker = this.arclight$knockbackAttacker;
        EntityKnockbackEvent.KnockbackCause cause = this.arclight$knockbackCause == null ? EntityKnockbackEvent.KnockbackCause.UNKNOWN : this.arclight$knockbackCause;
        this.arclight$knockbackAttacker = null;
        this.arclight$knockbackCause = null;
        class_243 raw = new class_243(e, 0.0, f).method_1029().method_1021(d);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent(this.getBukkitEntity(), attacker, cause, d, raw, x, y, z);
        if (!event.isCancelled()) {
            DecorationOps.callsite().invoke(instance, event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
        }
    }

    @Decorate(method={"hurt"}, inject=true, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;noActionTime:I"))
    private void arclight$entityDamageEvent(class_1282 damagesource, float originalDamage) throws Throwable {
        this.arclight$damageResult = false;
        this.entityDamageResult = null;
        boolean human = this instanceof class_1657;
        float damage = originalDamage;
        Function blocking = f -> -(this.method_6061(damagesource) ? f : 0.0);
        float blockingModifier = ((Double)blocking.apply((Object)damage)).floatValue();
        Function freezing = f -> {
            if (damagesource.method_48789(class_8103.field_42252) && this.method_5864().method_20210(class_3483.field_29826)) {
                return -(f - f * 5.0);
            }
            return -0.0;
        };
        float freezingModifier = ((Double)freezing.apply((Object)(damage += blockingModifier))).floatValue();
        Function hardHat = f -> {
            if (damagesource.method_48789(class_8103.field_42240) && !this.method_6118(class_1304.field_6169).method_7960()) {
                return -(f - f * 0.75);
            }
            return -0.0;
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(damage += freezingModifier))).floatValue();
        damage += hardHatModifier;
        if ((float)this.field_6008 > (float)this.field_6269 / 2.0f && !damagesource.method_48789(class_8103.field_42969) && damage <= this.field_6253) {
            if (damagesource.method_5529() instanceof class_1657) {
                ((class_1657)damagesource.method_5529()).method_7350();
            }
            return;
        }
        Function armor = f -> {
            if (!damagesource.method_48789(class_8103.field_42241)) {
                return -(f - (double)class_1280.method_5496((class_1309)((class_1309)this), (float)f.floatValue(), (class_1282)damagesource, (float)this.method_6096(), (float)((float)this.method_45325((class_6880<class_1320>)class_5134.field_23725))));
            }
            return -0.0;
        };
        float originalArmorDamage = damage;
        float armorModifier = ((Double)armor.apply((Object)damage)).floatValue();
        Function resistance = f -> {
            if (!damagesource.method_48789(class_8103.field_42243) && this.method_6059((class_6880<class_1291>)class_1294.field_5907) && !damagesource.method_48789(class_8103.field_42244)) {
                int i = (this.method_6112((class_6880<class_1291>)class_1294.field_5907).method_5578() + 1) * 5;
                int j = 25 - i;
                float f1 = f.floatValue() * (float)j;
                return -(f - (double)(f1 / 25.0f));
            }
            return -0.0;
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(damage += armorModifier))).floatValue();
        Function magic = f -> {
            float l;
            class_1937 patt0$temp = this.method_37908();
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                l = class_1890.method_8219((class_3218)serverLevel, (class_1309)((class_1309)this), (class_1282)damagesource);
            } else {
                l = 0.0f;
            }
            if (l > 0.0f) {
                return -(f - (double)class_1280.method_5497((float)f.floatValue(), (float)l));
            }
            return -0.0;
        };
        float magicModifier = ((Double)magic.apply((Object)(damage += resistanceModifier))).floatValue();
        Function absorption = f -> -Math.max(f - Math.max(f - (double)this.method_6067(), 0.0), 0.0);
        float absorptionModifier = ((Double)absorption.apply((Object)(damage += magicModifier))).floatValue();
        EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent((class_1297)((class_1309)this), damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, (Function<Double, Double>)freezing, (Function<Double, Double>)hardHat, (Function<Double, Double>)blocking, (Function<Double, Double>)armor, (Function<Double, Double>)resistance, (Function<Double, Double>)magic, (Function<Double, Double>)absorption);
        if (damagesource.method_5529() instanceof class_1657) {
            ((class_1657)damagesource.method_5529()).method_7350();
        }
        if (event.isCancelled()) {
            DecorationOps.cancel().invoke(false);
            return;
        }
        damage = (float)event.getFinalDamage();
        float damageOffset = damage - originalDamage;
        float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
        this.entityDamageResult = new EntityDamageResult((double)Math.abs(damageOffset) > 1.0E-6, originalDamage, damage, damageOffset, originalArmorDamage, armorDamage - originalArmorDamage, hardHatModifier > 0.0f && damage <= 0.0f, armorModifier > 0.0f && event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT) <= 0.0, blockingModifier < 0.0f && event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) >= 0.0);
        if (damage > 0.0f || !human) {
            this.arclight$damageResult = true;
        } else if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
            this.arclight$damageResult = true;
        } else {
            boolean bl = this.arclight$damageResult = originalDamage > 0.0f;
        }
        if (damage == 0.0f) {
            originalDamage = 0.0f;
            DecorationOps.blackhole().invoke(originalDamage);
        }
    }

    @Decorate(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"))
    private boolean arclight$cancelShieldBlock(class_1309 instance, class_1282 damageSource, @Local(ordinal=-1) boolean blocked) throws Throwable {
        return (this.entityDamageResult == null || !this.entityDamageResult.blockingCancelled()) && DecorationOps.callsite().invoke(instance, damageSource);
    }

    @Decorate(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtHelmet(Lnet/minecraft/world/damagesource/DamageSource;F)V"))
    private void arclight$cancelHurtHelmet(class_1309 instance, class_1282 damageSource, float f) throws Throwable {
        if (this.entityDamageResult == null || !this.entityDamageResult.helmetHurtCancelled()) {
            float result = f + this.entityDamageResult.armorDamageOffset();
            if (this.entityDamageResult.armorDamageOffset() < 0.0f && result < 0.0f) {
                result = f + f * (this.entityDamageResult.armorDamageOffset() / this.entityDamageResult.originalArmorDamage());
            }
            if (result > 0.0f) {
                DecorationOps.callsite().invoke(instance, damageSource, result);
            }
        }
    }

    @Decorate(method={"hurt"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;invulnerableTime:I"), slice=@Slice(to=@At(value="FIELD", target="Lnet/minecraft/tags/DamageTypeTags;BYPASSES_COOLDOWN:Lnet/minecraft/tags/TagKey;")))
    private int arclight$useInvulnerableDuration(class_1309 instance) throws Throwable {
        int result = DecorationOps.callsite().invoke(instance);
        return result + 10 - (int)((float)this.field_6269 / 2.0f);
    }

    @Decorate(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"))
    private void arclight$returnIfBlocked(class_1309 instance, class_1282 damageSource, float f) throws Throwable {
        DecorationOps.callsite().invoke(instance, damageSource, f);
        if (!this.arclight$damageResult) {
            DecorationOps.cancel().invoke(false);
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void arclight$knockbackCause(class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        this.bridge$pushKnockbackCause(damageSource.method_5529(), damageSource.method_5529() == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
    }

    @Decorate(method={"actuallyHurt"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getCombatTracker()Lnet/minecraft/world/damagesource/CombatTracker;"))
    private void arclight$setDamageResult(class_1282 damageSource, float f) throws Throwable {
        this.arclight$damageResult = true;
        if (this.entityDamageResult != null && this.entityDamageResult.damageOverride()) {
            float newDamage;
            if (ArclightConfig.spec().getCompat().isExactPluginEntityDamageControl()) {
                newDamage = this.entityDamageResult.finalDamage();
            } else {
                newDamage = f + this.entityDamageResult.damageOffset();
                if (newDamage < 0.0f && this.entityDamageResult.damageOffset() < 0.0f) {
                    newDamage = f + f * (this.entityDamageResult.damageOffset() / this.entityDamageResult.originalDamage());
                }
            }
            f = newDamage;
            DecorationOps.blackhole().invoke(f);
        }
    }

    @Decorate(method={"getDamageAfterArmorAbsorb"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V"))
    private void arclight$muteDamageArmor(class_1309 entity, class_1282 damageSource, float damage) throws Throwable {
        if (this.entityDamageResult == null || !this.entityDamageResult.armorHurtCancelled()) {
            DecorationOps.callsite().invoke(entity, damageSource, damage);
        }
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.bridge$pushHealReason(regainReason);
        this.method_6025(healAmount);
    }

    @Redirect(method={"heal"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setHealth(F)V"))
    public void arclight$healEvent(class_1309 livingEntity, float health) {
        EntityRegainHealthEvent.RegainReason regainReason = this.arclight$regainReason == null ? EntityRegainHealthEvent.RegainReason.CUSTOM : this.arclight$regainReason;
        this.arclight$regainReason = null;
        float f = this.method_6032();
        float amount = health - f;
        EntityRegainHealthEvent event = new EntityRegainHealthEvent(this.getBukkitEntity(), amount, regainReason);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent(event);
        }
        if (!event.isCancelled()) {
            this.method_6033(this.method_6032() + (float)event.getAmount());
        }
    }

    @Inject(method={"heal"}, at={@At(value="RETURN")})
    public void arclight$resetReason(float healAmount, CallbackInfo ci) {
        this.arclight$regainReason = null;
    }

    @Override
    public CraftLivingEntity getBukkitEntity() {
        return (CraftLivingEntity)this.internal$getBukkitEntity();
    }

    @Override
    public CraftLivingEntity bridge$getBukkitEntity() {
        return (CraftLivingEntity)this.internal$getBukkitEntity();
    }

    @Overwrite
    private boolean method_6095(class_1282 damageSourceIn) {
        if (damageSourceIn.method_48789(class_8103.field_42242)) {
            return false;
        }
        class_1799 itemstack = null;
        class_1799 itemstack1 = class_1799.field_8037;
        EquipmentSlot bukkitHand = null;
        for (class_1268 hand : class_1268.values()) {
            itemstack1 = this.method_5998(hand);
            if (!itemstack1.method_31574(class_1802.field_8288) || !this.bridge$forge$onLivingUseTotem((class_1309)this, damageSourceIn, itemstack1, hand)) continue;
            itemstack = itemstack1.method_7972();
            bukkitHand = CraftEquipmentSlot.getHand(hand);
            break;
        }
        EntityResurrectEvent event = new EntityResurrectEvent(this.getBukkitEntity(), bukkitHand);
        event.setCancelled(itemstack == null);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            LivingEntityMixin livingEntityMixin;
            if (!itemstack1.method_7960()) {
                itemstack1.method_7934(1);
            }
            if (itemstack != null && (livingEntityMixin = this) instanceof class_3222) {
                class_3222 serverplayerentity = (class_3222)livingEntityMixin;
                serverplayerentity.method_7259(class_3468.field_15372.method_14956((Object)class_1802.field_8288));
                class_174.field_1204.method_9165(serverplayerentity, itemstack);
                this.method_32876((class_6880<class_5712>)class_5712.field_28146);
            }
            this.method_6033(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new class_1293(class_1294.field_5924, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new class_1293(class_1294.field_5898, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new class_1293(class_1294.field_5918, 800, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.method_37908().method_8421((class_1297)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Inject(method={"createWitherRose"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    private void arclight$witherRoseDrop(class_1309 livingEntity, CallbackInfo ci, boolean flag, class_1542 itemEntity) {
        EntityDropItemEvent event = new EntityDropItemEvent(this.getBukkitEntity(), (Item)((Object)itemEntity.bridge$getBukkitEntity()));
        CraftEventFactory.callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Redirect(method={"createWitherRose"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"))
    private boolean arclight$fireWitherRoseForm(class_1937 instance, class_2338 pPos, class_2680 pNewState, int pFlags) {
        return CraftEventFactory.handleBlockFormEvent(instance, pPos, pNewState, pFlags, (class_1297)this);
    }

    @Decorate(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setSharedFlag(IZ)V"))
    private void arclight$stopGlide(class_1309 livingEntity, int flag, boolean set) throws Throwable {
        if (set != livingEntity.method_5795(flag) && !CraftEventFactory.callToggleGlideEvent(livingEntity, set).isCancelled()) {
            DecorationOps.callsite().invoke(livingEntity, flag, set);
        }
    }

    @Decorate(method={"updateFallFlying"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setSharedFlag(IZ)V"))
    private void arclight$toggleGlide(class_1309 livingEntity, int flag, boolean set) throws Throwable {
        if (set != livingEntity.method_5795(flag) && !CraftEventFactory.callToggleGlideEvent(livingEntity, set).isCancelled()) {
            DecorationOps.callsite().invoke(livingEntity, flag, set);
        }
    }

    @Overwrite
    public boolean method_5863() {
        return !this.method_31481() && this.collides;
    }

    @Override
    @Overwrite
    public boolean method_5810() {
        return this.method_5805() && !this.method_6101() && this.collides;
    }

    @Override
    public boolean canCollideWith(class_1297 entity) {
        return this.method_5810() && this.collides != this.collidableExemptions.contains(entity.method_5667());
    }

    @Decorate(method={"completeUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"))
    private class_1799 arclight$itemConsume(class_1799 itemStack, class_1937 worldIn, class_1309 entityLiving) throws Throwable {
        if (this instanceof ServerPlayerEntityBridge) {
            ItemStack craftItem = CraftItemStack.asBukkitCopy(itemStack);
            PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)((Object)this.getBukkitEntity()), craftItem, CraftEquipmentSlot.getHand(this.method_6058()));
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().updateInventory();
                ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().updateScaledHealth();
                return DecorationOps.cancel().invoke();
            }
            if (!craftItem.equals(event.getItem())) {
                itemStack = CraftItemStack.asNMSCopy(event.getItem());
            }
        }
        return DecorationOps.callsite().invoke(itemStack, worldIn, entityLiving);
    }

    @Decorate(method={"randomTeleport"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/LivingEntity;teleportTo(DDD)V"))
    private void arclight$entityTeleport(class_1309 entity, double x, double y, double z) throws Throwable {
        if (this instanceof class_3222) {
            ((class_3222)this).field_13987.method_14360(x, y, z, this.method_36454(), this.method_36455(), Collections.emptySet());
            if (!((ServerPlayNetHandlerBridge)((class_3222)this).field_13987).bridge$teleportCancelled()) {
                DecorationOps.cancel().invoke(false);
                return;
            }
        } else {
            EntityTeleportEvent event = new EntityTeleportEvent(this.getBukkitEntity(), new Location(this.method_37908().bridge$getWorld(), this.method_23317(), this.method_23318(), this.method_23321()), new Location(this.method_37908().bridge$getWorld(), x, y, z));
            Bukkit.getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                x = event.getTo().getX();
                y = event.getTo().getY();
                z = event.getTo().getZ();
            } else {
                x = this.method_23317();
                y = this.method_23318();
                z = this.method_23321();
            }
            if (event.isCancelled()) {
                DecorationOps.cancel().invoke(false);
                return;
            }
            DecorationOps.callsite().invoke(entity, x, y, z);
        }
        DecorationOps.blackhole().invoke();
    }

    @Override
    public void bridge$common$startCaptureDrops() {
        this.arclight$capturedDrops = new ArrayList<class_1542>();
    }

    @Override
    public boolean bridge$common$isCapturingDrops() {
        return this.arclight$capturedDrops != null;
    }

    @Override
    public Collection<class_1542> bridge$common$getCapturedDrops() {
        try {
            List<class_1542> list = this.arclight$capturedDrops;
            return list;
        }
        finally {
            this.arclight$capturedDrops = null;
        }
    }

    @Override
    public void bridge$common$captureDrop(class_1542 itemEntity) {
        if (this.arclight$capturedDrops != null) {
            this.arclight$capturedDrops.add(itemEntity);
        }
    }

    @Override
    public void bridge$common$finishCaptureAndFireEvent(class_1282 damageSource) {
        List<class_1542> drops = this.arclight$capturedDrops;
        if (!(drops instanceof ArrayList)) {
            drops = new ArrayList<class_1542>(drops);
        }
        XmapList<class_1542, ItemStack> itemStackList = XmapList.create(drops, ItemStack.class, entity -> CraftItemStack.asCraftMirror(entity.method_6983()), itemStack -> {
            class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), CraftItemStack.asNMSCopy(itemStack));
            itemEntity.method_6988();
            return itemEntity;
        });
        CraftEventFactory.callEntityDeathEvent((class_1309)this, damageSource, itemStackList);
        this.arclight$capturedDrops = null;
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")})
    private void arclight$startCapture(class_3218 serverLevel, class_1282 damageSource, CallbackInfo ci) {
        this.bridge$common$startCaptureDrops();
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropExperience(Lnet/minecraft/world/entity/Entity;)V")})
    private void arclight$stopCapture(class_3218 serverLevel, class_1282 damageSource, CallbackInfo ci) {
        this.bridge$common$finishCaptureAndFireEvent(damageSource);
    }

    @Inject(method={"addEatEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z")})
    public void arclight$foodEffectCause(class_4174 foodProperties, CallbackInfo ci) {
        this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.FOOD);
    }

    @Override
    public void bridge$heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(healAmount, regainReason);
    }

    @Override
    public void bridge$pushHealReason(EntityRegainHealthEvent.RegainReason regainReason) {
        this.arclight$regainReason = regainReason;
    }

    @Override
    public void bridge$pushEffectCause(EntityPotionEffectEvent.Cause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public boolean bridge$addEffect(class_1293 effect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effect, cause);
    }

    @Override
    public Optional<EntityPotionEffectEvent.Cause> bridge$getEffectCause() {
        try {
            Optional<EntityPotionEffectEvent.Cause> optional = Optional.ofNullable(this.arclight$cause);
            return optional;
        }
        finally {
            this.arclight$cause = null;
        }
    }

    @Inject(method={"setArrowCount"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$onArrowChange(int count, CallbackInfo ci) {
        if (this.arclight$callArrowCountChange(count, false)) {
            ci.cancel();
        }
    }

    public final void setArrowCount(int count, boolean reset) {
        if (this.arclight$callArrowCountChange(count, reset)) {
            return;
        }
        this.field_6011.method_12778(field_6219, (Object)count);
    }

    private boolean arclight$callArrowCountChange(int newCount, boolean reset) {
        return CraftEventFactory.callArrowBodyCountChangeEvent((class_1309)this, this.method_6022(), newCount, reset).isCancelled();
    }

    public void onEquipItem(class_1304 slotIn, class_1799 stack, boolean silent) {
        this.method_5673(slotIn, stack);
    }

    @Override
    public void bridge$setSlot(class_1304 slotIn, class_1799 stack, boolean silent) {
        this.onEquipItem(slotIn, stack, silent);
    }

    protected void equipEventAndSound(class_1304 slot, class_1799 oldItem, class_1799 newItem, boolean silent) {
        boolean flag;
        boolean bl = flag = newItem.method_7960() && oldItem.method_7960();
        if (!(flag || class_1799.method_31577((class_1799)oldItem, (class_1799)newItem) || this.field_5953)) {
            class_5151 equipable = class_5151.method_48957((class_1799)newItem);
            if (!this.method_37908().method_8608() && !this.method_7325()) {
                if (!this.method_5701() && equipable != null && equipable.method_7685() == slot && !silent) {
                    this.method_37908().method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), equipable.method_31570(), this.method_5634(), 1.0f, 1.0f, this.field_5974.method_43055());
                }
                if (this.method_44201(slot)) {
                    this.method_32876((class_6880<class_5712>)(equipable != null ? class_5712.field_28739 : class_5712.field_45787));
                }
            }
        }
    }

    @Override
    public void bridge$playEquipSound(class_1304 slot, class_1799 oldItem, class_1799 newItem, boolean silent) {
        this.equipEventAndSound(slot, oldItem, newItem, silent);
    }

    @Inject(method={"tickDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V")})
    private void arclight$killedCause(CallbackInfo ci) {
        this.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.DEATH);
    }
}

