/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.animal.horse;

import io.izzel.arclight.common.bridge.core.inventory.IInventoryBridge;
import io.izzel.arclight.common.mixin.core.world.entity.animal.AnimalMixin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_8181;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1496.class})
public abstract class AbstractHorseMixin
extends AnimalMixin {
    public int maxDomestication;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(class_1299<? extends class_1496> type, class_1937 worldIn, CallbackInfo ci) {
        this.maxDomestication = 100;
    }

    @Redirect(method={"createInventory"}, at=@At(value="NEW", target="(I)Lnet/minecraft/world/SimpleContainer;"))
    private class_1277 arclight$createInv(int slots) {
        class_1277 inventory = new class_1277(slots);
        ((IInventoryBridge)inventory).setOwner((InventoryHolder)((Object)this.getBukkitEntity()));
        return inventory;
    }

    @Inject(method={"handleEating"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/horse/AbstractHorse;heal(F)V")})
    private void arclight$healByEating(class_1657 player, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.EATING);
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/horse/AbstractHorse;heal(F)V")})
    private void arclight$healByRegen(CallbackInfo ci) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.REGEN);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void arclight$writeTemper(class_2487 compound, CallbackInfo ci) {
        compound.method_10569("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void arclight$readTemper(class_2487 compound, CallbackInfo ci) {
        if (compound.method_10545("Bukkit.MaxDomestication")) {
            this.maxDomestication = compound.method_10550("Bukkit.MaxDomestication");
        }
    }

    @Inject(method={"handleStartJump"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$horseJump(int i, CallbackInfo ci) {
        float power = i >= 90 ? 1.0f : 0.4f + 0.4f * (float)i / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent((class_1297)((class_1496)this), power)) {
            ci.cancel();
        }
    }

    @Overwrite
    public int method_6755() {
        return this.maxDomestication;
    }

    @Mixin(targets={"net/minecraft/world/entity/animal/horse/AbstractHorse$1"})
    public static abstract class ContainerMixin
    implements IInventoryBridge,
    class_8181 {
        @Shadow(aliases={"field_48831", "this$0"})
        private class_1496 outerThis;
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 64;

        @Override
        public List<class_1799> getContents() {
            return Arrays.asList(this.method_54079());
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.transaction.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.transaction.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        public int method_5444() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public InventoryHolder getOwner() {
            return (AbstractHorse)((Object)this.outerThis.bridge$getBukkitEntity());
        }

        @Override
        public Location getLocation() {
            return this.outerThis.bridge$getBukkitEntity().getLocation();
        }
    }
}

