/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.item;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.world.item.ItemStackBridge;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements ItemStackBridge {
    @Shadow
    private int field_8031;
    @Shadow
    @Final
    class_9335 field_49270;
    @Shadow
    @Deprecated
    @Nullable
    private class_1792 field_8038;
    private static final Logger LOG = LogManager.getLogger((String)"Arclight");

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            LOG.warn("Legacy ItemStack being used, updates will not applied: {}", (Object)this);
        }
    }

    @Decorate(method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;processDurabilityChange(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;I)I"))
    private int arclight$itemDamage(class_3218 serverLevel, class_1799 itemStack, int i, @Local(ordinal=0) class_3222 damager) throws Throwable {
        int result = DecorationOps.callsite().invoke(serverLevel, itemStack, i);
        if (damager != null) {
            PlayerItemDamageEvent event = new PlayerItemDamageEvent(((ServerPlayerEntityBridge)damager).bridge$getBukkitEntity(), CraftItemStack.asCraftMirror((class_1799)this), result);
            event.getPlayer().getServer().getPluginManager().callEvent(event);
            if (result != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return DecorationOps.cancel().invoke();
            }
            result = event.getDamage();
        }
        return result;
    }

    @Inject(method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V"}, require=0, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private void arclight$itemBreak(int amount, class_3218 level, @Nullable class_3222 serverPlayer, Consumer<class_1792> onBroken, CallbackInfo ci) {
        if (this.field_8031 == 1 && serverPlayer != null) {
            CraftEventFactory.callPlayerItemBreakEvent((class_1657)serverPlayer, (class_1799)this);
        }
    }

    public void restorePatch(class_9326 datacomponentpatch) {
        this.field_49270.method_59772(datacomponentpatch);
    }

    @Override
    public void bridge$restorePatch(class_9326 datacomponentpatch) {
        this.restorePatch(datacomponentpatch);
    }

    @Deprecated
    public void setItem(@Nullable class_1792 item) {
        this.field_8038 = item;
    }
}

