/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.block.entity;

import io.izzel.arclight.common.bridge.core.tileentity.TileEntityBridge;
import io.izzel.arclight.common.mixin.core.world.level.block.entity.LockableBlockEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1845;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2589;
import net.minecraft.class_2680;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2589.class})
public abstract class BrewingStandBlockEntityMixin
extends LockableBlockEntityMixin {
    @Shadow
    private class_2371<class_1799> field_11882;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;

    @Decorate(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    private static void arclight$brewFuel(class_1799 stack, int count, class_1937 level, class_2338 pos, class_2680 state, class_2589 entity) throws Throwable {
        BrewingStandFuelEvent event = new BrewingStandFuelEvent(CraftBlock.at((class_1936)level, pos), CraftItemStack.asCraftMirror(stack), 20);
        Bukkit.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            DecorationOps.cancel().invoke();
            return;
        }
        entity.field_11885 = event.getFuelPower();
        if (entity.field_11885 > 0 && event.isConsuming()) {
            DecorationOps.callsite().invoke(stack, count);
        }
        DecorationOps.blackhole().invoke();
    }

    @Inject(method={"serverTick"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;ingredient:Lnet/minecraft/world/item/Item;")})
    private static void arclight$brewBegin(class_1937 level, class_2338 pos, class_2680 p_155288_, class_2589 entity, CallbackInfo ci) {
        BrewingStartEvent event = new BrewingStartEvent(CraftBlock.at((class_1936)level, pos), CraftItemStack.asCraftMirror(entity.method_5438(3)), entity.field_11878);
        Bukkit.getPluginManager().callEvent(event);
        entity.field_11878 = event.getTotalBrewTime();
    }

    @Decorate(method={"doBrew"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;potionBrewing()Lnet/minecraft/world/item/alchemy/PotionBrewing;"))
    private static class_1845 arclight$brewEvent(class_1937 instance, class_1937 level, class_2338 pos, class_2371<class_1799> stacks, @Local(allocate="brewResults") List<ItemStack> brewResults) throws Throwable {
        class_1845 potionBrewing = DecorationOps.callsite().invoke(instance);
        class_2589 entity = (class_2589)ArclightCaptures.getTickingBlockEntity();
        InventoryHolder owner = entity == null ? null : ((TileEntityBridge)entity).bridge$getOwner();
        class_1799 ing = (class_1799)stacks.get(3);
        brewResults = new ArrayList<ItemStack>(3);
        for (int i = 0; i < 3; ++i) {
            brewResults.add(i, CraftItemStack.asCraftMirror(potionBrewing.method_8078(ing, (class_1799)stacks.get(i))));
        }
        if (owner != null) {
            BrewEvent event = new BrewEvent(CraftBlock.at((class_1936)level, pos), (BrewerInventory)owner.getInventory(), brewResults, entity.field_11885);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return DecorationOps.cancel().invoke();
            }
        }
        return potionBrewing;
    }

    @Decorate(method={"doBrew"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;"))
    private static <E> E arclight$applyResults(class_2371<E> instance, int i, E object, @Local(allocate="brewResults") List<ItemStack> brewResults) throws Throwable {
        object = i < brewResults.size() ? CraftItemStack.asNMSCopy(brewResults.get(i)) : class_1799.field_8037;
        return (E)DecorationOps.callsite().invoke(instance, i, object);
    }

    @Override
    public List<class_1799> getContents() {
        return this.field_11882;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setOwner(InventoryHolder owner) {
    }

    public int method_5444() {
        if (this.maxStack == 0) {
            this.maxStack = 64;
        }
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }
}

