/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.chunk.storage;

import io.izzel.arclight.common.bridge.core.world.chunk.storage.RegionFileCacheBridge;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_6836;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2867.class})
public abstract class RegionFileCacheMixin
implements RegionFileCacheBridge {
    private transient boolean arclight$existOnly;

    @Shadow
    protected abstract class_2861 method_12440(class_1923 var1) throws IOException;

    private class_2861 loadFile(class_1923 pos, boolean existsOnly) throws IOException {
        this.arclight$existOnly = existsOnly;
        return this.method_12440(pos);
    }

    @Inject(method={"getRegionFile"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="NEW", target="(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;Ljava/nio/file/Path;Z)Lnet/minecraft/world/level/chunk/storage/RegionFile;")})
    private void arclight$retIfSearch(class_1923 pos, CallbackInfoReturnable<class_2861> cir, long l, class_2861 rf, Path path) {
        if (this.arclight$existOnly && !Files.exists(path, new LinkOption[0])) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void arclight$read(class_1923 pos, CallbackInfoReturnable<class_2487> cir) {
        this.arclight$existOnly = true;
    }

    @Inject(method={"read"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFile;getChunkDataInputStream(Lnet/minecraft/world/level/ChunkPos;)Ljava/io/DataInputStream;")})
    private void arclight$retIfNotFound(class_1923 pos, CallbackInfoReturnable<class_2487> cir, class_2861 rf) {
        if (rf == null) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"write"}, at={@At(value="HEAD")})
    private void arclight$write(class_1923 pos, class_2487 compound, CallbackInfo ci) {
        this.arclight$existOnly = false;
    }

    @Inject(method={"scanChunk"}, at={@At(value="HEAD")})
    private void arclight$scan(CallbackInfo ci) {
        this.arclight$existOnly = true;
    }

    @Inject(method={"scanChunk"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFile;getChunkDataInputStream(Lnet/minecraft/world/level/ChunkPos;)Ljava/io/DataInputStream;")})
    private void arclight$retIfNotFound(class_1923 p_196957_, class_6836 p_196958_, CallbackInfo ci, class_2861 rf) {
        if (rf == null) {
            ci.cancel();
        }
    }

    public boolean chunkExists(class_1923 pos) throws IOException {
        class_2861 regionFile = this.loadFile(pos, true);
        return regionFile != null && regionFile.method_12423(pos);
    }

    @Override
    public boolean bridge$chunkExists(class_1923 pos) throws IOException {
        return this.chunkExists(pos);
    }
}

