/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.entity;

import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.Local;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_5565;
import net.minecraft.class_5566;
import net.minecraft.class_5568;
import net.minecraft.class_5571;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5579;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_5579.class})
public abstract class PersistentEntitySectionManagerMixin<T extends class_5568> {
    @Shadow
    @Final
    private class_5571<T> field_27263;
    @Shadow
    @Final
    class_5573<T> field_27265;
    @Shadow
    @Final
    private Long2ObjectMap<class_5579.class_5581> field_27268;
    @Unique
    private boolean arclight$fireEvent = false;

    @Shadow
    public abstract void close() throws IOException;

    public void close(boolean save) throws IOException {
        if (save) {
            this.close();
        } else {
            this.field_27263.close();
        }
    }

    public List<class_1297> getEntities(class_1923 chunkCoordIntPair) {
        return this.field_27265.method_31782(chunkCoordIntPair.method_8324()).flatMap(class_5572::method_31766).map(o -> (class_1297)o).collect(Collectors.toList());
    }

    public boolean isPending(long cord) {
        return this.field_27268.get(cord) == class_5579.class_5581.field_27276;
    }

    @Decorate(method={"storeChunkSections"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityPersistentStorage;storeEntities(Lnet/minecraft/world/level/entity/ChunkEntities;)V"))
    private void arclight$fireUnload(long pos, @Local(ordinal=-1) List<T> list) {
        if (this.arclight$fireEvent) {
            CraftEventFactory.callEntitiesUnloadEvent((class_1937)((class_5565)this.field_27263).field_27233, new class_1923(pos), list.stream().map(entity -> (class_1297)entity).collect(Collectors.toList()));
        }
    }

    @Inject(method={"storeChunkSections"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityPersistentStorage;storeEntities(Lnet/minecraft/world/level/entity/ChunkEntities;)V")})
    private void arclight$resetFlag(long pos, Consumer<T> consumer, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$fireEvent = false;
    }

    @Inject(method={"processChunkUnload"}, at={@At(value="HEAD")})
    private void arclight$fireEvent(long pChunkPosValue, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$fireEvent = true;
    }

    @Inject(method={"processPendingLoads"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, remap=false, target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;put(JLjava/lang/Object;)Ljava/lang/Object;")})
    private void arclight$fireLoad(CallbackInfo ci, class_5566<T> chunkEntities) {
        List<class_1297> entities = this.getEntities(chunkEntities.method_31741());
        CraftEventFactory.callEntitiesLoadEvent((class_1937)((class_5565)this.field_27263).field_27233, chunkEntities.method_31741(), entities);
    }

    @Inject(method={"unloadEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityAccess;setRemoved(Lnet/minecraft/world/entity/Entity$RemovalReason;)V")})
    private void arclight$unloadCause(class_5568 entityAccess, CallbackInfo ci) {
        if (entityAccess instanceof EntityBridge) {
            EntityBridge bridge = (EntityBridge)entityAccess;
            bridge.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.UNLOAD);
        }
    }
}

