/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.izzel.arclight.api.EnumHelper;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.bridge.bukkit.EntityTypeBridge;
import io.izzel.arclight.common.bridge.bukkit.MaterialBridge;
import io.izzel.arclight.common.bridge.bukkit.SimpleRegistryBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.entity.EntityClassLookup;
import io.izzel.arclight.common.mod.util.ResourceLocationUtil;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.i18n.conf.EntityPropertySpec;
import io.izzel.arclight.i18n.conf.MaterialPropertySpec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1527;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7709;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.potion.PotionType;

public class BukkitRegistry {
    private static final List<Class<?>> MAT_CTOR = ImmutableList.of(Integer.TYPE);
    private static final List<Class<?>> ENTITY_CTOR = ImmutableList.of(String.class, Class.class, Integer.TYPE);
    private static final List<Class<?>> ENV_CTOR = ImmutableList.of(Integer.TYPE);
    private static final Map<String, Material> BY_NAME = (Map)Unsafe.getStatic(Material.class, "BY_NAME");
    private static final Map<class_2248, Material> BLOCK_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "BLOCK_MATERIAL");
    private static final Map<class_1792, Material> ITEM_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "ITEM_MATERIAL");
    private static final Map<Material, class_1792> MATERIAL_ITEM = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "MATERIAL_ITEM");
    private static final Map<Material, class_2248> MATERIAL_BLOCK = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "MATERIAL_BLOCK");
    private static final Map<String, EntityType> ENTITY_NAME_MAP = (Map)Unsafe.getStatic(EntityType.class, "NAME_MAP");
    private static final Map<Integer, World.Environment> ENVIRONMENT_MAP = (Map)Unsafe.getStatic(World.Environment.class, "lookup");
    static final BiMap<class_5321<class_5363>, World.Environment> DIM_MAP = HashBiMap.create((Map)ImmutableMap.builder().put((Object)class_5363.field_25412, (Object)World.Environment.NORMAL).put((Object)class_5363.field_25413, (Object)World.Environment.NETHER).put((Object)class_5363.field_25414, (Object)World.Environment.THE_END).build());
    private static final Map<String, Art> ART_BY_NAME = (Map)Unsafe.getStatic(Art.class, "BY_NAME");
    private static final Map<Integer, Art> ART_BY_ID = (Map)Unsafe.getStatic(Art.class, "BY_ID");
    private static final BiMap<class_2960, Statistic> STATS = HashBiMap.create((Map)((Map)Unsafe.getStatic(CraftStatistic.class, "statistics")));

    public static void registerAll(class_3176 console) {
        BukkitRegistry.loadMaterials();
        BukkitRegistry.loadPotions();
        BukkitRegistry.loadEnchantmentTargets();
        BukkitRegistry.loadEntities();
        BukkitRegistry.loadVillagerProfessions();
        BukkitRegistry.loadBiomes(console);
        BukkitRegistry.loadArts(console);
        BukkitRegistry.loadStats();
        BukkitRegistry.loadSpawnCategory();
        BukkitRegistry.loadEndDragonPhase();
        BukkitRegistry.loadCookingBookCategory();
        BukkitRegistry.loadFluids();
        try {
            for (Field field : Registry.class.getFields()) {
                Object object;
                if (!Modifier.isStatic(field.getModifiers()) || !((object = field.get(null)) instanceof Registry.SimpleRegistry)) continue;
                Registry.SimpleRegistry registry = (Registry.SimpleRegistry)object;
                ((SimpleRegistryBridge)((Object)registry)).bridge$reload();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void loadFluids() {
        int id = Fluid.values().length;
        ArrayList<Fluid> newTypes = new ArrayList<Fluid>();
        Field keyField = Arrays.stream(Fluid.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(keyField);
        for (class_3611 fluidType : class_7923.field_41173) {
            class_2960 key = class_7923.field_41173.method_10221((Object)fluidType);
            String name = ResourceLocationUtil.standardize(key);
            try {
                Fluid.valueOf(name);
            }
            catch (Exception e) {
                Fluid bukkit = EnumHelper.makeEnum(Fluid.class, name, id++, List.of(), List.of());
                Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(key));
                newTypes.add(bukkit);
                ArclightServer.LOGGER.debug("Registered {} as fluid {}", (Object)key, (Object)bukkit);
            }
        }
        EnumHelper.addEnums(Fluid.class, newTypes);
    }

    private static void loadCookingBookCategory() {
        int id = class_7709.values().length;
        ArrayList<CookingBookCategory> newTypes = new ArrayList<CookingBookCategory>();
        for (class_7709 category : class_7709.values()) {
            try {
                CraftRecipe.getCategory(category);
            }
            catch (Exception e) {
                String name = category.name();
                CookingBookCategory bukkit = EnumHelper.makeEnum(CookingBookCategory.class, name, id++, List.of(), List.of());
                newTypes.add(bukkit);
                ArclightServer.LOGGER.debug("Registered {} as cooking category {}", (Object)name, (Object)bukkit);
            }
        }
        EnumHelper.addEnums(CookingBookCategory.class, newTypes);
    }

    private static void loadEndDragonPhase() {
        int max = class_1527.method_6869();
        ArrayList<EnderDragon.Phase> newTypes = new ArrayList<EnderDragon.Phase>();
        for (int id = EnderDragon.Phase.values().length; id < max; ++id) {
            String name = "MOD_PHASE_" + id;
            EnderDragon.Phase newPhase = EnumHelper.makeEnum(EnderDragon.Phase.class, name, id, List.of(), List.of());
            newTypes.add(newPhase);
            ArclightServer.LOGGER.debug("Registered {} as ender dragon phase {}", (Object)name, (Object)newPhase);
        }
        EnumHelper.addEnums(EnderDragon.Phase.class, newTypes);
    }

    private static void loadSpawnCategory() {
        int id = SpawnCategory.values().length;
        ArrayList<SpawnCategory> newTypes = new ArrayList<SpawnCategory>();
        for (class_1311 category : class_1311.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = EnumHelper.makeEnum(SpawnCategory.class, name, id++, List.of(), List.of());
                newTypes.add(spawnCategory);
                ArclightServer.LOGGER.debug("Registered {} as spawn category {}", (Object)name, (Object)spawnCategory);
            }
        }
        EnumHelper.addEnums(SpawnCategory.class, newTypes);
    }

    private static void loadStats() {
        int i = Statistic.values().length;
        ArrayList<Statistic> newTypes = new ArrayList<Statistic>();
        Field key = Arrays.stream(Statistic.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (class_3448 statType : class_7923.field_41193) {
            class_2960 location;
            Statistic statistic;
            if (statType == class_3468.field_15419 || (statistic = (Statistic)STATS.get((Object)(location = class_7923.field_41193.method_10221((Object)statType)))) != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            Statistic.Type type = statType.method_14959() == class_7923.field_41177 ? Statistic.Type.ENTITY : (statType.method_14959() == class_7923.field_41175 ? Statistic.Type.BLOCK : (statType.method_14959() == class_7923.field_41178 ? Statistic.Type.ITEM : Statistic.Type.UNTYPED));
            statistic = EnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(Statistic.Type.class), (List<Object>)ImmutableList.of((Object)((Object)type)));
            Unsafe.putObject(statistic, keyOffset, location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            ArclightServer.LOGGER.debug("Registered {} as stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        for (class_2960 location : class_7923.field_41183) {
            Statistic statistic = (Statistic)STATS.get((Object)location);
            if (statistic != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            statistic = EnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(), (List<Object>)ImmutableList.of());
            Unsafe.putObject(statistic, keyOffset, location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            ArclightServer.LOGGER.debug("Registered {} as custom stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        EnumHelper.addEnums(Statistic.class, newTypes);
        BukkitRegistry.putStatic(CraftStatistic.class, "statistics", STATS);
    }

    private static void loadArts(class_3176 console) {
        int i = Art.values().length;
        ArrayList<Art> newTypes = new ArrayList<Art>();
        Field key = Arrays.stream(Art.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        class_2378 reg = console.method_30611().method_30530(class_7924.field_41209);
        for (class_1535 paintingType : reg) {
            class_2960 location = reg.method_10221((Object)paintingType);
            String lookupName = location.method_12832().toLowerCase(Locale.ROOT);
            Art bukkit = Art.getByName(lookupName);
            if (bukkit != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            bukkit = EnumHelper.makeEnum(Art.class, standardName, i, ImmutableList.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), (List<Object>)ImmutableList.of((Object)i, (Object)paintingType.comp_2670(), (Object)paintingType.comp_2671()));
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(location));
            ART_BY_ID.put(i, bukkit);
            ART_BY_NAME.put(lookupName, bukkit);
            ArclightServer.LOGGER.debug("Registered {} as art {}", (Object)location, (Object)bukkit);
            ++i;
        }
        EnumHelper.addEnums(Art.class, newTypes);
    }

    private static void loadBiomes(class_3176 console) {
        int i = Biome.values().length;
        ArrayList<Biome> newTypes = new ArrayList<Biome>();
        Field key = Arrays.stream(Biome.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        class_2378 registry = console.method_30611().method_30530(class_7924.field_41236);
        for (class_1959 biome : registry) {
            Biome bukkit;
            class_2960 location = registry.method_10221((Object)biome);
            String name = ResourceLocationUtil.standardize(location);
            try {
                bukkit = Biome.valueOf(name);
            }
            catch (Throwable t) {
                bukkit = null;
            }
            if (bukkit != null) continue;
            bukkit = EnumHelper.makeEnum(Biome.class, name, i++, ImmutableList.of(), (List<Object>)ImmutableList.of());
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(location));
            ArclightServer.LOGGER.debug("Registered {} as biome {}", (Object)location, (Object)bukkit);
        }
        EnumHelper.addEnums(Biome.class, newTypes);
        ArclightServer.LOGGER.info("registry.biome", (Object)newTypes.size());
    }

    private static void loadVillagerProfessions() {
        int i = Villager.Profession.values().length;
        ArrayList<Villager.Profession> newTypes = new ArrayList<Villager.Profession>();
        Field key = Arrays.stream(Villager.Profession.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (class_3852 villagerProfession : class_7923.field_41195) {
            Villager.Profession profession;
            class_2960 location = class_7923.field_41195.method_10221((Object)villagerProfession);
            String name = ResourceLocationUtil.standardize(location);
            try {
                profession = Villager.Profession.valueOf(name);
            }
            catch (Throwable t) {
                profession = null;
            }
            if (profession != null) continue;
            profession = EnumHelper.makeEnum(Villager.Profession.class, name, i++, ImmutableList.of(), (List<Object>)ImmutableList.of());
            newTypes.add(profession);
            Unsafe.putObject(profession, keyOffset, CraftNamespacedKey.fromMinecraft(location));
            ArclightServer.LOGGER.debug("Registered {} as villager profession {}", (Object)location, (Object)profession);
        }
        EnumHelper.addEnums(Villager.Profession.class, newTypes);
        ArclightServer.LOGGER.info("registry.villager-profession", (Object)newTypes.size());
    }

    public static void registerEnvironments(class_2378<class_5363> registry) {
        int i = World.Environment.values().length;
        ArrayList<World.Environment> newTypes = new ArrayList<World.Environment>();
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            World.Environment environment = (World.Environment)((Object)DIM_MAP.get((Object)key));
            if (environment != null) continue;
            String name = ResourceLocationUtil.standardize(key.method_29177());
            environment = EnumHelper.makeEnum(World.Environment.class, name, i, ENV_CTOR, (List<Object>)ImmutableList.of((Object)(i - 1)));
            newTypes.add(environment);
            ENVIRONMENT_MAP.put(i - 1, environment);
            DIM_MAP.put((Object)key, (Object)environment);
            ArclightServer.LOGGER.debug("Registered {} as environment {}", (Object)key.method_29177(), (Object)environment);
            ++i;
        }
        EnumHelper.addEnums(World.Environment.class, newTypes);
        ArclightServer.LOGGER.info("registry.environment", (Object)newTypes.size());
    }

    private static void loadEntities() {
        int origin;
        int i = origin = EntityType.values().length;
        ArrayList<EntityType> newTypes = new ArrayList<EntityType>(class_7923.field_41177.method_29722().size() - origin + 1);
        for (class_1299 type : class_7923.field_41177) {
            class_2960 location = class_7923.field_41177.method_10221((Object)type);
            EntityType entityType = null;
            boolean found = false;
            if (location.method_12836().equals("minecraft")) {
                entityType = EntityType.fromName(location.method_12832());
                if (entityType != null) {
                    found = true;
                    ((EntityTypeBridge)((Object)entityType)).bridge$setHandle(type);
                } else {
                    ArclightServer.LOGGER.warn("Not found {} in {}", (Object)location, EntityType.class);
                }
            }
            if (!found) {
                String name = ResourceLocationUtil.standardize(location);
                entityType = EnumHelper.makeEnum(EntityType.class, name, i++, ENTITY_CTOR, (List<Object>)ImmutableList.of((Object)location.method_12832(), Entity.class, (Object)-1));
                ((EntityTypeBridge)((Object)entityType)).bridge$setup(location, type, BukkitRegistry.entitySpec(location));
                newTypes.add(entityType);
                ArclightServer.LOGGER.debug("Registered {} as entity {}", (Object)location, (Object)entityType);
            }
            ENTITY_NAME_MAP.put(location.toString(), entityType);
        }
        EnumHelper.addEnums(EntityType.class, newTypes);
        EntityClassLookup.init();
        ArclightServer.LOGGER.info("registry.entity-type", (Object)newTypes.size());
    }

    private static void loadEnchantmentTargets() {
        int origin = EnchantmentTarget.values().length;
    }

    private static void loadPotions() {
        int typeId = PotionType.values().length;
        ArrayList<PotionType> newTypes = new ArrayList<PotionType>();
        for (class_1842 potion : class_7923.field_41179) {
            class_2960 location = class_7923.field_41179.method_10221((Object)potion);
            String name = ResourceLocationUtil.standardize(location);
            try {
                PotionType.valueOf(name);
            }
            catch (Exception e) {
                PotionType potionType = EnumHelper.makeEnum(PotionType.class, name, typeId++, List.of(String.class), List.of(location.toString()));
                newTypes.add(potionType);
                ArclightServer.LOGGER.debug("Registered {} as potion type {}", (Object)location, (Object)potionType);
            }
        }
        EnumHelper.addEnums(PotionType.class, newTypes);
    }

    private static void loadMaterials() {
        class_1792 value;
        Material material;
        String name;
        class_2960 location;
        int i;
        int blocks = 0;
        int items = 0;
        int origin = i = Material.values().length;
        ArrayList<Material> list = new ArrayList<Material>();
        for (class_2248 block : class_7923.field_41175) {
            location = class_7923.field_41175.method_10221((Object)block);
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, (List<Object>)ImmutableList.of((Object)i));
                ((MaterialBridge)((Object)material)).bridge$setupBlock(location, block, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++blocks;
                ArclightServer.LOGGER.debug("Registered {} as block {}", (Object)location, (Object)material);
                list.add(material);
            } else {
                ((MaterialBridge)((Object)material)).bridge$setupVanillaBlock(BukkitRegistry.matSpec(location));
            }
            BLOCK_MATERIAL.put(block, material);
            MATERIAL_BLOCK.put(material, block);
            value = (class_1792)class_7923.field_41178.method_10223(location);
            if (value == null || value == class_1802.field_8162) continue;
            ((MaterialBridge)((Object)material)).bridge$setItem();
            ITEM_MATERIAL.put(value, material);
            MATERIAL_ITEM.put(material, value);
        }
        for (class_1792 item : class_7923.field_41178) {
            location = class_7923.field_41178.method_10221((Object)item);
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, (List<Object>)ImmutableList.of((Object)i));
                ((MaterialBridge)((Object)material)).bridge$setupItem(location, item, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++items;
                ArclightServer.LOGGER.debug("Registered {} as item {}", (Object)location, (Object)material);
                list.add(material);
            }
            ITEM_MATERIAL.put(item, material);
            MATERIAL_ITEM.put(material, item);
            value = (class_2248)class_7923.field_41175.method_10223(location);
            if (value == null || value == class_2246.field_10124) continue;
            ((MaterialBridge)((Object)material)).bridge$setBlock();
            BLOCK_MATERIAL.put((class_2248)value, material);
            MATERIAL_BLOCK.put(material, (class_2248)value);
        }
        EnumHelper.addEnums(Material.class, list);
        ArclightServer.LOGGER.info("registry.material", (Object)(i - origin), (Object)blocks, (Object)items);
    }

    private static MaterialPropertySpec matSpec(class_2960 location) {
        return ArclightConfig.spec().getCompat().getMaterial(location.toString()).orElse(MaterialPropertySpec.EMPTY);
    }

    private static EntityPropertySpec entitySpec(class_2960 location) {
        return ArclightConfig.spec().getCompat().getEntity(location.toString()).orElse(EntityPropertySpec.EMPTY);
    }

    public static Pose toBukkitPose(class_4050 nms) {
        if (Pose.values().length <= nms.ordinal()) {
            ArrayList<Pose> newTypes = new ArrayList<Pose>();
            int forgeCount = class_4050.values().length;
            for (int id = Pose.values().length; id < forgeCount; ++id) {
                String name = class_4050.values()[id].name();
                Pose newPhase = EnumHelper.makeEnum(Pose.class, name, id, List.of(), List.of());
                newTypes.add(newPhase);
                ArclightServer.LOGGER.debug("Registered {} as pose {}", (Object)name, (Object)newPhase);
            }
            EnumHelper.addEnums(Pose.class, newTypes);
        }
        return Pose.values()[nms.ordinal()];
    }

    private static void putStatic(Class<?> cl, String name, Object o) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putObject(materialByNameBase, materialByNameOffset, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void putBool(Class<?> cl, String name, boolean b) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putBoolean(materialByNameBase, materialByNameOffset, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

