/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server.event;

import io.izzel.arclight.common.bridge.core.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.item.ItemStackBridge;
import io.izzel.arclight.common.bridge.core.world.level.block.BlockBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1748;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_9326;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.inventory.ItemStack;

public abstract class ArclightEventFactory {
    public static void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callEntityDeathEvent(class_1309 entity, List<ItemStack> drops, class_1282 damageSource) {
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        CraftLivingEntity craftLivingEntity = ((LivingEntityBridge)entity).bridge$getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent(craftLivingEntity, bukkitDamageSource, drops, ((LivingEntityBridge)entity).bridge$getExpReward((class_1297)entity));
        ArclightEventFactory.callEvent(event);
        ((LivingEntityBridge)entity).bridge$setExpToDrop(event.getDroppedExp());
    }

    public static EntityDropItemEvent callEntityDropItemEvent(Entity entity, Item drop) {
        EntityDropItemEvent bukkitEvent = new EntityDropItemEvent(entity, drop);
        ArclightEventFactory.callEvent(bukkitEvent);
        return bukkitEvent;
    }

    public static boolean onBlockBreak(class_3225 controller, class_3218 level, class_3222 player, class_2338 pos, class_2680 state, boolean isSwordNoBreak) {
        if (level.method_8321(pos) == null && !isSwordNoBreak) {
            class_2626 packet = new class_2626(pos, class_2246.field_10124.method_9564());
            player.field_13987.method_14364((class_2596)packet);
        }
        CraftBlock bblock = CraftBlock.at((class_1936)level, pos);
        BlockBreakEvent event = new BlockBreakEvent((Block)bblock, (Player)((Object)player.bridge$getBukkitEntity()));
        ArclightCaptures.captureBlockBreakPlayer(event);
        event.setCancelled(isSwordNoBreak);
        class_2248 nmsBlock = state.method_26204();
        class_1799 itemstack = player.method_6118(class_1304.field_6173);
        if (!event.isCancelled() && !controller.method_14268() && player.method_7305(nmsBlock.method_9564())) {
            event.setExpToDrop(((BlockBridge)nmsBlock).bridge$getExpDrop(state, level, pos, itemstack));
        }
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            class_2596 packet;
            if (isSwordNoBreak) {
                return false;
            }
            player.field_13987.method_14364((class_2596)new class_2626((class_1922)level, pos));
            for (class_2350 dir : class_2350.values()) {
                player.field_13987.method_14364((class_2596)new class_2626((class_1922)level, pos.method_10093(dir)));
            }
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null && (packet = blockEntity.method_38235()) != null) {
                player.field_13987.method_14364(packet);
            }
            return false;
        }
        return !level.method_8320(pos).method_26215();
    }

    public static class_1269 onBlockPlace(class_1838 context, class_1657 player, class_1799 oldStack, class_1799 currentStack, class_1269 result) {
        class_3218 world = (class_3218)context.method_8045();
        class_2338 blockposition = context.method_8037();
        class_1268 enumhand = context.method_20287();
        BlockPlaceEvent placeEvent = null;
        ArrayList<BlockState> blocks = new ArrayList<BlockState>(((WorldBridge)world).bridge$getCapturedBlockState().values());
        int newSize = currentStack.method_7947();
        class_9326 newPatch = currentStack.method_57380();
        int size = oldStack.method_7947();
        class_9326 oldPatch = oldStack.method_57380();
        currentStack.method_7939(size);
        ((ItemStackBridge)currentStack).bridge$restorePatch(oldPatch);
        if (blocks.size() > 1) {
            placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, player, enumhand, blocks, blockposition.method_10263(), blockposition.method_10264(), blockposition.method_10260());
        } else if (blocks.size() == 1) {
            placeEvent = CraftEventFactory.callBlockPlaceEvent(world, player, enumhand, (BlockState)blocks.get(0), blockposition.method_10263(), blockposition.method_10264(), blockposition.method_10260());
        }
        if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
            result = class_1269.field_5814;
            placeEvent.getPlayer().updateInventory();
            ((WorldBridge)world).bridge$preventPoiUpdated(true);
            for (BlockState blockState : blocks) {
                blockState.update(true, false);
            }
            ((WorldBridge)world).bridge$preventPoiUpdated(false);
            class_2338 placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
            for (class_2350 dir : class_2350.values()) {
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2626((class_1922)world, placedPos.method_10093(dir)));
            }
        } else {
            class_2338 position;
            class_2680 class_26802;
            if (currentStack.method_7947() == size && Objects.equals(currentStack.method_57380(), oldPatch)) {
                ((ItemStackBridge)currentStack).bridge$restorePatch(newPatch);
                currentStack.method_7939(newSize);
            }
            for (Map.Entry<class_2338, class_2586> entry : ((WorldBridge)world).bridge$getCapturedBlockEntity().entrySet()) {
                world.method_8438(entry.getValue());
            }
            for (BlockState blockState : blocks) {
                int updateFlag = ((CraftBlockState)blockState).getFlag();
                class_2680 oldBlock = ((CraftBlockState)blockState).getHandle();
                class_2338 newblockposition = ((CraftBlockState)blockState).getPosition();
                class_2680 block = world.method_8320(newblockposition);
                block.method_26182((class_1937)world, newblockposition, oldBlock, true);
                ((WorldBridge)world).bridge$forge$notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, updateFlag, 512);
            }
            if (placeEvent != null && currentStack.method_7909() instanceof class_1748 && (class_26802 = world.method_8320(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).method_26204() instanceof class_2244) {
                world.method_8408(position, class_2246.field_10124);
                class_26802.method_30101((class_1936)world, position, 3);
            }
        }
        return result;
    }
}

