/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3568;
import net.minecraft.class_3846;
import net.minecraft.class_4076;
import net.minecraft.class_5565;
import net.minecraft.class_5579;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private final class_3218 worldServer;
    private final int x;
    private final int z;
    private static final class_2841<class_2680> emptyBlockIDs = new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
    private static final byte[] FULL_LIGHT = new byte[2048];
    private static final byte[] EMPTY_LIGHT = new byte[2048];

    public CraftChunk(class_2818 chunk) {
        this.worldServer = chunk.r;
        this.x = chunk.method_12004().field_9181;
        this.z = chunk.method_12004().field_9180;
    }

    public CraftChunk(class_3218 worldServer, int x, int z) {
        this.worldServer = worldServer;
        this.x = x;
        this.z = z;
    }

    @Override
    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public class_2791 getHandle(class_2806 chunkStatus) {
        class_2791 chunkAccess = this.worldServer.method_22342(this.x, this.z, chunkStatus);
        if (chunkAccess instanceof class_2821) {
            class_2821 extension = (class_2821)chunkAccess;
            return extension.method_12240();
        }
        return chunkAccess;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        CraftChunk.validateChunkCoordinates(this.worldServer.method_31607(), this.worldServer.method_31600(), x, y, z);
        return new CraftBlock((class_1936)this.worldServer, new class_2338(this.x << 4 | x, y, this.z << 4 | z));
    }

    @Override
    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().field_26935.method_37252(class_1923.method_8331((int)this.x, (int)this.z));
    }

    @Override
    public Entity[] getEntities() {
        long pair;
        class_5579 entityManager;
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        if ((entityManager = this.getCraftWorld().getHandle().field_26935).method_37252(pair = class_1923.method_8331((int)this.x, (int)this.z))) {
            return (Entity[])entityManager.getEntities(new class_1923(this.x, this.z)).stream().map(class_1297::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
        }
        entityManager.method_31810(pair);
        class_3846 mailbox = ((class_5565)entityManager.field_27263).field_34056;
        BooleanSupplier supplier = () -> {
            if (entityManager.method_37252(pair)) {
                return true;
            }
            if (!entityManager.isPending(pair)) {
                entityManager.method_31810(pair);
            }
            entityManager.method_31809();
            return entityManager.method_37252(pair);
        };
        while (!supplier.getAsBoolean()) {
            if (mailbox.method_34996() != 0) {
                mailbox.run();
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos("waiting for entity loading", 100000L);
        }
        return (Entity[])entityManager.getEntities(new class_1923(this.x, this.z)).stream().map(class_1297::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    @Override
    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        class_2791 chunk = this.getHandle(class_2806.field_12803);
        BlockState[] entities = new BlockState[chunk.field_34543.size()];
        for (class_2338 position : chunk.field_34543.keySet()) {
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.method_10263(), position.method_10264(), position.method_10260()).getState();
        }
        return entities;
    }

    @Override
    public boolean isGenerated() {
        class_2791 chunk = this.getHandle(class_2806.field_12798);
        return chunk.method_12009().method_12165(class_2806.field_12803);
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    @Override
    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    @Override
    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    @Override
    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    @Override
    public boolean isSlimeChunk() {
        return class_2919.method_12662((int)this.getX(), (int)this.getZ(), (long)this.getWorld().getSeed(), (long)this.worldServer.spigotConfig.slimeSeed).method_43048(10) == 0;
    }

    @Override
    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    @Override
    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    @Override
    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    @Override
    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    @Override
    public long getInhabitedTime() {
        return this.getHandle(class_2806.field_12798).method_12033();
    }

    @Override
    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle(class_2806.field_16423).method_12028(ticks);
    }

    @Override
    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (class_2826 section : this.getHandle(class_2806.field_12803).method_12006()) {
            if (section == null || !section.method_12265().method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        class_2791 chunk = this.getHandle(class_2806.field_12794);
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBiome.bukkitToMinecraftHolder(biome));
        for (class_2826 section : chunk.method_12006()) {
            if (section == null || !section.method_38294().method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        class_2791 chunk = this.getHandle(class_2806.field_12803);
        class_2826[] cs = chunk.method_12006();
        class_2841[] sectionBlockIDs = new class_2841[cs.length];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        class_2841[] biome = includeBiome || includeBiomeTempRain ? new class_2841[cs.length] : null;
        class_2378 iregistry = this.worldServer.method_30349().method_30530(class_7924.field_41236);
        Codec biomeCodec = class_2841.method_44347((class_2359)iregistry.method_40295(), (Codec)iregistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)iregistry.method_40290(class_1972.field_9451));
        for (int i = 0; i < cs.length; ++i) {
            class_2487 data = new class_2487();
            data.method_10566("block_states", (class_2520)class_2852.field_34576.encodeStart((DynamicOps)class_2509.field_11560, (Object)cs[i].method_12265()).getOrThrow());
            sectionBlockIDs[i] = (class_2841)class_2852.field_34576.parse((DynamicOps)class_2509.field_11560, (Object)data.method_10562("block_states")).getOrThrow(class_2852.class_9314::new);
            sectionEmpty[i] = cs[i].method_38292();
            class_3568 lightengine = this.worldServer.method_22336();
            class_2804 skyLightArray = lightengine.method_15562(class_1944.field_9284).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i), (int)this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i] = this.worldServer.method_8597().comp_642() ? FULL_LIGHT : EMPTY_LIGHT;
            } else {
                sectionSkyLights[i] = new byte[2048];
                System.arraycopy(skyLightArray.method_12137(), 0, sectionSkyLights[i], 0, 2048);
            }
            class_2804 emitLightArray = lightengine.method_15562(class_1944.field_9282).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i), (int)this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i] = EMPTY_LIGHT;
            } else {
                sectionEmitLights[i] = new byte[2048];
                System.arraycopy(emitLightArray.method_12137(), 0, sectionEmitLights[i], 0, 2048);
            }
            if (biome == null) continue;
            data.method_10566("biomes", (class_2520)biomeCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)cs[i].method_38294()).getOrThrow());
            biome[i] = (class_7522)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)data.method_10562("biomes")).getOrThrow(class_2852.class_9314::new);
        }
        class_2902 hmap = null;
        if (includeMaxBlockY) {
            hmap = new class_2902(chunk, class_2902.class_2903.field_13197);
            hmap.method_12600(chunk, class_2902.class_2903.field_13197, ((class_2902)chunk.field_34541.get(class_2902.class_2903.field_13197)).method_12598());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.method_31607(), chunk.method_31600(), world.getName(), world.getFullTime(), (class_2841<class_2680>[])sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, (class_2378<class_1959>)iregistry, (class_7522<class_6880<class_1959>>[])biome);
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle((class_2806)class_2806.field_16423).persistentDataContainer;
    }

    @Override
    public Chunk.LoadLevel getLoadLevel() {
        class_2818 chunk = this.worldServer.getChunkIfLoaded(this.getX(), this.getZ());
        if (chunk == null) {
            return Chunk.LoadLevel.UNLOADED;
        }
        return Chunk.LoadLevel.values()[chunk.method_12225().ordinal()];
    }

    @Override
    public Collection<GeneratedStructure> getStructures() {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ());
    }

    @Override
    public Collection<GeneratedStructure> getStructures(Structure structure) {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ(), structure);
    }

    @Override
    public Collection<Player> getPlayersSeeingChunk() {
        return this.getWorld().getPlayersSeeingChunk(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftChunk that = (CraftChunk)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        return this.worldServer.equals(that.worldServer);
    }

    public int hashCode() {
        int result = this.worldServer.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        class_2791 actual = world.getHandle().method_22342(x, z, includeBiome || includeBiomeTempRain ? class_2806.field_12794 : class_2806.field_12798);
        int hSection = actual.method_32890();
        class_2841[] blockIDs = new class_2841[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        class_2378 iregistry = world.getHandle().method_30349().method_30530(class_7924.field_41236);
        class_2841[] biome = includeBiome || includeBiomeTempRain ? new class_2841[hSection] : null;
        Codec biomeCodec = class_2841.method_44347((class_2359)iregistry.method_40295(), (Codec)iregistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)iregistry.method_40290(class_1972.field_9451));
        for (int i = 0; i < hSection; ++i) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = world.getHandle().method_8597().comp_642() ? FULL_LIGHT : EMPTY_LIGHT;
            emitLight[i] = EMPTY_LIGHT;
            empty[i] = true;
            if (biome == null) continue;
            biome[i] = (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)biomeCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)actual.method_38259(i).method_38294()).getOrThrow())).getOrThrow(class_2852.class_9314::new);
        }
        return new CraftChunkSnapshot(x, z, world.getMinHeight(), world.getMaxHeight(), world.getName(), world.getFullTime(), (class_2841<class_2680>[])blockIDs, skyLight, emitLight, empty, new class_2902(actual, class_2902.class_2903.field_13197), (class_2378<class_1959>)iregistry, (class_7522<class_6880<class_1959>>[])biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((minY <= y && y <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }
}

