/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7444;
import net.minecraft.class_7924;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftMusicInstrument
extends MusicInstrument
implements Handleable<class_7444> {
    private final NamespacedKey key;
    private final class_7444 handle;

    public static MusicInstrument minecraftToBukkit(class_7444 minecraft) {
        return CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41275, Registry.INSTRUMENT);
    }

    public static MusicInstrument minecraftHolderToBukkit(class_6880<class_7444> minecraft) {
        return CraftMusicInstrument.minecraftToBukkit((class_7444)minecraft.comp_349());
    }

    public static class_7444 bukkitToMinecraft(MusicInstrument bukkit) {
        return (class_7444)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_7444> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41275);
        class_6880 class_68802 = registry.method_47983((Object)CraftMusicInstrument.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own instrument without properly registering it.");
    }

    public static String bukkitToString(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static MusicInstrument stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return Registry.INSTRUMENT.get(NamespacedKey.fromString(string));
    }

    public CraftMusicInstrument(NamespacedKey key, class_7444 handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public class_7444 getHandle() {
        return this.handle;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftMusicInstrument)) {
            return false;
        }
        return this.getKey().equals(((MusicInstrument)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftMusicInstrument{key=" + String.valueOf(this.key) + "}";
    }
}

