/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1686;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2279;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_6808;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionType;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract class_5281 getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof class_3218;
    }

    @Override
    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)this.getHandle().method_16359(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    @Override
    public void setBiome(int x, int y, int z, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        class_6880<class_1959> biomeBase = CraftBiome.bukkitToMinecraftHolder(biome);
        this.setBiome(x, y, z, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, class_6880<class_1959> var4);

    @Override
    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return CraftBlock.at((class_1936)this.getHandle(), new class_2338(x, y, z)).getState();
    }

    @Override
    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getData(x, y, z));
    }

    @Override
    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public Material getType(int x, int y, int z) {
        return CraftBlockType.minecraftToBukkit(this.getData(x, y, z).method_26204());
    }

    private class_2680 getData(int x, int y, int z) {
        return this.getHandle().method_8320(new class_2338(x, y, z));
    }

    @Override
    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData blockData) {
        class_5281 world = this.getHandle();
        class_2338 pos = new class_2338(x, y, z);
        class_2680 old = this.getHandle().method_8320(pos);
        CraftBlock.setTypeAndData((class_1936)world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    @Override
    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    @Override
    public void setType(int x, int y, int z, Material material) {
        this.setBlockData(x, y, z, material.createBlockData());
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        return this.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        return this.getHandle().method_8624(CraftHeightMap.toNMS(heightMap), x, z);
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType) {
        class_2338 pos = CraftLocation.toBlockPosition(location);
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().method_14178().method_12129(), pos, new RandomSourceWrapper(random), treeType);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        });
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<? super BlockState> predicate) {
        class_2338 pos = CraftLocation.toBlockPosition(location);
        BlockStateListPopulator populator = new BlockStateListPopulator((class_1936)this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().method_14178().method_12129(), pos, new RandomSourceWrapper(random), treeType);
        populator.refreshTiles();
        for (BlockState blockState : populator.getList()) {
            if (predicate != null && !predicate.test(blockState)) continue;
            blockState.update(true, true);
        }
        return result;
    }

    public boolean generateTree(class_5281 access, class_2794 chunkGenerator, class_2338 pos, class_5819 random, TreeType treeType) {
        class_5321 gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = class_6808.field_35912;
                break;
            }
            case BIRCH: {
                gen = class_6808.field_35907;
                break;
            }
            case REDWOOD: {
                gen = class_6808.field_35909;
                break;
            }
            case TALL_REDWOOD: {
                gen = class_6808.field_35910;
                break;
            }
            case JUNGLE: {
                gen = class_6808.field_35914;
                break;
            }
            case SMALL_JUNGLE: {
                gen = class_6808.field_35913;
                break;
            }
            case COCOA_TREE: {
                gen = class_6808.field_35911;
                break;
            }
            case JUNGLE_BUSH: {
                gen = class_6808.field_35920;
                break;
            }
            case RED_MUSHROOM: {
                gen = class_6808.field_35904;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = class_6808.field_35903;
                break;
            }
            case SWAMP: {
                gen = class_6808.field_35919;
                break;
            }
            case ACACIA: {
                gen = class_6808.field_35908;
                break;
            }
            case DARK_OAK: {
                gen = class_6808.field_35906;
                break;
            }
            case MEGA_REDWOOD: {
                gen = class_6808.field_35915;
                break;
            }
            case MEGA_PINE: {
                gen = class_6808.field_35916;
                break;
            }
            case TALL_BIRCH: {
                gen = class_6808.field_35917;
                break;
            }
            case CHORUS_PLANT: {
                class_2279 cfr_ignored_0 = (class_2279)class_2246.field_10528;
                class_2279.method_9744((class_1936)access, (class_2338)pos, (class_5819)random, (int)8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = class_6808.field_35900;
                break;
            }
            case WARPED_FUNGUS: {
                gen = class_6808.field_35902;
                break;
            }
            case AZALEA: {
                gen = class_6808.field_35921;
                break;
            }
            case MANGROVE: {
                gen = class_6808.field_38810;
                break;
            }
            case TALL_MANGROVE: {
                gen = class_6808.field_38811;
                break;
            }
            case CHERRY: {
                gen = class_6808.field_42960;
                break;
            }
            default: {
                gen = class_6808.field_35905;
            }
        }
        class_6880 holder = access.method_30349().method_30530(class_7924.field_41239).method_40264(gen).orElse(null);
        return holder != null ? ((class_2975)holder.comp_349()).method_12862(access, chunkGenerator, random, pos) : false;
    }

    @Override
    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)((Object)bukkitEntity));
            }
        });
        return list;
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<class_1297> getNMSEntities();

    @Override
    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        return (T)entity.getBukkitEntity();
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    @Override
    public <T extends Entity> T addEntity(T entity) {
        Preconditions.checkArgument((!entity.isInWorld() ? 1 : 0) != 0, (Object)"Entity has already been added to a world");
        class_1297 nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity.method_37908() != this.getHandle().method_8410()) {
            nmsEntity = nmsEntity.method_5731(new class_5454(this.getHandle().method_8410(), nmsEntity, class_5454.field_52245));
        }
        this.addEntityWithPassengers(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (T)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason, Consumer<? super T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)this.getHandle(), this.getHandle().method_8404(entity.method_24515()), class_3730.field_16462, (class_1315)null);
        }
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(class_1297 var1, CreatureSpawnEvent.SpawnReason var2);

    public abstract void addEntityWithPassengers(class_1297 var1, CreatureSpawnEvent.SpawnReason var2);

    public class_1297 makeEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    public class_1297 createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Consumer<class_1297> runOld = other -> {};
        if (clazz == AbstractArrow.class) {
            clazz = Arrow.class;
        } else if (clazz == AbstractHorse.class) {
            clazz = Horse.class;
        } else if (clazz == Fireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == LingeringPotion.class) {
            clazz = ThrownPotion.class;
            runOld = other -> ((class_1686)other).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
        } else if (clazz == Minecart.class) {
            clazz = RideableMinecart.class;
        } else if (clazz == SizedFireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == SplashPotion.class) {
            clazz = ThrownPotion.class;
        } else if (clazz == TippedArrow.class) {
            clazz = Arrow.class;
            runOld = other -> ((Arrow)((Object)other.getBukkitEntity())).setBasePotionType(PotionType.WATER);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(clazz);
        if (entityTypeData == null || entityTypeData.spawnFunction() == null) {
            if (CraftEntity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("Cannot spawn an entity from its CraftBukkit implementation class '%s' use the Bukkit class instead. You can get the Bukkit representation via Entity#getType()#getEntityClass()", clazz.getName()));
            }
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        }
        if (!entityTypeData.entityType().isEnabledByFeature(this.getHandle().getMinecraftWorld().getWorld())) {
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName() + " because it is not an enabled feature");
        }
        class_1297 entity = (class_1297)entityTypeData.spawnFunction().apply(new CraftEntityTypes.SpawnData(this.getHandle(), location, randomizeData, this.isNormalWorld()));
        if (entity != null) {
            runOld.accept(entity);
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }
}

