/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_8110;
import net.minecraft.class_9346;
import net.minecraft.class_9793;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R1.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R1.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R1.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R1.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R1.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static class_5455 registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final class_2378<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, M, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(class_5455 registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static class_5455 getMinecraftRegistry() {
        return registry;
    }

    public static <E> class_2378<E> getMinecraftRegistry(class_5321<class_2378<E>> key) {
        return CraftRegistry.getMinecraftRegistry().method_30530(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, class_5321<class_2378<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378<M> registry = CraftRegistry.getMinecraftRegistry(registryKey);
        B bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft)))).method_29177()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)((Object)bukkit)).getHandle();
    }

    public static <B extends Keyed, M> class_6880<M> bukkitToMinecraftHolder(B bukkit, class_5321<class_2378<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378<M> registry = CraftRegistry.getMinecraftRegistry(registryKey);
        class_6880 class_68802 = registry.method_47983(CraftRegistry.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, class_5455 registryHolder) {
        if (bukkitClass == Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, class_1887>(Enchantment.class, registryHolder.method_30530(class_7924.field_41265), CraftEnchantment::new, FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, class_5712>(GameEvent.class, registryHolder.method_30530(class_7924.field_41273), CraftGameEvent::new, FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, class_7444>(MusicInstrument.class, registryHolder.method_30530(class_7924.field_41275), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, class_1291>(PotionEffectType.class, registryHolder.method_30530(class_7924.field_41208), CraftPotionEffectType::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, class_3195>(Structure.class, registryHolder.method_30530(class_7924.field_41246), CraftStructure::new, FieldRename.NONE);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, class_7151>(StructureType.class, class_7923.field_41147, CraftStructureType::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, class_8054>(TrimMaterial.class, registryHolder.method_30530(class_7924.field_42083), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, class_8056>(TrimPattern.class, registryHolder.method_30530(class_7924.field_42082), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, class_8110>(DamageType.class, registryHolder.method_30530(class_7924.field_42534), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, class_9793>(JukeboxSong.class, registryHolder.method_30530(class_7924.field_52176), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, class_9346>(Wolf.Variant.class, registryHolder.method_30530(class_7924.field_49772), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, class_2248>(BlockType.class, registryHolder.method_30530(class_7924.field_41254), CraftBlockType::new, FieldRename.NONE);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, class_1792>(ItemType.class, registryHolder.method_30530(class_7924.field_41197), CraftItemType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == Biome.class) {
                return bukkit.get(FieldRename.BIOME_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == EntityType.class) {
                return bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Attribute.class) {
                return bukkit.get(FieldRename.ATTRIBUTE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, class_2378<M> minecraftRegistry, BiFunction<NamespacedKey, M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    @Override
    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.method_17966(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @Override
    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.method_10235().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    @Override
    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

