/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_9782;
import org.bukkit.ServerLinks;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;

public class CraftServerLinks
implements ServerLinks {
    private final class_3176 server;
    private class_9782 serverLinks;

    public CraftServerLinks(class_3176 server) {
        this(server, null);
    }

    public CraftServerLinks(class_9782 serverLinks) {
        this(null, serverLinks);
    }

    private CraftServerLinks(class_3176 server, class_9782 serverLinks) {
        this.server = server;
        this.serverLinks = serverLinks;
    }

    @Override
    public ServerLinks.ServerLink getLink(ServerLinks.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        return this.getServerLinks().method_60658(CraftServerLinks.fromBukkit(type)).map(CraftServerLink::new).orElse(null);
    }

    @Override
    public List<ServerLinks.ServerLink> getLinks() {
        return this.getServerLinks().comp_2826().stream().map(nms -> new CraftServerLink((class_9782.class_9783)nms)).toList();
    }

    @Override
    public ServerLinks.ServerLink setLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        ServerLinks.ServerLink existing = this.getLink(type);
        if (existing != null) {
            this.removeLink(existing);
        }
        return this.addLink(type, url);
    }

    @Override
    public ServerLinks.ServerLink addLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(class_9782.class_9783.method_60663((class_9782.class_9784)CraftServerLinks.fromBukkit(type), (URI)url));
        this.addLink(link);
        return link;
    }

    @Override
    public ServerLinks.ServerLink addLink(String displayName, URI url) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"displayName cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(class_9782.class_9783.method_60665((class_2561)CraftChatMessage.fromStringOrNull(displayName), (URI)url));
        this.addLink(link);
        return link;
    }

    private void addLink(CraftServerLink link) {
        ArrayList<class_9782.class_9783> lst = new ArrayList<class_9782.class_9783>(this.getServerLinks().comp_2826());
        lst.add(link.handle);
        this.setLinks(new class_9782(lst));
    }

    @Override
    public boolean removeLink(ServerLinks.ServerLink link) {
        Preconditions.checkArgument((link != null ? 1 : 0) != 0, (Object)"link cannot be null");
        ArrayList lst = new ArrayList(this.getServerLinks().comp_2826());
        boolean result = lst.remove(((CraftServerLink)link).handle);
        this.setLinks(new class_9782(lst));
        return result;
    }

    @Override
    public ServerLinks copy() {
        return new CraftServerLinks(this.getServerLinks());
    }

    public class_9782 getServerLinks() {
        return this.server != null ? this.server.method_60672() : this.serverLinks;
    }

    private void setLinks(class_9782 links) {
        if (this.server != null) {
            this.server.field_52215 = links;
        } else {
            this.serverLinks = links;
        }
    }

    private static class_9782.class_9784 fromBukkit(ServerLinks.Type type) {
        return class_9782.class_9784.values()[type.ordinal()];
    }

    private static ServerLinks.Type fromNMS(class_9782.class_9784 nms) {
        return ServerLinks.Type.values()[nms.ordinal()];
    }

    public static class CraftServerLink
    implements ServerLinks.ServerLink {
        private final class_9782.class_9783 handle;

        public CraftServerLink(class_9782.class_9783 handle) {
            this.handle = handle;
        }

        @Override
        public ServerLinks.Type getType() {
            return this.handle.comp_2827().left().map(CraftServerLinks::fromNMS).orElse(null);
        }

        @Override
        public String getDisplayName() {
            return CraftChatMessage.fromComponent(this.handle.method_60662());
        }

        @Override
        public URI getUrl() {
            return this.handle.comp_2828();
        }
    }
}

