/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final class_2784 handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().method_8621();
    }

    public CraftWorldBorder(class_2784 handle) {
        this.world = null;
        this.handle = handle;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void reset() {
        this.getHandle().method_17905(class_2784.field_24122);
    }

    @Override
    public double getSize() {
        return this.handle.method_11965();
    }

    @Override
    public void setSize(double newSize) {
        this.setSize(newSize, 0L);
    }

    @Override
    public void setSize(double newSize, long time) {
        this.setSize(Math.min(this.getMaxSize(), Math.max(1.0, newSize)), TimeUnit.SECONDS, Math.min(9223372036854775L, Math.max(0L, time)));
    }

    @Override
    public void setSize(double newSize, TimeUnit unit, long time) {
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)"TimeUnit cannot be null.");
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"time cannot be lower than 0");
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        if (time > 0L) {
            this.handle.method_11957(this.handle.method_11965(), newSize, unit.toMillis(time));
        } else {
            this.handle.method_11969(newSize);
        }
    }

    @Override
    public Location getCenter() {
        double x = this.handle.method_11964();
        double z = this.handle.method_11980();
        return new Location(this.world, x, 0.0, z);
    }

    @Override
    public void setCenter(double x, double z) {
        Preconditions.checkArgument((Math.abs(x) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        Preconditions.checkArgument((Math.abs(z) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        this.handle.method_11978(x, z);
    }

    @Override
    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    @Override
    public double getDamageBuffer() {
        return this.handle.method_11971();
    }

    @Override
    public void setDamageBuffer(double blocks) {
        this.handle.method_11981(blocks);
    }

    @Override
    public double getDamageAmount() {
        return this.handle.method_11953();
    }

    @Override
    public void setDamageAmount(double damage) {
        this.handle.method_11955(damage);
    }

    @Override
    public int getWarningTime() {
        return this.handle.method_11956();
    }

    @Override
    public void setWarningTime(int time) {
        this.handle.method_11975(time);
    }

    @Override
    public int getWarningDistance() {
        return this.handle.method_11972();
    }

    @Override
    public void setWarningDistance(int distance) {
        this.handle.method_11967(distance);
    }

    @Override
    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        return (this.world == null || location.getWorld().equals(this.world)) && this.handle.method_11952(class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ()));
    }

    @Override
    public double getMaxSize() {
        return 5.9999968E7;
    }

    @Override
    public double getMaxCenterCoordinate() {
        return 2.9999984E7;
    }

    public class_2784 getHandle() {
        return this.handle;
    }

    public boolean isVirtual() {
        return this.world == null;
    }
}

