/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends class_2586>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, tileEntity.method_11016(), tileEntity.method_11010());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    private class_5455 getRegistryAccess() {
        class_1936 worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.method_30349() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        class_2487 nbtTagCompound = tileEntity.method_38242((class_7225.class_7874)this.getRegistryAccess());
        class_2586 snapshot = class_2586.method_11005((class_2338)this.getPosition(), (class_2680)this.getHandle(), (class_2487)nbtTagCompound, (class_7225.class_7874)this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<class_9331<?>> applyComponents(class_9323 datacomponentmap, class_9326 datacomponentpatch) {
        Set result = this.snapshot.applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public class_9323 collectComponents() {
        return this.snapshot.method_57590();
    }

    public void loadData(class_2487 nbtTagCompound) {
        this.snapshot.method_58690(nbtTagCompound, (class_7225.class_7874)this.getRegistryAccess());
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        class_2487 nbtTagCompound = from.method_38242((class_7225.class_7874)this.getRegistryAccess());
        to.method_58690(nbtTagCompound, (class_7225.class_7874)this.getRegistryAccess());
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected class_2586 getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().method_8321(this.getPosition());
    }

    public class_2487 getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return this.snapshot.method_38242((class_7225.class_7874)this.getRegistryAccess());
    }

    public class_2487 getSnapshotNBTWithoutComponents() {
        class_2487 nbt = this.getSnapshotNBT();
        this.snapshot.method_57569(nbt);
        return nbt;
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(class_2586 tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        class_2586 tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.method_5431();
        }
        return result;
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return ((class_2586)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public class_2596<class_2602> getUpdatePacket(@NotNull Location location) {
        class_2586 vanillaTileEntitiy = class_2586.method_11005((class_2338)CraftLocation.toBlockPosition(location), (class_2680)this.getHandle(), (class_2487)this.getSnapshotNBT(), (class_7225.class_7874)this.getRegistryAccess());
        return class_2622.method_38585((class_2586)vanillaTileEntitiy);
    }

    @Override
    public CraftBlockEntityState<T> copy() {
        return new CraftBlockEntityState<T>(this, null);
    }

    @Override
    public CraftBlockEntityState<T> copy(Location location) {
        return new CraftBlockEntityState<T>(this, location);
    }
}

