/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.sign.CraftSignSide;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.jetbrains.annotations.NotNull;

public class CraftSign<T extends class_2625>
extends CraftBlockEntityState<T>
implements Sign {
    private final CraftSignSide front = new CraftSignSide(((class_2625)this.getSnapshot()).method_49853());
    private final CraftSignSide back = new CraftSignSide(((class_2625)this.getSnapshot()).method_49854());

    public CraftSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftSign(CraftSign<T> state, Location location) {
        super(state, location);
    }

    @Override
    public String[] getLines() {
        return this.front.getLines();
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    @Override
    public boolean isEditable() {
        return !this.isWaxed();
    }

    @Override
    public void setEditable(boolean editable) {
        this.setWaxed(!editable);
    }

    @Override
    public boolean isWaxed() {
        return ((class_2625)this.getSnapshot()).method_49855();
    }

    @Override
    public void setWaxed(boolean waxed) {
        ((class_2625)this.getSnapshot()).method_49849(waxed);
    }

    @Override
    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    @Override
    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @Override
    @NotNull
    public SignSide getSide(Side side) {
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        switch (side) {
            case FRONT: {
                return this.front;
            }
            case BACK: {
                return this.back;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SignSide getTargetSide(Player player) {
        this.ensureNoWorldGeneration();
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        if (((class_2625)this.getSnapshot()).method_49834((class_1657)((CraftPlayer)player).getHandle())) {
            return this.front;
        }
        return this.back;
    }

    @Override
    public Player getAllowedEditor() {
        this.ensureNoWorldGeneration();
        UUID id = ((class_2625)this.getTileEntity()).method_11305();
        return id == null ? null : Bukkit.getPlayer(id);
    }

    @Override
    public DyeColor getColor() {
        return this.front.getColor();
    }

    @Override
    public void setColor(DyeColor color) {
        this.front.setColor(color);
    }

    @Override
    public void applyTo(T sign) {
        ((class_2625)this.getSnapshot()).method_49840(this.front.applyLegacyStringToSignSide(), true);
        ((class_2625)this.getSnapshot()).method_49840(this.back.applyLegacyStringToSignSide(), false);
        super.applyTo(sign);
    }

    @Override
    public CraftSign<T> copy() {
        return new CraftSign<T>(this, null);
    }

    @Override
    public CraftSign<T> copy(Location location) {
        return new CraftSign<T>(this, location);
    }

    public static void openSign(Sign sign, Player player, Side side) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        if (!CraftEventFactory.callPlayerSignOpenEvent(player, sign, side, PlayerSignOpenEvent.Cause.PLUGIN)) {
            return;
        }
        class_2625 handle = (class_2625)((CraftSign)sign).getTileEntity();
        handle.method_11306(player.getUniqueId());
        ((CraftPlayer)player).getHandle().method_7311(handle, Side.FRONT == side);
    }

    public static class_2561[] sanitizeLines(String[] lines) {
        class_2561[] components = new class_2561[4];
        for (int i = 0; i < 4; ++i) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : class_2561.method_43473();
        }
        return components;
    }

    public static String[] revertComponents(class_2561[] components) {
        String[] lines = new String[components.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CraftSign.revertComponent(components[i]);
        }
        return lines;
    }

    private static String revertComponent(class_2561 component) {
        return CraftChatMessage.fromComponent(component);
    }
}

