/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_7923;
import net.minecraft.class_8961;
import net.minecraft.class_8965;
import net.minecraft.class_8966;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawnerConfiguration
implements TrialSpawnerConfiguration {
    private final class_8961 snapshot;
    private int spawnRange;
    private float totalMobs;
    private float simultaneousMobs;
    private float totalMobsAddedPerPlayer;
    private float simultaneousMobsAddedPerPlayer;
    private int ticksBetweenSpawn;
    private class_6005<class_1952> spawnPotentialsDefinition;
    private class_6005<class_5321<class_52>> lootTablesToEject;
    private class_5321<class_52> itemsToDropWhenOminous;

    public CraftTrialSpawnerConfiguration(class_8965 minecraft, class_8961 snapshot) {
        this.snapshot = snapshot;
        this.spawnRange = minecraft.comp_2103();
        this.totalMobs = minecraft.comp_2104();
        this.simultaneousMobs = minecraft.comp_2105();
        this.totalMobsAddedPerPlayer = minecraft.comp_2106();
        this.simultaneousMobsAddedPerPlayer = minecraft.comp_2107();
        this.ticksBetweenSpawn = minecraft.comp_2108();
        this.spawnPotentialsDefinition = minecraft.comp_2110();
        this.lootTablesToEject = minecraft.comp_2111();
        this.itemsToDropWhenOminous = minecraft.comp_2552();
    }

    @Override
    public EntityType getSpawnedType() {
        if (this.spawnPotentialsDefinition.method_34993()) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)((class_1952)((class_6008.class_6010)this.spawnPotentialsDefinition.method_34994().get(0)).comp_2542()).method_38093());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getTrialData().field_47376 = Optional.empty();
            this.spawnPotentialsDefinition = class_6005.method_38062();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        class_1952 data = new class_1952();
        data.method_38093().method_10582("id", class_7923.field_41177.method_10221(CraftEntityType.bukkitToMinecraft(entityType)).toString());
        this.getTrialData().field_47376 = Optional.of(data);
        this.spawnPotentialsDefinition = class_6005.method_38061((Object)data);
    }

    @Override
    public float getBaseSpawnsBeforeCooldown() {
        return this.totalMobs;
    }

    @Override
    public void setBaseSpawnsBeforeCooldown(float amount) {
        this.totalMobs = amount;
    }

    @Override
    public float getBaseSimultaneousEntities() {
        return this.simultaneousMobs;
    }

    @Override
    public void setBaseSimultaneousEntities(float amount) {
        this.simultaneousMobs = amount;
    }

    @Override
    public float getAdditionalSpawnsBeforeCooldown() {
        return this.totalMobsAddedPerPlayer;
    }

    @Override
    public void setAdditionalSpawnsBeforeCooldown(float amount) {
        this.totalMobsAddedPerPlayer = amount;
    }

    @Override
    public float getAdditionalSimultaneousEntities() {
        return this.simultaneousMobsAddedPerPlayer;
    }

    @Override
    public void setAdditionalSimultaneousEntities(float amount) {
        this.simultaneousMobsAddedPerPlayer = amount;
    }

    @Override
    public int getDelay() {
        return this.ticksBetweenSpawn;
    }

    @Override
    public void setDelay(int delay) {
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"Delay cannot be less than 0");
        this.ticksBetweenSpawn = delay;
    }

    @Override
    public int getSpawnRange() {
        return this.spawnRange;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    @Override
    public EntitySnapshot getSpawnedEntity() {
        class_6005<class_1952> potentials = this.spawnPotentialsDefinition;
        if (potentials.method_34993()) {
            return null;
        }
        return CraftEntitySnapshot.create(((class_1952)((class_6008.class_6010)potentials.method_34994().get(0)).comp_2542()).method_38093());
    }

    @Override
    public void setSpawnedEntity(EntitySnapshot snapshot) {
        this.setSpawnedEntity(snapshot, null, null);
    }

    @Override
    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.setSpawnedEntity(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    private void setSpawnedEntity(EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        if (snapshot == null) {
            this.getTrialData().field_47376 = Optional.empty();
            this.spawnPotentialsDefinition = class_6005.method_38062();
            return;
        }
        class_2487 compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        class_1952 data = new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
        this.getTrialData().field_47376 = Optional.of(data);
        this.spawnPotentialsDefinition = class_6005.method_38061((Object)data);
    }

    @Override
    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        this.addPotentialSpawn(snapshot, weight, spawnRule, null);
    }

    private void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        class_2487 compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        class_6005.class_6006 builder = class_6005.method_34971();
        this.spawnPotentialsDefinition.method_34994().forEach(entry -> builder.method_34975((Object)((class_1952)entry.comp_2542()), entry.method_34979().method_34976()));
        builder.method_34975((Object)new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        this.spawnPotentialsDefinition = builder.method_34974();
    }

    @Override
    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    @Override
    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        class_6005.class_6006 builder = class_6005.method_34971();
        for (SpawnerEntry spawnerEntry : entries) {
            class_2487 compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.method_34975((Object)new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        this.spawnPotentialsDefinition = builder.method_34974();
    }

    @Override
    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (class_6008.class_6010 entry : this.spawnPotentialsDefinition.method_34994()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((class_1952)entry.comp_2542()).method_38093());
            if (snapshot == null) continue;
            SpawnRule rule = ((class_1952)entry.comp_2542()).comp_65().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry(snapshot, entry.method_34979().method_34976(), rule));
        }
        return entries;
    }

    @Override
    public Map<LootTable, Integer> getPossibleRewards() {
        HashMap<LootTable, Integer> tables = new HashMap<LootTable, Integer>();
        for (class_6008.class_6010 entry : this.lootTablesToEject.method_34994()) {
            LootTable table = CraftLootTable.minecraftToBukkit((class_5321<class_52>)((class_5321)entry.comp_2542()));
            if (table == null) continue;
            tables.put(table, entry.method_34979().method_34976());
        }
        return tables;
    }

    @Override
    public void addPossibleReward(LootTable table, int weight) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
        class_6005.class_6006 builder = class_6005.method_34971();
        this.lootTablesToEject.method_34994().forEach(entry -> builder.method_34975((Object)((class_5321)entry.comp_2542()), entry.method_34979().method_34976()));
        builder.method_34975(CraftLootTable.bukkitToMinecraft(table), weight);
        this.lootTablesToEject = builder.method_34974();
    }

    @Override
    public void removePossibleReward(LootTable table) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        class_5321<class_52> minecraftKey = CraftLootTable.bukkitToMinecraft(table);
        class_6005.class_6006 builder = class_6005.method_34971();
        for (class_6008.class_6010 entry : this.lootTablesToEject.method_34994()) {
            if (((class_5321)entry.comp_2542()).equals(minecraftKey)) continue;
            builder.method_34975((Object)((class_5321)entry.comp_2542()), entry.method_34979().method_34976());
        }
        this.lootTablesToEject = builder.method_34974();
    }

    @Override
    public void setPossibleRewards(Map<LootTable, Integer> rewards) {
        if (rewards == null || rewards.isEmpty()) {
            this.lootTablesToEject = class_6005.method_38062();
            return;
        }
        class_6005.class_6006 builder = class_6005.method_34971();
        rewards.forEach((table, weight) -> {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
            builder.method_34975(CraftLootTable.bukkitToMinecraft(table), weight.intValue());
        });
        this.lootTablesToEject = builder.method_34974();
    }

    @Override
    public int getRequiredPlayerRange() {
        return this.snapshot.field_47355.method_58707();
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.snapshot.field_47355.field_50183 = requiredPlayerRange;
    }

    private class_8966 getTrialData() {
        return this.snapshot.method_55150().method_55174();
    }

    protected class_8965 toMinecraft() {
        return new class_8965(this.spawnRange, this.totalMobs, this.simultaneousMobs, this.totalMobsAddedPerPlayer, this.simultaneousMobsAddedPerPlayer, this.ticksBetweenSpawn, this.spawnPotentialsDefinition, this.lootTablesToEject, this.itemsToDropWhenOminous);
    }
}

