/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_2629;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final class_3213 handle;
    private Map<BarFlag, FlagContainer> flags;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new class_3213(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CraftBossBar(class_3213 bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(this, () -> ((class_3213)this.handle).method_5417(), arg_0 -> ((class_3213)this.handle).method_5406(arg_0)));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(this, () -> ((class_3213)this.handle).method_5418(), arg_0 -> ((class_3213)this.handle).method_5410(arg_0)));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(this, () -> ((class_3213)this.handle).method_5419(), arg_0 -> ((class_3213)this.handle).method_5411(arg_0)));
    }

    private BarColor convertColor(class_1259.class_1260 color) {
        BarColor bukkitColor = BarColor.valueOf(color.name());
        return bukkitColor == null ? BarColor.WHITE : bukkitColor;
    }

    private class_1259.class_1260 convertColor(BarColor color) {
        class_1259.class_1260 nmsColor = class_1259.class_1260.valueOf((String)color.name());
        return nmsColor == null ? class_1259.class_1260.field_5786 : nmsColor;
    }

    private class_1259.class_1261 convertStyle(BarStyle style) {
        switch (style) {
            default: {
                return class_1259.class_1261.field_5795;
            }
            case SEGMENTED_6: {
                return class_1259.class_1261.field_5796;
            }
            case SEGMENTED_10: {
                return class_1259.class_1261.field_5791;
            }
            case SEGMENTED_12: {
                return class_1259.class_1261.field_5793;
            }
            case SEGMENTED_20: 
        }
        return class_1259.class_1261.field_5790;
    }

    private BarStyle convertStyle(class_1259.class_1261 style) {
        switch (style) {
            default: {
                return BarStyle.SOLID;
            }
            case field_5796: {
                return BarStyle.SEGMENTED_6;
            }
            case field_5791: {
                return BarStyle.SEGMENTED_10;
            }
            case field_5793: {
                return BarStyle.SEGMENTED_12;
            }
            case field_5790: 
        }
        return BarStyle.SEGMENTED_20;
    }

    @Override
    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.field_5777);
    }

    @Override
    public void setTitle(String title) {
        this.handle.field_5777 = CraftChatMessage.fromString(title, true)[0];
        this.handle.method_14090(class_2629::method_34096);
    }

    @Override
    public BarColor getColor() {
        return this.convertColor(this.handle.field_5778);
    }

    @Override
    public void setColor(BarColor color) {
        this.handle.field_5778 = this.convertColor(color);
        this.handle.method_14090(class_2629::method_34097);
    }

    @Override
    public BarStyle getStyle() {
        return this.convertStyle(this.handle.field_5779);
    }

    @Override
    public void setStyle(BarStyle style) {
        this.handle.field_5779 = this.convertStyle(style);
        this.handle.method_14090(class_2629::method_34097);
    }

    @Override
    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    @Override
    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    @Override
    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            return flagContainer.get.get();
        }
        return false;
    }

    @Override
    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.method_5408((float)progress);
    }

    @Override
    public double getProgress() {
        return this.handle.method_5412();
    }

    @Override
    public void addPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        Preconditions.checkArgument((((CraftPlayer)player).getHandle().field_13987 != null ? 1 : 0) != 0, (Object)"player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.method_14088(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        this.handle.method_14089(((CraftPlayer)player).getHandle());
    }

    @Override
    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (class_3222 p : this.handle.method_14092()) {
            players.add((Object)p.getBukkitEntity());
        }
        return players.build();
    }

    @Override
    public void setVisible(boolean visible) {
        this.handle.method_14091(visible);
    }

    @Override
    public boolean isVisible() {
        return this.handle.field_13912;
    }

    @Override
    public void show() {
        this.handle.method_14091(true);
    }

    @Override
    public void hide() {
        this.handle.method_14091(false);
    }

    @Override
    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public class_3213 getHandle() {
        return this.handle;
    }

    private final class FlagContainer {
        private Supplier<Boolean> get;
        private Consumer<Boolean> set;

        private FlagContainer(CraftBossBar craftBossBar, Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

