/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.enchantments;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends Enchantment
implements Handleable<class_1887> {
    private final NamespacedKey key;
    private final class_6880<class_1887> handle;
    private final int id;

    public static Enchantment minecraftToBukkit(class_1887 minecraft) {
        return CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41265, Registry.ENCHANTMENT);
    }

    public static Enchantment minecraftHolderToBukkit(class_6880<class_1887> minecraft) {
        return CraftEnchantment.minecraftToBukkit((class_1887)minecraft.comp_349());
    }

    public static class_1887 bukkitToMinecraft(Enchantment bukkit) {
        return (class_1887)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_1887> bukkitToMinecraftHolder(Enchantment bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, class_7924.field_41265);
    }

    public static String bukkitToString(Enchantment bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static Enchantment stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEnchantmentName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString(string);
        return CraftRegistry.get(Registry.ENCHANTMENT, key, ApiVersion.CURRENT);
    }

    public CraftEnchantment(NamespacedKey key, class_1887 handle) {
        this.key = key;
        this.handle = CraftRegistry.getMinecraftRegistry(class_7924.field_41265).method_47983((Object)handle);
        this.id = CraftRegistry.getMinecraftRegistry(class_7924.field_41265).method_10206((Object)handle);
    }

    @Override
    public class_1887 getHandle() {
        return (class_1887)this.handle.comp_349();
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public int getMaxLevel() {
        return this.getHandle().method_8183();
    }

    @Override
    public int getStartLevel() {
        return this.getHandle().method_8187();
    }

    @Override
    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    @Override
    public boolean isTreasure() {
        return !this.handle.method_40220(class_9636.field_51547);
    }

    @Override
    public boolean isCursed() {
        return this.handle.method_40220(class_9636.field_51551);
    }

    @Override
    public boolean canEnchantItem(ItemStack item) {
        return this.getHandle().method_8192(CraftItemStack.asNMSCopy(item));
    }

    @Override
    public String getName() {
        return switch (this.id) {
            case 0 -> "PROTECTION_ENVIRONMENTAL";
            case 1 -> "PROTECTION_FIRE";
            case 2 -> "PROTECTION_FALL";
            case 3 -> "PROTECTION_EXPLOSIONS";
            case 4 -> "PROTECTION_PROJECTILE";
            case 5 -> "OXYGEN";
            case 6 -> "WATER_WORKER";
            case 7 -> "THORNS";
            case 8 -> "DEPTH_STRIDER";
            case 9 -> "FROST_WALKER";
            case 10 -> "BINDING_CURSE";
            case 11 -> "SOUL_SPEED";
            case 12 -> "SWIFT_SNEAK";
            case 13 -> "DAMAGE_ALL";
            case 14 -> "DAMAGE_UNDEAD";
            case 15 -> "DAMAGE_ARTHROPODS";
            case 16 -> "KNOCKBACK";
            case 17 -> "FIRE_ASPECT";
            case 18 -> "LOOT_BONUS_MOBS";
            case 19 -> "SWEEPING_EDGE";
            case 20 -> "DIG_SPEED";
            case 21 -> "SILK_TOUCH";
            case 22 -> "DURABILITY";
            case 23 -> "LOOT_BONUS_BLOCKS";
            case 24 -> "ARROW_DAMAGE";
            case 25 -> "ARROW_KNOCKBACK";
            case 26 -> "ARROW_FIRE";
            case 27 -> "ARROW_INFINITE";
            case 28 -> "LUCK";
            case 29 -> "LURE";
            case 30 -> "LOYALTY";
            case 31 -> "IMPALING";
            case 32 -> "RIPTIDE";
            case 33 -> "CHANNELING";
            case 34 -> "MULTISHOT";
            case 35 -> "QUICK_CHARGE";
            case 36 -> "PIERCING";
            case 37 -> "DENSITY";
            case 38 -> "BREACH";
            case 39 -> "WIND_BURST";
            case 40 -> "MENDING";
            case 41 -> "VANISHING_CURSE";
            default -> this.getKey().toString();
        };
    }

    @Override
    public boolean conflictsWith(Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !class_1887.method_60033(this.handle, ench.handle);
    }

    @Override
    public String getTranslationKey() {
        return class_156.method_646((String)"enchantment", (class_2960)((class_5321)this.handle.method_40230().get()).method_29177());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        return this.getKey().equals(((Enchantment)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftEnchantment[" + String.valueOf(this.getKey()) + "]";
    }
}

